/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.swf.types;

import flash.swf.types.Matrix;

public class FXGMatrix {
    private double a;
    private double b;
    private double c;
    private double d;
    private double tx;
    private double ty;

    public FXGMatrix(double a, double b, double c, double d, double tx, double ty) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.tx = tx;
        this.ty = ty;
    }

    public FXGMatrix() {
        this.identity();
    }

    public void identity() {
        this.a = 1.0;
        this.b = 0.0;
        this.c = 0.0;
        this.d = 1.0;
        this.tx = 0.0;
        this.ty = 0.0;
    }

    public void concat(FXGMatrix m) {
        double new_a = this.a * m.a + this.b * m.c;
        double new_b = this.a * m.b + this.b * m.d;
        double new_c = this.c * m.a + this.d * m.c;
        double new_d = this.c * m.b + this.d * m.d;
        double new_tx = this.tx * m.a + this.ty * m.c + m.tx;
        double new_ty = this.tx * m.b + this.ty * m.d + m.ty;
        this.a = new_a;
        this.b = new_b;
        this.c = new_c;
        this.d = new_d;
        this.tx = new_tx;
        this.ty = new_ty;
    }

    public void rotate(double angle) {
        double cos = Math.cos(angle * Math.PI / 180.0);
        double sin = Math.sin(angle * Math.PI / 180.0);
        FXGMatrix newM = new FXGMatrix(cos, sin, -sin, cos, 0.0, 0.0);
        this.concat(newM);
    }

    public void scale(double scaleX, double scaleY) {
        FXGMatrix newM = new FXGMatrix(scaleX, 0.0, 0.0, scaleY, 0.0, 0.0);
        this.concat(newM);
    }

    public void translate(double dx, double dy) {
        this.tx += dx;
        this.ty += dy;
    }

    public boolean invert() {
        if (this.b == 0.0 && this.c == 0.0) {
            this.a = 1.0 / this.a;
            this.d = 1.0 / this.d;
            this.c = 0.0;
            this.b = 0.0;
            this.tx = -this.a * this.tx;
            this.ty = -this.d * this.ty;
        } else {
            double a0 = this.a;
            double a3 = this.d;
            double a1 = this.b;
            double a2 = this.c;
            double det = a0 * a3 - a1 * a2;
            if (det == 0.0) {
                return false;
            }
            det = 1.0 / det;
            this.a = a3 * det;
            this.b = -a1 * det;
            this.c = -a2 * det;
            this.d = a0 * det;
        }
        return true;
    }

    public static FXGMatrix convertToMatrix(double scaleX, double scaleY, double rotation, double tx, double ty) {
        FXGMatrix m = new FXGMatrix();
        m.scale(scaleX, scaleY);
        m.rotate(rotation);
        m.translate(tx, ty);
        return m;
    }

    public Matrix toSWFMatrix() {
        Matrix sm = new Matrix();
        if (this.b != 0.0 || this.c != 0.0) {
            sm.hasRotate = true;
        }
        if (this.a != 0.0 || this.d != 0.0) {
            sm.hasScale = true;
        }
        sm.scaleX = (int)(this.a * 65536.0);
        sm.scaleY = (int)(this.d * 65536.0);
        sm.rotateSkew0 = (int)(this.b * 65536.0);
        sm.rotateSkew1 = (int)(this.c * 65536.0);
        sm.translateX = (int)this.tx * 20;
        sm.translateY = (int)this.ty * 20;
        return sm;
    }
}

