/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.internal.fxg.dom.AbstractFXGNode;
import com.adobe.internal.fxg.dom.DefinitionNode;
import com.adobe.internal.fxg.dom.GraphicContentNode;
import com.adobe.internal.fxg.dom.GroupNode;
import com.adobe.internal.fxg.dom.LibraryNode;
import com.adobe.internal.fxg.dom.MaskPropertyNode;
import com.adobe.internal.fxg.dom.MaskableNode;
import com.adobe.internal.fxg.dom.MaskingNode;
import com.adobe.internal.fxg.dom.PlaceObjectNode;
import com.adobe.internal.fxg.dom.types.MaskType;
import com.adobe.internal.fxg.dom.types.ScalingGrid;
import java.util.ArrayList;
import java.util.List;

public class GraphicNode
extends AbstractFXGNode
implements MaskableNode {
    public double scaleGridLeft = 0.0;
    public double scaleGridTop = 0.0;
    public double scaleGridRight = 0.0;
    public double scaleGridBottom = 0.0;
    public double viewWidth = Double.NaN;
    public double viewHeight = Double.NaN;
    public double version;
    public MaskType maskType = MaskType.CLIP;
    public List<GraphicContentNode> children;
    public LibraryNode library;
    public MaskingNode mask;
    private boolean definesScaleGrid;
    private boolean insideScaleGrid;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addChild(FXGNode child) {
        if (child instanceof MaskPropertyNode) {
            this.mask = ((MaskPropertyNode)child).mask;
            return;
        } else if (child instanceof LibraryNode) {
            if (this.library != null) throw new FXGException(child.getStartLine(), child.getStartColumn(), "MultipleLibraryElements", new Object[0]);
            this.library = (LibraryNode)child;
            return;
        } else if (child instanceof GraphicContentNode) {
            if (this.children == null) {
                this.children = new ArrayList<GraphicContentNode>();
            }
            if (child instanceof GroupNode) {
                GroupNode group = (GroupNode)child;
                if (this.insideScaleGrid) {
                    group.setInsideScaleGrid(true);
                }
            }
            this.children.add((GraphicContentNode)child);
            return;
        } else {
            super.addChild(child);
        }
    }

    public String getNodeName() {
        return "Graphic";
    }

    public void setAttribute(String name, String value) {
        if ("scaleGridLeft".equals(name)) {
            this.scaleGridLeft = this.parseDouble(value);
            this.insideScaleGrid = true;
        } else if ("scaleGridTop".equals(name)) {
            this.scaleGridTop = this.parseDouble(value);
            this.insideScaleGrid = true;
        } else if ("scaleGridRight".equals(name)) {
            this.scaleGridRight = this.parseDouble(value);
            this.insideScaleGrid = true;
        } else if ("scaleGridBottom".equals(name)) {
            this.scaleGridBottom = this.parseDouble(value);
            this.insideScaleGrid = true;
        } else if ("viewWidth".equals(name)) {
            this.viewWidth = this.parseDouble(value);
        } else if ("viewHeight".equals(name)) {
            this.viewHeight = this.parseDouble(value);
        } else if ("version".equals(name)) {
            this.version = this.parseDouble(value);
        } else if ("maskType".equals(name)) {
            this.maskType = this.parseMaskType(value);
        } else {
            super.setAttribute(name, value);
        }
    }

    public MaskingNode getMask() {
        return this.mask;
    }

    public MaskType getMaskType() {
        return this.maskType;
    }

    public PlaceObjectNode getDefinitionInstance(String name) {
        DefinitionNode definition;
        PlaceObjectNode instance = null;
        if (this.library != null && (definition = this.library.getDefinition(name)) != null) {
            instance = new PlaceObjectNode();
            instance.definition = definition;
        }
        return instance;
    }

    public ScalingGrid getScalingGrid() {
        ScalingGrid scalingGrid = null;
        if (this.definesScaleGrid()) {
            scalingGrid = new ScalingGrid();
            scalingGrid.scaleGridLeft = this.scaleGridLeft;
            scalingGrid.scaleGridTop = this.scaleGridTop;
            scalingGrid.scaleGridRight = this.scaleGridRight;
            scalingGrid.scaleGridBottom = this.scaleGridBottom;
        }
        return scalingGrid;
    }

    public boolean definesScaleGrid() {
        return this.definesScaleGrid;
    }

    public boolean isInsideScaleGrid() {
        return this.insideScaleGrid;
    }
}

