/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.internal.fxg.dom.AbstractFXGNode;
import com.adobe.internal.fxg.dom.FilterNode;
import com.adobe.internal.fxg.dom.GraphicContext;
import com.adobe.internal.fxg.dom.MaskPropertyNode;
import com.adobe.internal.fxg.dom.MaskableNode;
import com.adobe.internal.fxg.dom.MaskingNode;
import com.adobe.internal.fxg.dom.transforms.ColorTransformNode;
import com.adobe.internal.fxg.dom.transforms.MatrixNode;
import com.adobe.internal.fxg.dom.types.BlendMode;
import com.adobe.internal.fxg.dom.types.MaskType;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;

public abstract class GraphicContentNode
extends AbstractFXGNode
implements MaskableNode {
    protected String id;
    public boolean visible = true;
    public double x = 0.0;
    public double y = 0.0;
    public double scaleX = 1.0;
    public double scaleY = 1.0;
    public double rotation = 0.0;
    public double alpha = 1.0;
    public BlendMode blendMode = BlendMode.LAYER;
    public MaskType maskType = MaskType.CLIP;
    protected boolean translateSet;
    protected boolean scaleSet;
    protected boolean rotationSet;
    protected boolean alphaSet;
    protected boolean blendModeSet;
    protected boolean maskTypeSet;
    public List<FilterNode> filters;
    public MaskingNode mask;
    public MatrixNode matrix;
    public ColorTransformNode colorTransform;
    private GraphicContext parentGraphicContext;

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public void addChild(FXGNode child) {
        if (child instanceof FilterNode) {
            if (this.filters == null) {
                this.filters = new ArrayList<FilterNode>();
            }
            this.filters.add((FilterNode)child);
        } else if (child instanceof MaskPropertyNode) {
            this.mask = ((MaskPropertyNode)child).mask;
            if (this.mask instanceof GraphicContentNode) {
                ((GraphicContentNode)((Object)this.mask)).setParentGraphicContext(this.createGraphicContext());
            }
        } else if (child instanceof MatrixNode) {
            if (this.translateSet || this.scaleSet || this.rotationSet) {
                throw new FXGException(child.getStartLine(), child.getStartColumn(), "InvalidChildMatrixNode", new Object[0]);
            }
            this.matrix = (MatrixNode)child;
        } else if (child instanceof ColorTransformNode) {
            if (this.alphaSet) {
                throw new FXGException(child.getStartLine(), child.getStartColumn(), "InvalidChildColorTransformNode", new Object[0]);
            }
            this.colorTransform = (ColorTransformNode)child;
        } else {
            super.addChild(child);
        }
    }

    public void setAttribute(String name, String value) {
        if ("x".equals(name)) {
            this.x = this.parseDouble(value);
            this.translateSet = true;
        } else if ("y".equals(name)) {
            this.y = this.parseDouble(value);
            this.translateSet = true;
        } else if ("rotation".equals(name)) {
            this.rotation = this.parseDouble(value);
            this.rotationSet = true;
        } else if ("scaleX".equals(name)) {
            this.scaleX = this.parseDouble(value);
            this.scaleSet = true;
        } else if ("scaleY".equals(name)) {
            this.scaleY = this.parseDouble(value);
            this.scaleSet = true;
        } else if ("alpha".equals(name)) {
            this.alpha = this.parseDouble(value, 0.0, 1.0);
            this.alphaSet = true;
        } else if ("blendMode".equals(name)) {
            this.blendMode = this.parseBlendMode(value);
            this.blendModeSet = true;
        } else if ("visible".equals(name)) {
            this.visible = this.parseBoolean(value);
        } else if ("id".equals(name)) {
            this.id = value;
        } else if ("maskType".equals(name)) {
            this.maskType = this.parseMaskType(value);
            this.maskTypeSet = true;
        } else {
            super.setAttribute(name, value);
        }
    }

    public MaskingNode getMask() {
        return this.mask;
    }

    public MaskType getMaskType() {
        return this.maskType;
    }

    public GraphicContext createGraphicContext() {
        GraphicContext graphicContext = new GraphicContext();
        if (this.parentGraphicContext != null) {
            graphicContext.scalingGrid = this.parentGraphicContext.scalingGrid;
        }
        AffineTransform transform = graphicContext.getAffineTransform();
        if (this.matrix != null) {
            AffineTransform t = this.matrix.toAffineTransform();
            transform.concatenate(t);
        } else {
            if (this.translateSet) {
                transform.translate(this.x, this.y);
            }
            if (this.scaleSet) {
                transform.scale(this.scaleX, this.scaleY);
            }
            if (this.rotationSet) {
                transform.rotate((360.0 - this.rotation) / 180.0 * Math.PI);
            }
        }
        if (this.colorTransform != null) {
            graphicContext.colorTransform = this.colorTransform;
        } else if (this.alphaSet) {
            if (graphicContext.colorTransform == null) {
                graphicContext.colorTransform = new ColorTransformNode();
            }
            graphicContext.colorTransform.alphaMultiplier = this.alpha;
        }
        if (this.blendModeSet) {
            graphicContext.blendMode = this.blendMode;
        }
        if (this.filters != null) {
            graphicContext.addFilters(this.filters);
        }
        if (this.maskTypeSet) {
            graphicContext.maskType = this.maskType;
        } else if (this.parentGraphicContext != null) {
            graphicContext.maskType = this.parentGraphicContext.maskType;
        }
        return graphicContext;
    }

    public void setParentGraphicContext(GraphicContext context) {
        this.parentGraphicContext = context;
    }

    protected BlendMode parseBlendMode(String value) {
        if ("add".equals(value)) {
            return BlendMode.ADD;
        }
        if ("alpha".equals(value)) {
            return BlendMode.ALPHA;
        }
        if ("darken".equals(value)) {
            return BlendMode.DARKEN;
        }
        if ("difference".equals(value)) {
            return BlendMode.DIFFERENCE;
        }
        if ("erase".equals(value)) {
            return BlendMode.ERASE;
        }
        if ("hardlight".equals(value)) {
            return BlendMode.HARDLIGHT;
        }
        if ("invert".equals(value)) {
            return BlendMode.INVERT;
        }
        if ("layer".equals(value)) {
            return BlendMode.LAYER;
        }
        if ("lighten".equals(value)) {
            return BlendMode.LIGHTEN;
        }
        if ("multiply".equals(value)) {
            return BlendMode.MULTIPLY;
        }
        if ("normal".equals(value)) {
            return BlendMode.NORMAL;
        }
        if ("overlay".equals(value)) {
            return BlendMode.OVERLAY;
        }
        if ("screen".equals(value)) {
            return BlendMode.SCREEN;
        }
        if ("subtract".equals(value)) {
            return BlendMode.SUBTRACT;
        }
        throw new FXGException(this.getStartLine(), this.getStartColumn(), "UnknownBlendMode", value);
    }
}

