/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom.richtext;

import com.adobe.internal.fxg.dom.DOMParserHelper;
import com.adobe.internal.fxg.dom.richtext.AbstractRichTextLeafNode;
import com.adobe.internal.fxg.dom.richtext.TextHelper;
import com.adobe.internal.fxg.dom.types.Direction;
import com.adobe.internal.fxg.dom.types.JustificationRule;
import com.adobe.internal.fxg.dom.types.JustificationStyle;
import com.adobe.internal.fxg.dom.types.LeadingModel;
import com.adobe.internal.fxg.dom.types.TextAlign;
import com.adobe.internal.fxg.dom.types.TextJustify;

public abstract class AbstractRichParagraphNode
extends AbstractRichTextLeafNode {
    protected static final double PARAGRAPH_INDENT_MIN_INCLUSIVE = 0.0;
    protected static final double PARAGRAPH_INDENT_MAX_INCLUSIVE = 1000.0;
    protected static final double PARAGRAPH_SPACE_MIN_INCLUSIVE = 0.0;
    protected static final double PARAGRAPH_SPACE_MAX_INCLUSIVE = 1000.0;
    protected static final double TEXTINDENT_MIN_INCLUSIVE = -1000.0;
    protected static final double TEXTINDENT_MAX_INCLUSIVE = 1000.0;
    public TextAlign textAlign = TextAlign.START;
    public TextAlign textAlignLast = TextAlign.START;
    public double textIndent = 0.0;
    public double paragraphStartIndent = 0.0;
    public double paragraphEndIndent = 0.0;
    public double paragraphSpaceBefore = 0.0;
    public double paragraphSpaceAfter = 0.0;
    public Direction direction = Direction.LTR;
    public JustificationRule justificationRule = JustificationRule.AUTO;
    public JustificationStyle justificationStyle = JustificationStyle.PRIORITIZELEASTADJUSTMENT;
    public TextJustify textJustify = TextJustify.INTERWORD;
    public LeadingModel leadingModel = LeadingModel.AUTO;
    public String tabStops = "";

    public void setAttribute(String name, String value) {
        if ("textAlign".equals(name)) {
            this.textAlign = TextHelper.getTextAlign(this, value);
        } else if ("textAlignLast".equals(name)) {
            this.textAlignLast = TextHelper.getTextAlign(this, value);
        } else if ("textIndent".equals(name)) {
            this.textIndent = DOMParserHelper.parseDouble(this, value, name, -1000.0, 1000.0, this.textIndent);
        } else if ("paragraphStartIndent".equals(name)) {
            this.paragraphStartIndent = DOMParserHelper.parseDouble(this, value, name, 0.0, 1000.0, this.paragraphStartIndent);
        } else if ("paragraphEndIndent".equals(name)) {
            this.paragraphEndIndent = DOMParserHelper.parseDouble(this, value, name, 0.0, 1000.0, this.paragraphEndIndent);
        } else if ("paragraphSpaceBefore".equals(name)) {
            this.paragraphSpaceBefore = DOMParserHelper.parseDouble(this, value, name, 0.0, 1000.0, this.paragraphSpaceBefore);
        } else if ("paragraphSpaceAfter".equals(name)) {
            this.paragraphSpaceAfter = DOMParserHelper.parseDouble(this, value, name, 0.0, 1000.0, this.paragraphSpaceAfter);
        } else if ("direction".equals(name)) {
            this.direction = TextHelper.getDirection(this, value);
        } else if ("justificationRule".equals(name)) {
            this.justificationRule = TextHelper.getJustificationRule(this, value);
        } else if ("justificationStyle".equals(name)) {
            this.justificationStyle = TextHelper.getJustificationStyle(this, value);
        } else if ("textJustify".equals(name)) {
            this.textJustify = TextHelper.getTextJustify(this, value);
        } else if ("leadingModel".equals(name)) {
            this.leadingModel = TextHelper.getLeadingModel(this, value);
        } else if ("tabStops".equals(name)) {
            this.tabStops = value;
        } else {
            super.setAttribute(name, value);
            return;
        }
        this.rememberAttribute(name, value);
    }
}

