/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.internal.fxg.dom.CDATANode;
import com.adobe.internal.fxg.dom.DOMParserHelper;
import com.adobe.internal.fxg.dom.GraphicContentNode;
import com.adobe.internal.fxg.dom.TextNode;
import com.adobe.internal.fxg.dom.richtext.AbstractRichTextNode;
import com.adobe.internal.fxg.dom.richtext.BRNode;
import com.adobe.internal.fxg.dom.richtext.DivNode;
import com.adobe.internal.fxg.dom.richtext.ImgNode;
import com.adobe.internal.fxg.dom.richtext.LinkNode;
import com.adobe.internal.fxg.dom.richtext.ParagraphNode;
import com.adobe.internal.fxg.dom.richtext.SpanNode;
import com.adobe.internal.fxg.dom.richtext.TCYNode;
import com.adobe.internal.fxg.dom.richtext.TabNode;
import com.adobe.internal.fxg.dom.richtext.TextHelper;
import com.adobe.internal.fxg.dom.richtext.TextLayoutFormatNode;
import com.adobe.internal.fxg.dom.types.AlignmentBaseline;
import com.adobe.internal.fxg.dom.types.BaselineOffset;
import com.adobe.internal.fxg.dom.types.BaselineShift;
import com.adobe.internal.fxg.dom.types.BlockProgression;
import com.adobe.internal.fxg.dom.types.BreakOpportunity;
import com.adobe.internal.fxg.dom.types.ColorWithEnum;
import com.adobe.internal.fxg.dom.types.DigitCase;
import com.adobe.internal.fxg.dom.types.DigitWidth;
import com.adobe.internal.fxg.dom.types.Direction;
import com.adobe.internal.fxg.dom.types.DominantBaseline;
import com.adobe.internal.fxg.dom.types.FontStyle;
import com.adobe.internal.fxg.dom.types.FontWeight;
import com.adobe.internal.fxg.dom.types.JustificationRule;
import com.adobe.internal.fxg.dom.types.JustificationStyle;
import com.adobe.internal.fxg.dom.types.Kerning;
import com.adobe.internal.fxg.dom.types.LeadingModel;
import com.adobe.internal.fxg.dom.types.LigatureLevel;
import com.adobe.internal.fxg.dom.types.LineBreak;
import com.adobe.internal.fxg.dom.types.NumberAuto;
import com.adobe.internal.fxg.dom.types.NumberInherit;
import com.adobe.internal.fxg.dom.types.TextAlign;
import com.adobe.internal.fxg.dom.types.TextDecoration;
import com.adobe.internal.fxg.dom.types.TextJustify;
import com.adobe.internal.fxg.dom.types.TextRotation;
import com.adobe.internal.fxg.dom.types.TypographicCase;
import com.adobe.internal.fxg.dom.types.VerticalAlign;
import com.adobe.internal.fxg.dom.types.WhiteSpaceCollapse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RichTextNode
extends GraphicContentNode
implements TextNode {
    protected static final double FONTSIZE_MIN_INCLUSIVE = 1.0;
    protected static final double FONTSIZE_MAX_INCLUSIVE = 720.0;
    protected static final double PADDING_MIN_INCLUSIVE = 0.0;
    protected static final double PADDING_MAX_INCLUSIVE = 1000.0;
    protected static final double BASELINEOFFSET_MIN_INCLUSIVE = 0.0;
    protected static final double BASELINEOFFSET_MAX_INCLUSIVE = 1000.0;
    protected static final double BASELINESHIFT_MIN_INCLUSIVE = -1000.0;
    protected static final double BASELINESHIFT_MAX_INCLUSIVE = 1000.0;
    protected static final int COLUMNCOUNT_MIN_INCLUSIVE = 0;
    protected static final int COLUMNCOUNT_MAX_INCLUSIVE = 50;
    protected static final double COLUMNGAP_MIN_INCLUSIVE = 0.0;
    protected static final double COLUMNGAP_MAX_INCLUSIVE = 1000.0;
    protected static final double COLUMNWIDTH_MIN_INCLUSIVE = 0.0;
    protected static final double COLUMNWIDTH_MAX_INCLUSIVE = 8000.0;
    protected static final double LINEHEIGHT_PERCENT_MIN_INCLUSIVE = -1000.0;
    protected static final double LINEHEIGHT_PERCENT_MAX_INCLUSIVE = 1000.0;
    protected static final double LINEHEIGHT_PIXEL_MIN_INCLUSIVE = -720.0;
    protected static final double LINEHEIGHT_PIXEL_MAX_INCLUSIVE = 720.0;
    protected static final double PARAGRAPH_INDENT_MIN_INCLUSIVE = 0.0;
    protected static final double PARAGRAPH_INDENT_MAX_INCLUSIVE = 1000.0;
    protected static final double PARAGRAPH_SPACE_MIN_INCLUSIVE = 0.0;
    protected static final double PARAGRAPH_SPACE_MAX_INCLUSIVE = 1000.0;
    protected static final double TEXTINDENT_MIN_INCLUSIVE = -1000.0;
    protected static final double TEXTINDENT_MAX_INCLUSIVE = 1000.0;
    protected static final double TRACKING_MIN_INCLUSIVE = -1000.0;
    protected static final double TRACKING_MAX_INCLUSIVE = 1000.0;
    public double width = 0.0;
    public double height = 0.0;
    public BlockProgression blockProgression = BlockProgression.TB;
    public NumberInherit paddingLeft = NumberInherit.newInstance(0.0);
    public NumberInherit paddingRight = NumberInherit.newInstance(0.0);
    public NumberInherit paddingTop = NumberInherit.newInstance(0.0);
    public NumberInherit paddingBottom = NumberInherit.newInstance(0.0);
    public LineBreak lineBreak = LineBreak.TOFIT;
    public NumberInherit columnGap = NumberInherit.newInstance(20.0);
    public NumberAuto columnCount = NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.AUTO);
    public NumberAuto columnWidth = NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.AUTO);
    public BaselineOffset firstBaselineOffset = BaselineOffset.newInstance(BaselineOffset.BaselineOffsetAsEnum.AUTO);
    public VerticalAlign verticalAlign = VerticalAlign.TOP;
    public TextAlign textAlign = TextAlign.START;
    public TextAlign textAlignLast = TextAlign.START;
    public double textIndent = 0.0;
    public double paragraphStartIndent = 0.0;
    public double paragraphEndIndent = 0.0;
    public double paragraphSpaceBefore = 0.0;
    public double paragraphSpaceAfter = 0.0;
    public Direction direction = Direction.LTR;
    public JustificationRule justificationRule = JustificationRule.AUTO;
    public JustificationStyle justificationStyle = JustificationStyle.PRIORITIZELEASTADJUSTMENT;
    public TextJustify textJustify = TextJustify.INTERWORD;
    public LeadingModel leadingModel = LeadingModel.AUTO;
    public String tabStops = "";
    public String fontFamily = "Arial";
    public double fontSize = 12.0;
    public FontStyle fontStyle = FontStyle.NORMAL;
    public FontWeight fontWeight = FontWeight.NORMAL;
    public Kerning kerning = Kerning.AUTO;
    public double lineHeight = 120.0;
    public TextDecoration textDecoration = TextDecoration.NONE;
    public boolean lineThrough = false;
    public int color = -16777216;
    public double textAlpha = 1.0;
    public WhiteSpaceCollapse whiteSpaceCollapse = WhiteSpaceCollapse.COLLAPSE;
    public NumberInherit backgroundAlpha = NumberInherit.newInstance(1.0);
    public ColorWithEnum backgroundColor = ColorWithEnum.newInstance(ColorWithEnum.ColorEnum.TRANSPARENT);
    public BaselineShift baselineShift = BaselineShift.newInstance(0.0);
    public BreakOpportunity breakOpportunity = BreakOpportunity.AUTO;
    public DigitCase digitCase = DigitCase.DEFAULT;
    public DigitWidth digitWidth = DigitWidth.DEFAULT;
    public DominantBaseline dominantBaseline = DominantBaseline.AUTO;
    public AlignmentBaseline alignmentBaseline = AlignmentBaseline.USEDOMINANTBASELINE;
    public LigatureLevel ligatureLevel = LigatureLevel.COMMON;
    public String locale = "en";
    public TypographicCase typographicCase = TypographicCase.DEFAULT;
    public double trackingLeft = 0.0;
    public double trackingRight = 0.0;
    public TextRotation textRotation = TextRotation.AUTO;
    public TextLayoutFormatNode linkNormalFormat = null;
    public TextLayoutFormatNode linkHoverFormat = null;
    public TextLayoutFormatNode linkActiveFormat = null;
    private boolean contiguous = false;
    protected Map<String, String> textAttributes;
    protected List<TextNode> content;
    protected Map<String, TextNode> properties;

    @Override
    public Map<String, String> getTextAttributes() {
        return this.textAttributes;
    }

    @Override
    public List<TextNode> getTextChildren() {
        return this.content;
    }

    @Override
    public Map<String, TextNode> getTextProperties() {
        return this.properties;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addTextProperty(String propertyName, TextNode node) {
        if (node instanceof TextLayoutFormatNode) {
            if ("linkActiveFormat".equals(propertyName)) {
                if (this.linkActiveFormat != null) throw new FXGException(this.getStartLine(), this.getStartColumn(), "MultipleLinkFormatElements", new Object[0]);
                this.linkActiveFormat = (TextLayoutFormatNode)node;
                this.linkActiveFormat.setParent(this);
                if (this.properties == null) {
                    this.properties = new HashMap<String, TextNode>(3);
                }
                this.properties.put(propertyName, this.linkActiveFormat);
                return;
            } else if ("linkHoverFormat".equals(propertyName)) {
                if (this.linkHoverFormat != null) throw new FXGException(this.getStartLine(), this.getStartColumn(), "MultipleLinkFormatElements", new Object[0]);
                this.linkHoverFormat = (TextLayoutFormatNode)node;
                this.linkHoverFormat.setParent(this);
                if (this.properties == null) {
                    this.properties = new HashMap<String, TextNode>(3);
                }
                this.properties.put(propertyName, this.linkHoverFormat);
                return;
            } else {
                if (!"linkNormalFormat".equals(propertyName)) throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownLinkFormat", propertyName);
                if (this.linkNormalFormat != null) throw new FXGException(this.getStartLine(), this.getStartColumn(), "MultipleLinkFormatElements", new Object[0]);
                this.linkNormalFormat = (TextLayoutFormatNode)node;
                this.linkNormalFormat.setParent(this);
                if (this.properties == null) {
                    this.properties = new HashMap<String, TextNode>(3);
                }
                this.properties.put(propertyName, this.linkNormalFormat);
            }
            return;
        } else {
            this.addChild(node);
        }
    }

    public void addContentChild(FXGNode child) {
        if (child instanceof ParagraphNode || child instanceof DivNode || child instanceof SpanNode || child instanceof BRNode || child instanceof TabNode || child instanceof TCYNode || child instanceof LinkNode || child instanceof ImgNode || child instanceof CDATANode) {
            if (child instanceof LinkNode && ((LinkNode)child).href == null) {
                throw new FXGException(this.getStartLine(), this.getStartColumn(), "MissingHref", new Object[0]);
            }
            if (this.content == null) {
                this.content = new ArrayList<TextNode>();
                this.contiguous = true;
            }
            if (!this.contiguous) {
                throw new FXGException(child.getStartLine(), child.getStartColumn(), "InvalidRichTextContent", new Object[0]);
            }
        } else {
            throw new FXGException(child.getStartLine(), child.getStartColumn(), "InvalidChildNode", child.getNodeName(), this.getNodeName());
        }
        this.content.add((TextNode)child);
        if (child instanceof AbstractRichTextNode) {
            ((AbstractRichTextNode)child).setParent(this);
        }
    }

    protected void rememberAttribute(String name, String value) {
        if (this.textAttributes == null) {
            this.textAttributes = new HashMap<String, String>(4);
        }
        this.textAttributes.put(name, value);
    }

    @Override
    public void addChild(FXGNode child) {
        if (child instanceof CDATANode) {
            if (TextHelper.ignorableWhitespace(((CDATANode)child).content)) {
                return;
            }
            throw new FXGException(child.getStartLine(), child.getStartColumn(), "InvalidRichTextContent", new Object[0]);
        }
        super.addChild(child);
        this.contiguous = false;
    }

    @Override
    public String getNodeName() {
        return "RichText";
    }

    @Override
    public void setAttribute(String name, String value) {
        if ("width".equals(name)) {
            this.width = DOMParserHelper.parseDouble(this, value, name);
        } else if ("height".equals(name)) {
            this.height = DOMParserHelper.parseDouble(this, value, name);
        } else if ("blockProgression".equals(name)) {
            this.blockProgression = TextHelper.getBlockProgression(this, value);
        } else if ("paddingLeft".equals(name)) {
            this.paddingLeft = this.getNumberInherit(this, name, value, 0.0, 1000.0, this.paddingLeft.getNumberInheritAsDbl(), "UnknownPaddingLeft");
        } else if ("paddingRight".equals(name)) {
            this.paddingRight = this.getNumberInherit(this, name, value, 0.0, 1000.0, this.paddingRight.getNumberInheritAsDbl(), "UnknownPaddingRight");
        } else if ("paddingTop".equals(name)) {
            this.paddingTop = this.getNumberInherit(this, name, value, 0.0, 1000.0, this.paddingTop.getNumberInheritAsDbl(), "UnknownPaddingTop");
        } else if ("paddingBottom".equals(name)) {
            this.paddingBottom = this.getNumberInherit(this, name, value, 0.0, 1000.0, this.paddingBottom.getNumberInheritAsDbl(), "UnknownPaddingBottom");
        } else if ("lineBreak".equals(name)) {
            this.lineBreak = TextHelper.getLineBreak(this, value);
        } else if ("columnGap".equals(name)) {
            this.columnGap = this.getNumberInherit(this, name, value, 0.0, 1000.0, this.columnGap.getNumberInheritAsDbl(), "UnknownColumnGap");
        } else if ("columnCount".equals(name)) {
            this.columnCount = this.getNumberAutoInt(this, name, value, 0, 50, this.columnCount.getNumberAutoAsInt(), "UnknownColumnCount");
        } else if ("columnWidth".equals(name)) {
            this.columnWidth = this.getNumberAutoDbl(this, name, value, 0.0, 8000.0, this.columnWidth.getNumberAutoAsDbl(), "UnknownColumnWidth");
        } else if ("firstBaselineOffset".equals(name)) {
            this.firstBaselineOffset = this.getFirstBaselineOffset(this, name, value, 0.0, 1000.0, this.firstBaselineOffset.getBaselineOffsetAsDbl());
        } else if ("verticalAlign".equals(name)) {
            this.verticalAlign = TextHelper.getVerticalAlign(this, value);
        } else if ("textAlign".equals(name)) {
            this.textAlign = TextHelper.getTextAlign(this, value);
        } else if ("textAlignLast".equals(name)) {
            this.textAlignLast = TextHelper.getTextAlign(this, value);
        } else if ("textIndent".equals(name)) {
            this.textIndent = DOMParserHelper.parseDouble(this, value, name, -1000.0, 1000.0, this.textIndent);
        } else if ("paragraphStartIndent".equals(name)) {
            this.paragraphStartIndent = DOMParserHelper.parseDouble(this, value, name, 0.0, 1000.0, this.paragraphStartIndent);
        } else if ("paragraphEndIndent".equals(name)) {
            this.paragraphEndIndent = DOMParserHelper.parseDouble(this, value, name, 0.0, 1000.0, this.paragraphEndIndent);
        } else if ("paragraphSpaceBefore".equals(name)) {
            this.paragraphSpaceBefore = DOMParserHelper.parseDouble(this, value, name, 0.0, 1000.0, this.paragraphSpaceBefore);
        } else if ("paragraphSpaceAfter".equals(name)) {
            this.paragraphSpaceAfter = DOMParserHelper.parseDouble(this, value, name, 0.0, 1000.0, this.paragraphSpaceAfter);
        } else if ("direction".equals(name)) {
            this.direction = TextHelper.getDirection(this, value);
        } else if ("justificationRule".equals(name)) {
            this.justificationRule = TextHelper.getJustificationRule(this, value);
        } else if ("justificationStyle".equals(name)) {
            this.justificationStyle = TextHelper.getJustificationStyle(this, value);
        } else if ("textJustify".equals(name)) {
            this.textJustify = TextHelper.getTextJustify(this, value);
        } else if ("leadingModel".equals(name)) {
            this.leadingModel = TextHelper.getLeadingModel(this, value);
        } else if ("tabStops".equals(name)) {
            this.tabStops = value;
        } else if ("fontFamily".equals(name)) {
            this.fontFamily = value;
        } else if ("fontSize".equals(name)) {
            this.fontSize = DOMParserHelper.parseDouble(this, value, name, 1.0, 720.0, this.fontSize);
        } else if ("fontStyle".equals(name)) {
            this.fontStyle = TextHelper.getFontStyle(this, value);
        } else if ("fontWeight".equals(name)) {
            this.fontWeight = TextHelper.getFontWeight(this, value);
        } else if ("kerning".equals(name)) {
            this.kerning = TextHelper.getKerning(this, value);
        } else if ("lineHeight".equals(name)) {
            this.lineHeight = DOMParserHelper.parseNumberPercentWithSeparateRange(this, value, name, -1000.0, 1000.0, -720.0, 720.0, this.lineHeight);
        } else if ("textDecoration".equals(name)) {
            this.textDecoration = TextHelper.getTextDecoration(this, value);
        } else if ("lineThrough".equals(name)) {
            this.lineThrough = DOMParserHelper.parseBoolean(this, value, name);
        } else if ("color".equals(name)) {
            this.color = DOMParserHelper.parseRGB(this, value, name);
        } else if ("textAlpha".equals(name)) {
            this.textAlpha = DOMParserHelper.parseDouble(this, value, name, 0.0, 1.0, this.textAlpha);
        } else if ("whiteSpaceCollapse".equals(name)) {
            this.whiteSpaceCollapse = TextHelper.getWhiteSpaceCollapse(this, value);
        } else if ("backgroundAlpha".equals(name)) {
            this.backgroundAlpha = this.getAlphaInherit(this, name, value, 0.0, 1.0, this.backgroundAlpha.getNumberInheritAsDbl(), "UnknownBackgroundAlpha");
        } else if ("backgroundColor".equals(name)) {
            this.backgroundColor = this.getColorWithEnum(this, name, value);
        } else if ("baselineShift".equals(name)) {
            this.baselineShift = this.getBaselineShift(this, name, value, -1000.0, 1000.0, this.baselineShift.getBaselineShiftAsDbl());
        } else if ("breakOpportunity".equals(name)) {
            this.breakOpportunity = TextHelper.getBreakOpportunity(this, value);
        } else if ("digitCase".equals(name)) {
            this.digitCase = TextHelper.getDigitCase(this, value);
        } else if ("digitWidth".equals(name)) {
            this.digitWidth = TextHelper.getDigitWidth(this, value);
        } else if ("dominantBaseline".equals(name)) {
            this.dominantBaseline = TextHelper.getDominantBaseline(this, value);
        } else if ("alignmentBaseline".equals(name)) {
            this.alignmentBaseline = TextHelper.getAlignmentBaseline(this, value);
        } else if ("ligatureLevel".equals(name)) {
            this.ligatureLevel = TextHelper.getLigatureLevel(this, value);
        } else if ("locale".equals(name)) {
            this.locale = value;
        } else if ("typographicCase".equals(name)) {
            this.typographicCase = TextHelper.getTypographicCase(this, value);
        } else if ("trackingLeft".equals(name)) {
            this.trackingLeft = DOMParserHelper.parseNumberPercent(this, value, name, -1000.0, 1000.0, this.trackingLeft);
        } else if ("trackingRight".equals(name)) {
            this.trackingRight = DOMParserHelper.parseNumberPercent(this, value, name, -1000.0, 1000.0, this.trackingRight);
        } else if ("textRotation".equals(name)) {
            this.textRotation = TextHelper.getTextRotation(this, value);
        } else if (!"id".equals(name)) {
            super.setAttribute(name, value);
        }
        this.rememberAttribute(name, value);
    }

    private BaselineOffset getFirstBaselineOffset(FXGNode node, String name, String value, double min, double max, double defaultValue) {
        if ("auto".equals(value)) {
            return BaselineOffset.newInstance(BaselineOffset.BaselineOffsetAsEnum.AUTO);
        }
        if ("ascent".equals(value)) {
            return BaselineOffset.newInstance(BaselineOffset.BaselineOffsetAsEnum.ASCENT);
        }
        if ("lineHeight".equals(value)) {
            return BaselineOffset.newInstance(BaselineOffset.BaselineOffsetAsEnum.LINEHEIGHT);
        }
        try {
            return BaselineOffset.newInstance(DOMParserHelper.parseDouble(this, value, name, min, max, defaultValue));
        }
        catch (FXGException e) {
            throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownFirstBaselineOffset", value);
        }
    }

    private NumberAuto getNumberAutoDbl(FXGNode node, String name, String value, double min, double max, double defaultValue, String errorCode) {
        try {
            return NumberAuto.newInstance(DOMParserHelper.parseDouble(this, value, name, min, max, defaultValue));
        }
        catch (FXGException e) {
            if ("auto".equals(value)) {
                return NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.AUTO);
            }
            if ("inherit".equals(value)) {
                return NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.INHERIT);
            }
            throw new FXGException(node.getStartLine(), node.getStartColumn(), errorCode, value);
        }
    }

    private NumberAuto getNumberAutoInt(FXGNode node, String name, String value, int min, int max, int defaultValue, String errorCode) {
        try {
            return NumberAuto.newInstance(DOMParserHelper.parseInt(this, value, name, min, max, defaultValue));
        }
        catch (FXGException e) {
            if ("auto".equals(value)) {
                return NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.AUTO);
            }
            if ("inherit".equals(value)) {
                return NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.INHERIT);
            }
            throw new FXGException(node.getStartLine(), node.getStartColumn(), errorCode, value);
        }
    }

    private NumberInherit getNumberInherit(FXGNode node, String name, String value, double min, double max, double defaultValue, String errorCode) {
        try {
            return NumberInherit.newInstance(DOMParserHelper.parseDouble(this, value, name, min, max, defaultValue));
        }
        catch (FXGException e) {
            if ("inherit".equals(value)) {
                return NumberInherit.newInstance(NumberInherit.NumberInheritAsEnum.INHERIT);
            }
            throw new FXGException(node.getStartLine(), node.getStartColumn(), errorCode, value);
        }
    }

    private BaselineShift getBaselineShift(FXGNode node, String name, String value, double min, double max, double defaultValue) {
        try {
            return BaselineShift.newInstance(DOMParserHelper.parseNumberPercent(this, value, name, min, max, defaultValue));
        }
        catch (FXGException e) {
            if ("superscript".equals(value)) {
                return BaselineShift.newInstance(BaselineShift.BaselineShiftAsEnum.SUPERSCRIPT);
            }
            if ("subscript".equals(value)) {
                return BaselineShift.newInstance(BaselineShift.BaselineShiftAsEnum.SUBSCRIPT);
            }
            throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownBaselineShift", value);
        }
    }

    private NumberInherit getAlphaInherit(FXGNode node, String name, String value, double min, double max, double defaultValue, String errorCode) {
        try {
            return NumberInherit.newInstance(DOMParserHelper.parseDouble(this, value, name, 0.0, 1.0, defaultValue));
        }
        catch (FXGException e) {
            if ("inherit".equals(value)) {
                return NumberInherit.newInstance(NumberInherit.NumberInheritAsEnum.INHERIT);
            }
            throw new FXGException(node.getStartLine(), node.getStartColumn(), errorCode, value);
        }
    }

    private ColorWithEnum getColorWithEnum(FXGNode node, String attribute, String value) {
        if ("transparent".equals(value)) {
            return ColorWithEnum.newInstance(ColorWithEnum.ColorEnum.TRANSPARENT);
        }
        if ("inherit".equals(value)) {
            return ColorWithEnum.newInstance(ColorWithEnum.ColorEnum.INHERIT);
        }
        return ColorWithEnum.newInstance(DOMParserHelper.parseRGB(this, value, attribute));
    }
}

