/*
 * Decompiled with CFR 0.152.
 */
package flash.fonts.flashtype;

import flash.fonts.flashtype.ADFMathUtils;
import flash.fonts.flashtype.ADFTypeSystem;
import java.util.ArrayList;
import java.util.Iterator;

public class ADF {
    static long ADF_VERSION_NUMBER = 1L;
    static final int ADF_X_ALGN_ZONE_BIT = 1;
    static final int ADF_Y_ALGN_ZONE_BIT = 2;
    static final int ADF_NON_LEAF_CELL = 0;
    static final int ADF_ONE_SECTION_CELL = 1;
    static final int ADF_TWO_SECTION_CELL = 2;
    static final int ADF_INWARD_CORNER_CELL = 3;
    static final int ADF_OUTWARD_CORNER_CELL = 4;
    static final int ADF_MAX_OFFSET_SIZE = 0xFFFFFF;
    static final float ADF_INVALID_DIST = -1.0f;
    static final int ADF_MAX_GEN_LEVEL = 15;
    static final short ELM_POS_SLOPE = 1;
    static final short ELM_NEG_SLOPE = -1;
    static final int LINE_ELEMENT = 0;
    static final int CURVE_ELEMENT = 1;
    static final int STD_ORIENTATION = 0;
    static final int INV_ORIENTATION = 1;
    static final int VIRTUAL_CORNER = 0;
    static final int INWARD_CORNER = 1;
    static final int OUTWARD_CORNER = 2;
    static final int CT_MAX_LEVELS = 3;
    static final int CT_MAX_CHILDREN = 6;
    static final int INVALID_FEATURE = 65535;
    static final int LFCELL_ID_ONE_SECTION = 65534;
    static final int LFCELL_ID_TWO_SECTION = 65533;
    static final int LFCELL_ID_INWARD_CORNER = 65532;
    static final int LFCELL_ID_OUTWARD_CORNER = 65531;
    static final int SC_MAX_NUM_SCDATA = 16384;

    static int ADF_PACK_CELL_ATTRS(int type, int offset) {
        return type << 24 | offset;
    }

    static long ADF_UNPACK_CELL_TYPE(long cell) {
        return cell >> 24;
    }

    static int ADF_UNPACK_CELL_OFFSET(long cell) {
        return (int)cell & 0xFFFFFF;
    }

    static Object ADFGenerateADF(Object libInst, ADFTypeSystem.ADFPath path, ADFTypeSystem.ADFGenAttrs genAttrs) {
        if (path == null) {
            return null;
        }
        long oldMaxLevel = genAttrs.maxLevel;
        genAttrs.maxLevel = (long)ADFMathUtils.ADF_MIN(genAttrs.maxLevel, 15.0f);
        ADFGlyph adf = ADF.SCGenerate(path, genAttrs);
        genAttrs.maxLevel = oldMaxLevel;
        return adf;
    }

    static float GetDistFromBiquadraticCell(float[] dists, float x, float y) {
        float xv1 = x - 0.5f;
        float xv2 = x - 1.0f;
        float bx1 = 2.0f * xv1 * xv2;
        float bx2 = -4.0f * x * xv2;
        float bx3 = 2.0f * x * xv1;
        float yv1 = y - 0.5f;
        float yv2 = y - 1.0f;
        float by1 = 2.0f * yv1 * yv2;
        float by2 = -4.0f * y * yv2;
        float by3 = 2.0f * y * yv1;
        float d1 = dists[0];
        float d2 = dists[1];
        float d3 = dists[2];
        float d4 = dists[3];
        float d5 = dists[4];
        float d6 = dists[5];
        float d7 = dists[6];
        float d8 = dists[7];
        float d9 = dists[8];
        float dist = by1 * (bx1 * d1 + bx2 * d2 + bx3 * d3) + by2 * (bx1 * d4 + bx2 * d5 + bx3 * d6) + by3 * (bx1 * d7 + bx2 * d8 + bx3 * d9);
        return dist;
    }

    static float ADFReconstructDist(ADFGlyph adf, int cell, float cellSize, float invCellSize, float minX, float minY, float[] p) {
        long cellType = ADF.ADF_UNPACK_CELL_TYPE(cell);
        int dataOffset = ADF.ADF_UNPACK_CELL_OFFSET(cell);
        if (cellType == 1L) {
            float x = p[0];
            float y = p[1];
            int pDist = 0;
            float[] dist = new float[9];
            float scale = 3.0517578E-5f;
            for (int i = 0; i < 9; ++i) {
                dist[i] = (float)adf.cellsAndDists[dataOffset + pDist++] * scale;
            }
            return ADF.GetDistFromBiquadraticCell(dist, x, y);
        }
        if (cellType == 2L) {
            float x = p[0];
            float y = p[1];
            int pDist = 0;
            float[] dist = new float[18];
            float scale = 3.0517578E-5f;
            for (int i = 0; i < 18; ++i) {
                dist[i] = (float)adf.cellsAndDists[dataOffset + pDist++] * scale;
            }
            float d1 = ADF.GetDistFromBiquadraticCell(dist, x, y);
            float[] dist2 = new float[9];
            System.arraycopy(dist, 9, dist2, 0, 9);
            float d2 = ADF.GetDistFromBiquadraticCell(dist2, x, y);
            if (Math.abs(d1) < Math.abs(d2)) {
                return d1;
            }
            return d2;
        }
        float x = p[0];
        float y = p[1];
        int pDist = 0;
        float[] tan1 = new float[2];
        float[] tan2 = new float[2];
        float[] dist = new float[18];
        float scale = 3.0517578E-5f;
        for (int i = 0; i < 18; ++i) {
            dist[i] = (float)adf.cellsAndDists[dataOffset + pDist++] * scale;
        }
        float dx = x - ((float)adf.cellsAndDists[dataOffset + pDist++] * scale - minX) * invCellSize;
        float dy = y - ((float)adf.cellsAndDists[dataOffset + pDist++] * scale - minY) * invCellSize;
        scale = 6.1035156E-5f;
        tan1[0] = (float)adf.cellsAndDists[dataOffset + pDist++] * scale;
        tan1[1] = (float)adf.cellsAndDists[dataOffset + pDist++] * scale;
        tan2[0] = (float)adf.cellsAndDists[dataOffset + pDist++] * scale;
        tan2[1] = (float)adf.cellsAndDists[dataOffset + pDist++] * scale;
        int valid1 = tan1[0] * dx + tan1[1] * dy > 0.0f ? 1 : 0;
        int valid2 = tan2[0] * dx + tan2[1] * dy > 0.0f ? 1 : 0;
        int region = valid1 << 1 | valid2;
        switch (region) {
            case 3: {
                float d1 = ADF.GetDistFromBiquadraticCell(dist, x, y);
                float[] dist2 = new float[9];
                System.arraycopy(dist, 9, dist2, 0, 9);
                float d2 = ADF.GetDistFromBiquadraticCell(dist2, x, y);
                if (d1 * d1 < d2 * d2) {
                    return d1;
                }
                return d2;
            }
            case 2: {
                return ADF.GetDistFromBiquadraticCell(dist, x, y);
            }
            case 1: {
                float[] dist2 = new float[9];
                System.arraycopy(dist, 9, dist2, 0, 9);
                return ADF.GetDistFromBiquadraticCell(dist2, x, y);
            }
            case 0: {
                float d = (float)Math.sqrt(dx * dx + dy * dy) * cellSize;
                if (cellType == 4L) {
                    d *= -1.0f;
                }
                return d;
            }
        }
        return -1.0f;
    }

    static float ADFReconstructDistAbs(ADFGlyph adf, float[] p) {
        float xq = p[0];
        float yq = p[1];
        float xlo = 0.0f;
        float xhi = 1.0f;
        float ylo = 0.0f;
        float yhi = 1.0f;
        float x = 0.5f;
        float y = 0.5f;
        int cell = adf.cellsAndDists[0];
        while ((cell & 0xFF000000) == 0) {
            if (xq < x) {
                if (yq < y) {
                    xhi = x;
                    yhi = y;
                    x = 0.5f * (xlo + x);
                    y = 0.5f * (ylo + y);
                    cell = adf.cellsAndDists[cell];
                    continue;
                }
                xhi = x;
                ylo = y;
                x = 0.5f * (xlo + x);
                y = 0.5f * (yhi + y);
                cell = adf.cellsAndDists[cell + 2];
                continue;
            }
            if (yq < y) {
                xlo = x;
                yhi = y;
                x = 0.5f * (xhi + x);
                y = 0.5f * (ylo + y);
                cell = adf.cellsAndDists[cell + 1];
                continue;
            }
            xlo = x;
            ylo = y;
            x = 0.5f * (xhi + x);
            y = 0.5f * (yhi + y);
            cell = adf.cellsAndDists[cell + 3];
        }
        float[] cellPt = new float[2];
        float cellSize = xhi - xlo;
        float invCellSize = 1.0f / (xhi - xlo);
        cellPt[0] = (xq - xlo) * invCellSize;
        cellPt[1] = (yq - ylo) * invCellSize;
        float f = ADF.ADFReconstructDist(adf, cell, cellSize, invCellSize, xlo, ylo, cellPt);
        return f;
    }

    static InternPath CreateInternPath(ADFTypeSystem.ADFPath path, ADFTypeSystem.ADFGenAttrs genAttrs) {
        int numElms = 0;
        int numContours = path.numContours;
        ArrayList penCmds = path.penCmds;
        ADFTypeSystem.ADFPenCmd lastPenCmd = null;
        Iterator iterator = penCmds.iterator();
        while (iterator.hasNext()) {
            ADFTypeSystem.ADFPenCmd penCmd = (ADFTypeSystem.ADFPenCmd)iterator.next();
            if (lastPenCmd != null && penCmd.opCode != 0L && (penCmd.x != lastPenCmd.x || penCmd.y != lastPenCmd.y)) {
                ++numElms;
            }
            lastPenCmd = penCmd;
        }
        if (numElms == 0) {
            return null;
        }
        int maxGridLines = (1 << (int)(genAttrs.maxLevel + 1L)) + 1;
        InternPath internPath = new InternPath();
        internPath.numPathElements = numElms;
        internPath.maxGridLines = maxGridLines;
        internPath.elms = new InternPathElm[numElms + 1];
        internPath.contours = new int[numContours];
        internPath.corners = new InternCorner[numElms];
        int size = (1 + numElms) * maxGridLines;
        internPath.crossings = new float[size];
        internPath.crossingTypes = new short[size];
        size = 1 + numElms * 3;
        internPath.clusterTreeRoot = new CTNode[size];
        for (int n = 0; n < maxGridLines; ++n) {
            internPath.crossings[n * (1 + numElms)] = -1.0f;
        }
        ADF.ADFSetGlyphScaleAndOffset(path, internPath);
        ADF.InitInternPath(path, internPath, genAttrs);
        return internPath;
    }

    static void ADFSetGlyphScaleAndOffset(ADFTypeSystem.ADFPath path, InternPath internPath) {
        float fontUnitsToADFScale;
        float shrinkFactorInv = 1.4f;
        float width = path.glyphMaxX - path.glyphMinX;
        float height = path.glyphMaxY - path.glyphMinY;
        float maxExtent = ADFMathUtils.ADF_MAX(width, height);
        if (maxExtent == 0.0f) {
            maxExtent = 1.0f;
        }
        float xOffsetOutline = -path.glyphMinX + 0.5f * ((maxExtent *= shrinkFactorInv) - width);
        float yOffsetOutline = -path.glyphMinY + 0.5f * (maxExtent - height);
        internPath.FUToADFScale = fontUnitsToADFScale = 1.0f / maxExtent;
        internPath.glyphOffsetX = xOffsetOutline * fontUnitsToADFScale;
        internPath.glyphOffsetY = yOffsetOutline * fontUnitsToADFScale;
        internPath.ADFUnitsPerEM = path.fontUnitsPerEM * fontUnitsToADFScale;
    }

    static void InitInternPath(ADFTypeSystem.ADFPath path, InternPath internPath, ADFTypeSystem.ADFGenAttrs genAttrs) {
        long startElmIdx;
        int ctrIdx = 0;
        long numContours = path.numContours;
        int[] contours = internPath.contours;
        float FUToADFScale = internPath.FUToADFScale;
        float xOffset = internPath.glyphOffsetX;
        float yOffset = internPath.glyphOffsetY;
        float deltaOffset = 1.0E-5f;
        ArrayList penCmds = path.penCmds;
        if (path.numPenCmds == 0L) {
            internPath.numPathElements = 0;
            return;
        }
        int elmIdx = 0;
        float x0 = -1.0f;
        float y0 = -1.0f;
        ADFTypeSystem.ADFPenCmd penCmd = null;
        Iterator iterator = penCmds.iterator();
        while (iterator.hasNext()) {
            ADFTypeSystem.ADFPenCmd lastPenCmd = penCmd;
            penCmd = (ADFTypeSystem.ADFPenCmd)iterator.next();
            float x1 = penCmd.x * FUToADFScale + xOffset;
            float y1 = penCmd.y * FUToADFScale + yOffset;
            float y = y1 * 65536.0f;
            y1 = y / 65536.0f + deltaOffset;
            if (penCmd.opCode == 0L) {
                long startElmIdx2;
                long l = startElmIdx2 = ctrIdx == 0 ? 0L : (long)(contours[ctrIdx - 1] + 1);
                if ((long)elmIdx > startElmIdx2) {
                    contours[ctrIdx++] = elmIdx - 1;
                }
                x0 = x1;
                y0 = y1;
                continue;
            }
            InternPathElm elm = internPath.elms[elmIdx];
            if (elm == null) {
                internPath.elms[elmIdx] = elm = new InternPathElm();
            }
            if (lastPenCmd != null && penCmd.x == lastPenCmd.x && penCmd.y == lastPenCmd.y) continue;
            elm.e0[0] = x0;
            elm.e0[1] = y0;
            elm.e1[0] = x1;
            elm.e1[1] = y1;
            if (penCmd.opCode == 1L) {
                float dx = x1 - x0;
                float dy = y1 - y0;
                float length = (float)Math.sqrt(dx * dx + dy * dy);
                if (length != 0.0f) {
                    dx /= length;
                    dy /= length;
                }
                elm.c1 = length;
                elm.v01[0] = dx;
                elm.v01[1] = dy;
                elm.v21[0] = -dx;
                elm.v21[1] = -dy;
                elm.type = 0;
                elm.xMin = ADFMathUtils.ADF_MIN(x0, x1);
                elm.yMin = ADFMathUtils.ADF_MIN(y0, y1);
                elm.xMax = ADFMathUtils.ADF_MAX(x0, x1);
                elm.yMax = ADFMathUtils.ADF_MAX(y0, y1);
            } else {
                float cvX = penCmd.cx * FUToADFScale + xOffset;
                float cvY = penCmd.cy * FUToADFScale + yOffset;
                double[] v01 = new double[]{cvX - x0, cvY - y0};
                double[] v21 = new double[]{cvX - x1, cvY - y1};
                double[] v012 = new double[]{-v21[0] - v01[0], -v21[1] - v01[1]};
                elm.v01[0] = v01[0];
                elm.v01[1] = v01[1];
                elm.v21[0] = v21[0];
                elm.v21[1] = v21[1];
                elm.v012[0] = v012[0];
                elm.v012[1] = v012[1];
                elm.c3 = v012[0] * v012[0] + v012[1] * v012[1];
                elm.c2 = 3.0 * (v01[0] * v012[0] + v01[1] * v012[1]);
                elm.c1 = 2.0 * (v01[0] * v01[0] + v01[1] * v01[1]);
                elm.type = 1;
                elm.xMin = ADFMathUtils.ADF_MIN(ADFMathUtils.ADF_MIN(x0, cvX), x1);
                elm.yMin = ADFMathUtils.ADF_MIN(ADFMathUtils.ADF_MIN(y0, cvY), y1);
                elm.xMax = ADFMathUtils.ADF_MAX(ADFMathUtils.ADF_MAX(x0, cvX), x1);
                elm.yMax = ADFMathUtils.ADF_MAX(ADFMathUtils.ADF_MAX(y0, cvY), y1);
            }
            ++elmIdx;
            x0 = x1;
            y0 = y1;
        }
        long l = startElmIdx = ctrIdx == 0 ? 0L : (long)(contours[ctrIdx - 1] + 1);
        if ((long)elmIdx > startElmIdx) {
            contours[ctrIdx++] = elmIdx - 1;
        }
        numContours = ctrIdx;
        ADF.CTInitClusterTree(internPath);
        InternCorner[] pCorner = internPath.corners;
        InternPathElm[] elms = internPath.elms;
        int pIdx = 0;
        double PI = 3.1415926535;
        double maxAngle = -Math.cos(0.02 * PI);
        double maxCurve = -Math.cos(0.75 * PI);
        int featureID = 0;
        ctrIdx = 0;
        while ((long)ctrIdx < numContours) {
            int ctrStartIdx = ctrIdx == 0 ? 0 : contours[ctrIdx - 1] + 1;
            int ctrEndIdx = contours[ctrIdx];
            InternPathElm startElm = elms[ctrStartIdx];
            long ctrOrient = ADF.GetContourOrientation(internPath, ctrStartIdx, ctrEndIdx);
            for (int elmIdx2 = ctrStartIdx; elmIdx2 <= ctrEndIdx; ++elmIdx2) {
                boolean tooMuchCurvature;
                boolean trueCorner;
                int nextFeatureID;
                InternPathElm nextElm;
                InternPathElm thisElm = elms[elmIdx2];
                thisElm.featureID = featureID;
                thisElm.orientation = ctrOrient;
                if (elmIdx2 < ctrEndIdx) {
                    nextElm = elms[elmIdx2 + 1];
                    nextFeatureID = featureID + 2;
                } else {
                    nextElm = elms[ctrStartIdx];
                    nextFeatureID = elms[ctrStartIdx].featureID;
                }
                double[] thisTan = thisElm.v21;
                double thisTanMag = Math.sqrt(thisTan[0] * thisTan[0] + thisTan[1] * thisTan[1]);
                double[] nextTan = nextElm.v01;
                double nextTanMag = Math.sqrt(nextTan[0] * nextTan[0] + nextTan[1] * nextTan[1]);
                double dotProduct = nextTan[0] * thisTan[0] + nextTan[1] * thisTan[1];
                if (dotProduct != 0.0) {
                    dotProduct /= thisTanMag * nextTanMag;
                }
                boolean bl = trueCorner = dotProduct > maxAngle;
                if (trueCorner) {
                    double crossProduct;
                    int secIDFollowing;
                    int secIDPreceeding;
                    double tMagFollowing;
                    double tMagPreceeding;
                    double[] tFollowing;
                    double[] tPreceeding;
                    if (ctrOrient == 0L) {
                        tPreceeding = thisElm.v21;
                        tFollowing = nextElm.v01;
                        tMagPreceeding = thisTanMag;
                        tMagFollowing = nextTanMag;
                        secIDPreceeding = featureID;
                        secIDFollowing = nextFeatureID;
                    } else {
                        tPreceeding = nextElm.v01;
                        tFollowing = thisElm.v21;
                        tMagPreceeding = nextTanMag;
                        tMagFollowing = thisTanMag;
                        secIDPreceeding = nextFeatureID;
                        secIDFollowing = featureID;
                    }
                    pCorner[pIdx] = new InternCorner();
                    pCorner[pIdx].p[0] = thisElm.e1[0];
                    pCorner[pIdx].p[1] = thisElm.e1[1];
                    pCorner[pIdx].t1[0] = (float)tPreceeding[0];
                    pCorner[pIdx].t1[1] = (float)tPreceeding[1];
                    pCorner[pIdx].t2[0] = (float)tFollowing[0];
                    pCorner[pIdx].t2[1] = (float)tFollowing[1];
                    if (tMagPreceeding > 0.0) {
                        pCorner[pIdx].t1[0] = pCorner[pIdx].t1[0] / (float)tMagPreceeding;
                        pCorner[pIdx].t1[1] = pCorner[pIdx].t1[1] / (float)tMagPreceeding;
                    }
                    if (tMagFollowing > 0.0) {
                        pCorner[pIdx].t2[0] = pCorner[pIdx].t2[0] / (float)tMagFollowing;
                        pCorner[pIdx].t2[1] = pCorner[pIdx].t2[1] / (float)tMagFollowing;
                    }
                    pCorner[pIdx].type = (crossProduct = tFollowing[0] * tPreceeding[1] - tFollowing[1] * tPreceeding[0]) > 0.0 ? 1L : 2L;
                    pCorner[pIdx].sec1ID = secIDPreceeding;
                    pCorner[pIdx].sec2ID = secIDFollowing;
                    thisElm.e1_ID = featureID + 1;
                    nextElm.e0_ID = featureID + 1;
                    featureID += 2;
                    ++pIdx;
                    startElm = nextElm;
                    continue;
                }
                double[] t = startElm.v01;
                double tMag = Math.sqrt(t[0] * t[0] + t[1] * t[1]);
                nextTan = nextElm.v21;
                nextTanMag = Math.sqrt(nextTan[0] * nextTan[0] + nextTan[1] * nextTan[1]);
                dotProduct = nextTan[0] * t[0] + nextTan[1] * t[1];
                if (dotProduct != 0.0) {
                    dotProduct /= tMag * nextTanMag;
                }
                boolean bl2 = tooMuchCurvature = dotProduct > maxCurve;
                if (tooMuchCurvature || elmIdx2 == ctrEndIdx) {
                    pCorner[pIdx] = new InternCorner();
                    pCorner[pIdx].sec1ID = 65535;
                    pCorner[pIdx].sec2ID = 65535;
                    pCorner[pIdx].type = 0L;
                    pCorner[pIdx].p[0] = thisElm.e1[0];
                    pCorner[pIdx].p[1] = thisElm.e1[1];
                    thisElm.e1_ID = featureID;
                    nextElm.e0_ID = nextFeatureID;
                    featureID += 2;
                    ++pIdx;
                    startElm = nextElm;
                    continue;
                }
                nextElm.e0_ID = featureID;
                thisElm.e1_ID = featureID;
            }
            ++ctrIdx;
        }
    }

    static long GetContourOrientation(InternPath internPath, int nFirst, long nLast) {
        InternPathElm pElm;
        float[] pCrossing = internPath.crossings;
        short[] pCrossingType = internPath.crossingTypes;
        int numElms = internPath.numPathElements;
        float yMin = 1.0f;
        float yMax = 0.0f;
        int n = nFirst;
        while ((long)n <= nLast) {
            pElm = internPath.elms[n];
            yMin = ADFMathUtils.ADF_MIN(yMin, pElm.yMin);
            yMax = ADFMathUtils.ADF_MAX(yMax, pElm.yMax);
            ++n;
        }
        if (yMax <= yMin) {
            return 0L;
        }
        long scaleFixPt = 65536L;
        long yMinFixPt = (long)(yMin * (float)scaleFixPt);
        long yMaxFixPt = (long)(yMax * (float)scaleFixPt);
        long halfSideLenFixPt = scaleFixPt >> 1;
        long yFixPt = scaleFixPt >> 1;
        while (yFixPt < yMinFixPt || yFixPt > yMaxFixPt) {
            halfSideLenFixPt >>= 1;
            if (yFixPt < yMinFixPt) {
                yFixPt += halfSideLenFixPt;
                continue;
            }
            yFixPt -= halfSideLenFixPt;
        }
        float y = (float)yFixPt / (float)scaleFixPt;
        int index = (int)(y * (float)(internPath.maxGridLines - 1)) * (numElms + 1);
        int pStart = index + 1;
        int nCrossings = 0;
        float leftCrossing = 1.0f;
        block6: for (n = 0; n < numElms; ++n) {
            pElm = internPath.elms[n];
            if (y < pElm.yMin || y > pElm.yMax) continue;
            switch (pElm.type) {
                case 0: {
                    float x;
                    float t = (y - pElm.e0[1]) / (pElm.e1[1] - pElm.e0[1]);
                    pCrossing[pStart + nCrossings] = x = pElm.e0[0] * (1.0f - t) + pElm.e1[0] * t;
                    if (nFirst <= n && (long)n <= nLast && x < leftCrossing) {
                        leftCrossing = x;
                    }
                    if (pElm.v01[1] > 0.0) {
                        pCrossingType[pStart + nCrossings++] = 1;
                        continue block6;
                    }
                    pCrossingType[pStart + nCrossings++] = -1;
                    continue block6;
                }
                case 1: {
                    double[] c = new double[]{pElm.e0[1] - y, 2.0 * pElm.v01[1], pElm.v012[1]};
                    ADFMathUtils.RootValue val = ADFMathUtils.ADFGetRealQuadraticRoots(c);
                    int nRoots = val.num;
                    double[] roots = val.roots;
                    while (nRoots > 0) {
                        float x;
                        float t;
                        if (!((t = (float)roots[--nRoots]) >= 0.0f) || !(t <= 1.0f)) continue;
                        float s = 1.0f - t;
                        float x1 = (float)(pElm.v01[0] + (double)pElm.e0[0]);
                        pCrossing[pStart + nCrossings] = x = pElm.e0[0] * s * s + 2.0f * x1 * s * t + pElm.e1[0] * t * t;
                        s = -2.0f * t * (float)(pElm.v01[1] + pElm.v21[1]) + (float)(2.0 * pElm.v01[1]);
                        if (s > 0.0f) {
                            pCrossingType[pStart + nCrossings++] = 1;
                        } else if (s < 0.0f) {
                            pCrossingType[pStart + nCrossings++] = -1;
                        }
                        if (s == 0.0f || n < nFirst || (long)n > nLast || !(x < leftCrossing)) continue;
                        leftCrossing = x;
                    }
                    continue block6;
                }
            }
        }
        internPath.crossings[index] = nCrossings;
        if (nCrossings > 1) {
            boolean sorted;
            do {
                sorted = true;
                n = nCrossings - 1;
                for (int i = 0; i < n; ++i) {
                    if (!(pCrossing[pStart + i] > pCrossing[pStart + i + 1])) continue;
                    float tempCrossing = pCrossing[pStart + i];
                    pCrossing[pStart + i] = pCrossing[pStart + i + 1];
                    pCrossing[pStart + i + 1] = tempCrossing;
                    short tempType = pCrossingType[pStart + i];
                    pCrossingType[pStart + i] = pCrossingType[pStart + i + 1];
                    pCrossingType[pStart + i + 1] = tempType;
                    sorted = false;
                }
            } while (!sorted);
        }
        int nonZeroWinding = 0;
        long numCrossings = nCrossings;
        n = 0;
        while ((long)n < numCrossings && !(leftCrossing <= pCrossing[pStart + n])) {
            nonZeroWinding += pCrossingType[pStart + n];
            ++n;
        }
        if (nonZeroWinding < 0) {
            return 1L;
        }
        if (nonZeroWinding > 0) {
            return 0L;
        }
        if (pCrossingType[pStart + n] == 1) {
            return 0L;
        }
        return 1L;
    }

    static boolean EXCLUDE_PATH_ELEMENT(float minDistSqr, float x, float y, float xMin, float xMax, float yMin, float yMax) {
        float db;
        float d2;
        float d1;
        float db2;
        return x <= xMin ? (y <= yMin ? (db2 = (d1 = x - xMin) * d1 + (d2 = y - yMin) * d2) > minDistSqr : (y >= yMax ? (db = (d1 = x - xMin) * d1 + (d2 = y - yMax) * d2) > minDistSqr : (db = (d1 = x - xMin) * d1) > minDistSqr)) : (x <= xMax ? (y < yMin ? (db = (d1 = y - yMin) * d1) > minDistSqr : y >= yMax && (db = (d1 = y - yMax) * d1) > minDistSqr) : (y <= yMin ? (db = (d1 = x - xMax) * d1 + (d2 = y - yMin) * d2) > minDistSqr : (y >= yMax ? (db = (d1 = x - xMax) * d1 + (d2 = y - yMax) * d2) > minDistSqr : (db = (d1 = x - xMax) * d1) > minDistSqr)));
    }

    static float DistFromCurv(float[] p, InternPathElm elm) {
        double d;
        double[] c = new double[4];
        double[] v0p = new double[2];
        double[] v1p = new double[2];
        double[] v01 = elm.v01;
        double[] v012 = elm.v012;
        v0p[0] = elm.e0[0] - p[0];
        v0p[1] = elm.e0[1] - p[1];
        v1p[0] = elm.e1[0] - p[0];
        v1p[1] = elm.e1[1] - p[1];
        c[0] = v01[0] * v0p[0] + v01[1] * v0p[1];
        c[1] = elm.c1 + v012[0] * v0p[0] + v012[1] * v0p[1];
        c[2] = elm.c2;
        c[3] = elm.c3;
        double minDistSqr = v0p[0] * v0p[0] + v0p[1] * v0p[1];
        float sign = v0p[0] * v01[1] - v0p[1] * v01[0] > 0.0 ? -1.0f : 1.0f;
        double distSqr = v1p[0] * v1p[0] + v1p[1] * v1p[1];
        if (d < minDistSqr) {
            minDistSqr = distSqr;
            sign = v1p[0] * elm.v21[1] - v1p[1] * elm.v21[0] < 0.0 ? -1.0f : 1.0f;
        }
        ADFMathUtils.RootValue val = ADFMathUtils.ADFGetRealCubicRoots(c);
        long nRoots = val.num;
        double[] roots = val.roots;
        int i = 0;
        while ((long)i < nRoots) {
            double dy;
            double twoT;
            double tt;
            double dx;
            double distSqr2;
            double t = roots[i];
            if (0.0 <= t && t <= 1.0 && (distSqr2 = (dx = (tt = t * t) * v012[0] + (twoT = 2.0 * t) * v01[0] + v0p[0]) * dx + (dy = tt * v012[1] + twoT * v01[1] + v0p[1]) * dy) <= minDistSqr) {
                double tanX = t * v012[0] + v01[0];
                double tanY = t * v012[1] + v01[1];
                sign = tanX * dy - tanY * dx < 0.0 ? -1.0f : 1.0f;
                minDistSqr = distSqr2;
            }
            ++i;
        }
        return sign * (float)Math.sqrt(minDistSqr);
    }

    static float DistFromLine(float[] p, InternPathElm elm) {
        float dx = p[0] - elm.e0[0];
        float dy = p[1] - elm.e0[1];
        float proj = (float)((double)dx * elm.v01[0] + (double)dy * elm.v01[1]);
        float dLine = (float)((double)dx * elm.v01[1] - (double)dy * elm.v01[0]);
        if (proj <= 0.0f) {
            float dist = dx * dx + dy * dy;
            dist = (float)Math.sqrt(dist);
            if (dLine < 0.0f) {
                return -dist;
            }
            return dist;
        }
        if ((double)proj >= elm.c1) {
            dx = p[0] - elm.e1[0];
            dy = p[1] - elm.e1[1];
            float dist = dx * dx + dy * dy;
            dist = (float)Math.sqrt(dist);
            if (dLine < 0.0f) {
                return -dist;
            }
            return dist;
        }
        return dLine;
    }

    static float DistSqrFromCurv(float[] p, InternPathElm elm, IntValue featureID) {
        double d;
        double[] c = new double[4];
        double[] v0p = new double[2];
        double[] v1p = new double[2];
        double[] v01 = elm.v01;
        double[] v012 = elm.v012;
        v0p[0] = elm.e0[0] - p[0];
        v0p[1] = elm.e0[1] - p[1];
        v1p[0] = elm.e1[0] - p[0];
        v1p[1] = elm.e1[1] - p[1];
        c[0] = v01[0] * v0p[0] + v01[1] * v0p[1];
        c[1] = elm.c1 + v012[0] * v0p[0] + v012[1] * v0p[1];
        c[2] = elm.c2;
        c[3] = elm.c3;
        double minDistSqr = v0p[0] * v0p[0] + v0p[1] * v0p[1];
        featureID.value = elm.e0_ID;
        double distSqr = v1p[0] * v1p[0] + v1p[1] * v1p[1];
        if (d < minDistSqr) {
            minDistSqr = distSqr;
            featureID.value = elm.e1_ID;
        }
        ADFMathUtils.RootValue val = ADFMathUtils.ADFGetRealCubicRoots(c);
        int nRoots = val.num;
        double[] roots = val.roots;
        for (int i = 0; i < nRoots; ++i) {
            double dy;
            double twoT;
            double tt;
            double dx;
            double distSqr2;
            double t = roots[i];
            if (!(t > 0.0) || !(t < 1.0) || !((distSqr2 = (dx = (tt = t * t) * v012[0] + (twoT = 2.0 * t) * v01[0] + v0p[0]) * dx + (dy = tt * v012[1] + twoT * v01[1] + v0p[1]) * dy) < minDistSqr)) continue;
            featureID.value = elm.featureID;
            minDistSqr = distSqr2;
        }
        return (float)minDistSqr;
    }

    static float DistSqrFromLine(float[] p, InternPathElm elm, IntValue featureID) {
        double dx = p[0] - elm.e0[0];
        double dy = p[1] - elm.e0[1];
        double proj = dx * elm.v01[0] + dy * elm.v01[1];
        if (proj <= 0.0) {
            double distSqr = dx * dx + dy * dy;
            featureID.value = elm.e0_ID;
            return (float)distSqr;
        }
        if (proj >= elm.c1) {
            dx = p[0] - elm.e1[0];
            dy = p[1] - elm.e1[1];
            double distSqr = dx * dx + dy * dy;
            featureID.value = elm.e1_ID;
            return (float)distSqr;
        }
        double distSqr = dx * elm.v01[1] - dy * elm.v01[0];
        featureID.value = elm.featureID;
        return (float)(distSqr * distSqr);
    }

    static float DistFrom2DPath(InternPath internPath, float[] p, IntValue closestFeatureID) {
        int n;
        float y = p[1];
        long numElms = internPath.numPathElements;
        if (numElms == 0L) {
            return -1.0f;
        }
        float minDistSqr = ADF.CTDistFromClusterTree(internPath, p, closestFeatureID);
        float dist = (float)Math.sqrt(minDistSqr);
        int index = (int)(y * (float)(internPath.maxGridLines - 1) * (float)(numElms + 1L));
        int nCrossings = (int)internPath.crossings[index];
        if (nCrossings < 0) {
            nCrossings = 0;
            n = 0;
            while ((long)n < numElms) {
                InternPathElm pElm = internPath.elms[n];
                if (!(y < pElm.yMin) && !(y > pElm.yMax)) {
                    switch (pElm.type) {
                        case 0: {
                            float x;
                            float t = (y - pElm.e0[1]) / (pElm.e1[1] - pElm.e0[1]);
                            internPath.crossings[index + 1 + nCrossings] = x = pElm.e0[0] * (1.0f - t) + pElm.e1[0] * t;
                            if (pElm.v01[1] > 0.0) {
                                internPath.crossingTypes[index + 1 + nCrossings++] = 1;
                                break;
                            }
                            internPath.crossingTypes[index + 1 + nCrossings++] = -1;
                            break;
                        }
                        case 1: {
                            double[] c = new double[]{pElm.e0[1] - y, 2.0 * pElm.v01[1], pElm.v012[1]};
                            ADFMathUtils.RootValue val = ADFMathUtils.ADFGetRealQuadraticRoots(c);
                            int nRoots = val.num;
                            double[] roots = val.roots;
                            while (nRoots > 0) {
                                float x;
                                float t;
                                if (!((t = (float)roots[--nRoots]) >= 0.0f) || !(t <= 1.0f)) continue;
                                float s = 1.0f - t;
                                float x1 = (float)(pElm.v01[0] + (double)pElm.e0[0]);
                                internPath.crossings[index + 1 + nCrossings] = x = pElm.e0[0] * s * s + 2.0f * x1 * s * t + pElm.e1[0] * t * t;
                                s = -2.0f * t * (float)(pElm.v01[1] + pElm.v21[1]) + (float)(2.0 * pElm.v01[1]);
                                if (s > 0.0f) {
                                    internPath.crossingTypes[index + 1 + nCrossings++] = 1;
                                    continue;
                                }
                                if (!(s < 0.0f)) continue;
                                internPath.crossingTypes[index + 1 + nCrossings++] = -1;
                            }
                            break;
                        }
                    }
                }
                ++n;
            }
            internPath.crossings[index] = nCrossings;
            if (nCrossings > 1) {
                boolean sorted;
                do {
                    sorted = true;
                    n = nCrossings - 1;
                    for (int i = 0; i < n; ++i) {
                        if (!(internPath.crossings[index + 1 + i] > internPath.crossings[index + 1 + i + 1])) continue;
                        float tempCrossing = internPath.crossings[index + 1 + i];
                        internPath.crossings[index + 1 + i] = internPath.crossings[index + 1 + i + 1];
                        internPath.crossings[index + 1 + i + 1] = tempCrossing;
                        short tempType = internPath.crossingTypes[index + 1 + i];
                        internPath.crossingTypes[index + 1 + i] = internPath.crossingTypes[index + 1 + i + 1];
                        internPath.crossingTypes[index + 1 + i + 1] = tempType;
                        sorted = false;
                    }
                } while (!sorted);
            }
        }
        int nonZeroWinding = 0;
        for (n = 0; n < nCrossings && !(p[0] < internPath.crossings[index + 1 + n]); ++n) {
            nonZeroWinding += internPath.crossingTypes[index + 1 + n];
        }
        if (nonZeroWinding == 0) {
            return -dist;
        }
        return dist;
    }

    static float DistFrom2DPathSection(InternPath internPath, float[] p, long sectionID) {
        InternPathElm pElm;
        int index = -1;
        float x = p[0];
        float y = p[1];
        float largeDistVal = 4.0f * ADFMathUtils.ADF_ABS(-1.0f);
        float minDist = -1.0f;
        long numElms = internPath.numPathElements;
        if (numElms == 0L) {
            return -1.0f;
        }
        float minDistSqr = largeDistVal;
        int n = 0;
        while ((long)n < numElms) {
            float dy;
            float dx;
            float d;
            pElm = internPath.elms[n];
            if ((long)pElm.featureID == sectionID && (d = (dx = 0.5f * (pElm.xMin + pElm.xMax) - x) * dx + (dy = 0.5f * (pElm.yMin + pElm.yMax) - y) * dy) < minDistSqr) {
                index = n;
                minDistSqr = d;
            }
            ++n;
        }
        if (minDistSqr == largeDistVal) {
            return -1.0f;
        }
        pElm = internPath.elms[index];
        long orientation = pElm.orientation;
        switch (pElm.type) {
            case 0: {
                minDist = ADF.DistFromLine(p, pElm);
                minDistSqr = minDist * minDist;
                break;
            }
            case 1: {
                minDist = ADF.DistFromCurv(p, pElm);
                minDistSqr = minDist * minDist;
            }
        }
        n = 0;
        while ((long)n < numElms) {
            if (n != index) {
                pElm = internPath.elms[n];
                if ((long)pElm.featureID == sectionID) {
                    float xMin = pElm.xMin;
                    float xMax = pElm.xMax;
                    float yMin = pElm.yMin;
                    float yMax = pElm.yMax;
                    switch (pElm.type) {
                        case 0: {
                            float dist;
                            if (ADF.EXCLUDE_PATH_ELEMENT(minDistSqr, x, y, xMin, xMax, yMin, yMax) || !((dist = ADF.DistFromLine(p, pElm)) * dist < minDistSqr)) break;
                            minDist = dist;
                            minDistSqr = minDist * minDist;
                            break;
                        }
                        case 1: {
                            float dist;
                            if (ADF.EXCLUDE_PATH_ELEMENT(minDistSqr, x, y, xMin, xMax, yMin, yMax) || !((dist = ADF.DistFromCurv(p, pElm)) * dist < minDistSqr)) break;
                            minDist = dist;
                            minDistSqr = minDist * minDist;
                        }
                    }
                }
            }
            ++n;
        }
        if (orientation == 0L) {
            return minDist;
        }
        return -minDist;
    }

    static float CT_MIN_SQR_DIST_TO_BBOX(float[] p, float xMin, float xMax, float yMin, float yMax) {
        float minDistSqr;
        if (p[0] <= xMin) {
            if (p[1] <= yMin) {
                float d1 = p[0] - xMin;
                float d2 = p[1] - yMin;
                minDistSqr = d1 * d1 + d2 * d2;
            } else if (p[1] >= yMax) {
                float d1 = p[0] - xMin;
                float d2 = p[1] - yMax;
                minDistSqr = d1 * d1 + d2 * d2;
            } else {
                float d1 = p[0] - xMin;
                minDistSqr = d1 * d1;
            }
        } else if (p[0] <= xMax) {
            if (p[1] < yMin) {
                float d1 = p[1] - yMin;
                minDistSqr = d1 * d1;
            } else if (p[1] >= yMax) {
                float d1 = p[1] - yMax;
                minDistSqr = d1 * d1;
            } else {
                minDistSqr = 0.0f;
            }
        } else if (p[1] <= yMin) {
            float d1 = p[0] - xMax;
            float d2 = p[1] - yMin;
            minDistSqr = d1 * d1 + d2 * d2;
        } else if (p[1] >= yMax) {
            float d1 = p[0] - xMax;
            float d2 = p[1] - yMax;
            minDistSqr = d1 * d1 + d2 * d2;
        } else {
            float d1 = p[0] - xMax;
            minDistSqr = d1 * d1;
        }
        return minDistSqr;
    }

    static void CT_REMOVE_CHILD(CTNode parent, CTNode child) {
        if (child == parent.firstChild) {
            parent.firstChild = child.nextSibling;
        } else {
            CTNode find = parent.firstChild;
            while (find.nextSibling != child) {
                find = find.nextSibling;
            }
            find.nextSibling = child.nextSibling;
        }
        child.nextSibling = null;
    }

    static void CTInitClusterTree(InternPath path) {
        CTNode root;
        int numElms = path.numPathElements;
        float avgBBoxSize = 0.0f;
        InternPathElm[] pElm = path.elms;
        path.clusterTreeRoot[0] = root = new CTNode();
        root.firstChild = null;
        root.nextSibling = null;
        root.xMin = 1.0f;
        root.xMax = 0.0f;
        root.yMin = 1.0f;
        root.yMax = 0.0f;
        int idxNextAvailableNode = 1;
        for (int n = 0; n < numElms; ++n) {
            CTNode node = new CTNode();
            path.clusterTreeRoot[idxNextAvailableNode++] = node;
            node.pElm = pElm[n];
            node.xMin = pElm[n].xMin;
            node.yMin = pElm[n].yMin;
            node.xMax = pElm[n].xMax;
            node.yMax = pElm[n].yMax;
            node.firstChild = null;
            node.nextSibling = root.firstChild;
            root.firstChild = node;
            root.xMin = ADFMathUtils.ADF_MIN(root.xMin, node.xMin);
            root.xMax = ADFMathUtils.ADF_MAX(root.xMax, node.xMax);
            root.yMin = ADFMathUtils.ADF_MIN(root.yMin, node.yMin);
            root.yMax = ADFMathUtils.ADF_MAX(root.yMax, node.yMax);
            avgBBoxSize += node.xMax - node.xMin + node.yMax - node.yMin;
        }
        if (numElms > 6) {
            float pairingDist = avgBBoxSize / (float)(numElms * 3);
            ADF.CTBuildClusterTree(path.clusterTreeRoot, idxNextAvailableNode, 1L, pairingDist);
        }
    }

    static void CTBuildClusterTree(CTNode[] clusterTreeRoot, int idxNextAvailableNode, long level, float pairingDist) {
        float maxPairingDist = pairingDist * (float)level;
        CTNode root = clusterTreeRoot[0];
        CTNode curNode = root.firstChild;
        while (curNode != null) {
            curNode.isNew = false;
            curNode = curNode.nextSibling;
        }
        curNode = root.firstChild;
        while (curNode != null) {
            float curMidPtX = (curNode.xMax + curNode.xMin) * 0.5f;
            float curMidPtY = (curNode.yMax + curNode.yMin) * 0.5f;
            CTNode closestNode = null;
            CTNode searchNode = root.firstChild;
            float minDistSqr = maxPairingDist;
            while (searchNode != null) {
                float searchMidPtY;
                float dy;
                float searchMidPtX;
                float dx;
                float distSqr;
                if (searchNode != curNode && (distSqr = (dx = curMidPtX - (searchMidPtX = (searchNode.xMax + searchNode.xMin) * 0.5f)) * dx + (dy = curMidPtY - (searchMidPtY = (searchNode.yMax + searchNode.yMin) * 0.5f)) * dy) < minDistSqr) {
                    minDistSqr = distSqr;
                    closestNode = searchNode;
                }
                searchNode = searchNode.nextSibling;
            }
            CTNode nextNode = curNode.nextSibling;
            if (minDistSqr < maxPairingDist) {
                if (closestNode.isNew) {
                    ADF.CT_REMOVE_CHILD(root, curNode);
                    curNode.nextSibling = closestNode.firstChild;
                    closestNode.firstChild = curNode;
                    closestNode.xMin = ADFMathUtils.ADF_MIN(closestNode.xMin, curNode.xMin);
                    closestNode.xMax = ADFMathUtils.ADF_MAX(closestNode.xMax, curNode.xMax);
                    closestNode.yMin = ADFMathUtils.ADF_MIN(closestNode.yMin, curNode.yMin);
                    closestNode.yMax = ADFMathUtils.ADF_MAX(closestNode.yMax, curNode.yMax);
                } else {
                    CTNode newNode = new CTNode();
                    clusterTreeRoot[idxNextAvailableNode++] = newNode;
                    newNode.isNew = true;
                    ADF.CT_REMOVE_CHILD(root, curNode);
                    if (nextNode == closestNode) {
                        nextNode = closestNode.nextSibling;
                    }
                    ADF.CT_REMOVE_CHILD(root, closestNode);
                    closestNode.nextSibling = null;
                    curNode.nextSibling = closestNode;
                    newNode.firstChild = curNode;
                    newNode.xMin = ADFMathUtils.ADF_MIN(curNode.xMin, closestNode.xMin);
                    newNode.xMax = ADFMathUtils.ADF_MAX(curNode.xMax, closestNode.xMax);
                    newNode.yMin = ADFMathUtils.ADF_MIN(curNode.yMin, closestNode.yMin);
                    newNode.yMax = ADFMathUtils.ADF_MAX(curNode.yMax, closestNode.yMax);
                    newNode.nextSibling = root.firstChild;
                    root.firstChild = newNode;
                }
            }
            curNode = nextNode;
        }
        long nChildren = 0L;
        curNode = root.firstChild;
        while (curNode != null) {
            ++nChildren;
            curNode = curNode.nextSibling;
        }
        if (level + 1L < 3L && nChildren > 6L) {
            ADF.CTBuildClusterTree(clusterTreeRoot, idxNextAvailableNode, level + 1L, pairingDist);
        }
    }

    static float CTDistFromClusterTree(InternPath path, float[] p, IntValue closestFeatureID) {
        float minDistSqr = 4.0f * ADFMathUtils.ADF_ABS(-1.0f);
        CTNode headNodeL = path.clusterTreeRoot[0];
        headNodeL.sortThread = null;
        headNodeL.minDistSqr = 0.0f;
        while (headNodeL != null && headNodeL.minDistSqr < minDistSqr) {
            CTNode curNode = headNodeL;
            headNodeL = headNodeL.sortThread;
            if (curNode.firstChild != null) {
                CTNode child = curNode.firstChild;
                while (child != null) {
                    if (child.firstChild == null && child.pElm.type == 0) {
                        IntValue featureID = new IntValue(0);
                        float dSqr = ADF.DistSqrFromLine(p, child.pElm, featureID);
                        if (dSqr < minDistSqr) {
                            minDistSqr = dSqr;
                            closestFeatureID.value = featureID.value;
                        }
                    } else {
                        float dSqr;
                        child.minDistSqr = dSqr = ADF.CT_MIN_SQR_DIST_TO_BBOX(p, child.xMin, child.xMax, child.yMin, child.yMax);
                        if (dSqr < minDistSqr) {
                            if (headNodeL == null || dSqr < headNodeL.minDistSqr) {
                                child.sortThread = headNodeL;
                                headNodeL = child;
                            } else {
                                CTNode node = headNodeL;
                                while (node.sortThread != null && node.sortThread.minDistSqr < dSqr) {
                                    node = node.sortThread;
                                }
                                child.sortThread = node.sortThread;
                                node.sortThread = child;
                            }
                        }
                    }
                    child = child.nextSibling;
                }
                continue;
            }
            IntValue featureID = new IntValue(0);
            float dSqr = ADF.DistSqrFromCurv(p, curNode.pElm, featureID);
            if (!(dSqr < minDistSqr)) continue;
            minDistSqr = dSqr;
            closestFeatureID.value = featureID.value;
        }
        return minDistSqr;
    }

    static ADFGlyph SCGenerate(ADFTypeSystem.ADFPath path, ADFTypeSystem.ADFGenAttrs genAttrs) {
        long maxLevel = genAttrs.maxLevel;
        SCGenData genData = new SCGenData();
        SCGenCellData genCellData = new SCGenCellData();
        InternPath internPath = ADF.CreateInternPath(path, genAttrs);
        if (internPath == null) {
            return null;
        }
        int mapSideLen = (1 << (int)(maxLevel + 1L)) + 1;
        int size = mapSideLen * mapSideLen;
        float[] distMap = new float[size];
        for (int i = 0; i < size; ++i) {
            distMap[i] = -1.0f;
        }
        char[] featureMap = new char[size];
        genData.maxNumScData = 16384;
        genData.scData = new float[genData.maxNumScData];
        genData.internPath = internPath;
        genData.genAttrs = genAttrs;
        genData.distMap = distMap;
        genData.featureMap = featureMap;
        genData.mapSideLen = mapSideLen;
        genCellData.level = 0L;
        genCellData.xIdx = 0;
        genCellData.yIdx = 0;
        genCellData.dxIdx = genData.mapSideLen - 1 >> 1;
        genCellData.dyIdx = genCellData.dxIdx * mapSideLen;
        genCellData.halfCellSide = 0.5f;
        genData.numCells = 0;
        genData.numDists = 0;
        ADF.SCSubdivDistField(genData, genCellData);
        ADFGlyph adf = new ADFGlyph();
        adf.cellsAndDists = new int[genData.numCells + genData.numDists + 1];
        adf.numCells = genData.numCells;
        adf.charCode = path.charCode;
        adf.ADFUnitsPerEM = internPath.ADFUnitsPerEM;
        adf.FUToADFScale = internPath.FUToADFScale;
        adf.glyphOriginX = internPath.glyphOffsetX;
        adf.glyphOriginY = internPath.glyphOffsetY;
        adf.glyphMinX = path.glyphMinX * adf.FUToADFScale + adf.glyphOriginX;
        adf.glyphMinY = path.glyphMinY * adf.FUToADFScale + adf.glyphOriginY;
        adf.glyphMaxX = path.glyphMaxX * adf.FUToADFScale + adf.glyphOriginX;
        adf.glyphMaxY = path.glyphMaxY * adf.FUToADFScale + adf.glyphOriginY;
        adf.version = ADF_VERSION_NUMBER;
        ADF.ADFUnpackAlgnZones(path, adf);
        int rootOffset = 0;
        int nxtCellOffset = rootOffset + 1;
        int nxtDistOffset = rootOffset + genData.numCells;
        ADF.SCBuildADFQuadtree(genData, genCellData, adf, rootOffset, new IntValue(nxtCellOffset), new IntValue(nxtDistOffset));
        return adf;
    }

    static void SCSubdivDistField(SCGenData genData, SCGenCellData genCellData) {
        long cellType;
        int xIdx = genCellData.xIdx;
        int yIdx = genCellData.yIdx;
        int dxIdx = genCellData.dxIdx;
        int dyIdx = genCellData.dyIdx;
        int cellCenterIdx = xIdx + dxIdx + yIdx + dyIdx;
        ADFTypeSystem.ADFGenAttrs genAttrs = genData.genAttrs;
        ADF.SCInitCellDVs(genData, genCellData);
        ++genData.numCells;
        if (genCellData.level >= genAttrs.maxLevel) {
            genData.featureMap[cellCenterIdx] = 65534;
            genData.numDists += 9;
            return;
        }
        float sqrtTwo = 1.4142137f;
        float halfCellDiag = sqrtTwo * genCellData.halfCellSide;
        float cellCenterDist = genData.distMap[cellCenterIdx];
        if (Math.abs(cellCenterDist) > halfCellDiag + genAttrs.distEps) {
            genData.featureMap[cellCenterIdx] = 65534;
            genData.numDists += 9;
            return;
        }
        float cellError = ADF.SCGetCellError(genData, genCellData);
        if (cellError < genAttrs.maxError) {
            genData.featureMap[cellCenterIdx] = 65534;
            genData.numDists += 9;
            return;
        }
        if (genData.numScData + 24 < genData.maxNumScData && (cellType = ADF.SCIsSpecialCell(genData, genCellData)) != 0L) {
            genData.numDists = cellType == 2L ? (genData.numDists += 18) : (genData.numDists += 24);
            return;
        }
        SCGenCellData childGenCellData = new SCGenCellData();
        childGenCellData.level = genCellData.level + 1L;
        childGenCellData.dxIdx = dxIdx >> 1;
        childGenCellData.dyIdx = dyIdx >> 1;
        childGenCellData.halfCellSide = 0.5f * genCellData.halfCellSide;
        childGenCellData.yIdx = yIdx;
        for (long j = 0L; j < 2L; ++j) {
            childGenCellData.xIdx = xIdx;
            for (long i = 0L; i < 2L; ++i) {
                ADF.SCSubdivDistField(genData, childGenCellData);
                childGenCellData.xIdx += dxIdx;
            }
            childGenCellData.yIdx += dyIdx;
        }
    }

    static void SCInitCellDVs(SCGenData genData, SCGenCellData genCellData) {
        float y0;
        float x0;
        float[] adfPnt = new float[2];
        float[] distMap = genData.distMap;
        char[] featureMap = genData.featureMap;
        float[] distVals = genCellData.distVals;
        int xIdx = genCellData.xIdx;
        int yIdx = genCellData.yIdx;
        int dxIdx = genCellData.dxIdx;
        int dyIdx = genCellData.dyIdx;
        float halfCellSide = genCellData.halfCellSide;
        float mapSideLen = genData.mapSideLen;
        genCellData.x0 = x0 = (float)xIdx / (mapSideLen - 1.0f);
        genCellData.y0 = y0 = (float)yIdx / ((mapSideLen - 1.0f) * mapSideLen);
        int idx = 0;
        int yIndex = yIdx;
        adfPnt[1] = y0;
        for (long j = 0L; j <= 2L; ++j) {
            int xIndex = xIdx;
            adfPnt[0] = x0;
            for (long i = 0L; i <= 2L; ++i) {
                int offset = xIndex + yIndex;
                if (distMap[offset] == -1.0f) {
                    IntValue val = new IntValue(0);
                    float d = ADF.DistFrom2DPath(genData.internPath, adfPnt, val);
                    int n = idx++;
                    float f = d;
                    distVals[n] = f;
                    distMap[offset] = f;
                    featureMap[offset] = (char)val.value;
                } else {
                    distVals[idx++] = distMap[offset];
                }
                xIndex += dxIdx;
                adfPnt[0] = adfPnt[0] + halfCellSide;
            }
            yIndex += dyIdx;
            adfPnt[1] = adfPnt[1] + halfCellSide;
        }
    }

    static float SCGetCellError(SCGenData genData, SCGenCellData genCellData) {
        float[] adfPnt = new float[2];
        float[] distMap = genData.distMap;
        char[] featureMap = genData.featureMap;
        float[] distVals = genCellData.distVals;
        int xIdx = genCellData.xIdx;
        int yIdx = genCellData.yIdx;
        int dxIdx = genCellData.dxIdx;
        int dyIdx = genCellData.dyIdx;
        float halfCellSide = genCellData.halfCellSide;
        float x0 = genCellData.x0;
        float y0 = genCellData.y0;
        float maxError = 0.0f;
        boolean storeValues = dxIdx > 1 && dyIdx > 1;
        float yCell = 0.25f;
        int yIndex = yIdx + dyIdx / 2;
        adfPnt[1] = y0 + 0.5f * halfCellSide;
        for (long j = 0L; j < 2L; ++j) {
            float xCell = 0.25f;
            int xIndex = xIdx + dxIdx / 2;
            adfPnt[0] = x0 + 0.5f * halfCellSide;
            for (long i = 0L; i < 2L; ++i) {
                float error;
                IntValue ID = new IntValue(0);
                float d1 = ADF.GetDistFromBiquadraticCell(distVals, xCell, yCell);
                float d2 = ADF.DistFrom2DPath(genData.internPath, adfPnt, ID);
                if (storeValues) {
                    int offset = xIndex + yIndex;
                    distMap[offset] = d2;
                    featureMap[offset] = (char)ID.value;
                }
                float f = error = d1 > d2 ? d1 - d2 : d2 - d1;
                if (error > maxError) {
                    maxError = error;
                }
                xCell += 0.5f;
                xIndex += dxIdx;
                adfPnt[0] = adfPnt[0] + halfCellSide;
            }
            yCell += 0.5f;
            yIndex += dyIdx;
            adfPnt[1] = adfPnt[1] + halfCellSide;
        }
        return maxError;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static long SCIsSpecialCell(SCGenData genData, SCGenCellData genCellData) {
        float halfCellSide;
        long cellFeature;
        long cellType;
        InternCorner corner;
        int i;
        int xIndex;
        int j;
        char[] IDs = new char[9];
        int sec1ID = 65535;
        int sec2ID = 65535;
        int cornerID = 65535;
        char[] pFeature = genData.featureMap;
        float[] adfPnt = new float[2];
        float[] t1 = new float[]{0.0f, 0.0f};
        float[] t2 = new float[]{0.0f, 0.0f};
        float[] dist1 = new float[9];
        float[] dist2 = new float[9];
        InternPath internPath = genData.internPath;
        int idx = 0;
        int yIndex = genCellData.yIdx;
        for (j = 0; j <= 2; ++j) {
            xIndex = genCellData.xIdx;
            for (i = 0; i <= 2; ++i) {
                int ID = pFeature[xIndex + yIndex];
                if (ID % 2 != 0) {
                    if (cornerID == 65535) {
                        cornerID = ID;
                    } else if (ID != cornerID) {
                        return 0L;
                    }
                } else if (sec1ID == 65535) {
                    sec1ID = ID;
                } else if (ID != sec1ID) {
                    if (sec2ID == 65535) {
                        sec2ID = ID;
                    } else if (ID != sec2ID) {
                        return 0L;
                    }
                }
                IDs[idx++] = ID;
                xIndex += genCellData.dxIdx;
            }
            yIndex += genCellData.dyIdx;
        }
        if (cornerID != 65535) {
            corner = internPath.corners[(cornerID - 1) / 2];
            if (sec2ID == 65535) {
                if (sec1ID == 65535) {
                    sec1ID = corner.sec1ID;
                    sec2ID = corner.sec2ID;
                } else if (sec1ID == corner.sec1ID) {
                    sec2ID = corner.sec2ID;
                } else {
                    if (sec1ID != corner.sec2ID) {
                        return 0L;
                    }
                    sec1ID = corner.sec1ID;
                    sec2ID = corner.sec2ID;
                }
            } else if (sec1ID == corner.sec1ID) {
                if (sec2ID != corner.sec2ID) {
                    return 0L;
                }
            } else {
                if (sec1ID != corner.sec2ID) return 0L;
                if (sec2ID != corner.sec1ID) {
                    return 0L;
                }
                sec1ID = corner.sec1ID;
                sec2ID = corner.sec2ID;
            }
        } else {
            if (sec2ID == 65535) {
                return 0L;
            }
            corner = internPath.corners[sec1ID / 2];
            if (corner.sec1ID == sec1ID && corner.sec2ID == sec2ID) {
                cornerID = sec1ID + 1;
            } else if (corner.sec1ID == sec2ID && corner.sec2ID == sec1ID) {
                cornerID = sec1ID + 1;
                sec1ID = corner.sec1ID;
                sec2ID = corner.sec2ID;
            } else {
                corner = internPath.corners[sec2ID / 2];
                if (corner.sec1ID == sec1ID && corner.sec2ID == sec2ID) {
                    cornerID = sec1ID + 1;
                } else if (corner.sec1ID == sec2ID && corner.sec2ID == sec1ID) {
                    cornerID = sec2ID + 1;
                    sec1ID = corner.sec1ID;
                    sec2ID = corner.sec2ID;
                } else {
                    corner = null;
                }
            }
        }
        if (corner != null) {
            if (corner.type == 1L) {
                cellType = 3L;
                cellFeature = 65532L;
            } else {
                cellType = 4L;
                cellFeature = 65531L;
            }
            t1 = corner.t1;
            t2 = corner.t2;
        } else {
            cellType = 2L;
            cellFeature = 65533L;
        }
        float x0 = genCellData.x0;
        float y0 = genCellData.y0;
        float[] distVals = genCellData.distVals;
        if (corner == null) {
            halfCellSide = genCellData.halfCellSide;
            adfPnt[1] = y0;
            idx = 0;
            for (j = 0; j <= 2; ++j) {
                adfPnt[0] = x0;
                for (i = 0; i <= 2; ++i) {
                    if (IDs[idx] == sec1ID) {
                        dist1[idx] = distVals[idx];
                        dist2[idx] = ADF.DistFrom2DPathSection(internPath, adfPnt, sec2ID);
                    } else {
                        dist1[idx] = ADF.DistFrom2DPathSection(internPath, adfPnt, sec1ID);
                        dist2[idx] = distVals[idx];
                    }
                    adfPnt[0] = adfPnt[0] + halfCellSide;
                    ++idx;
                }
                adfPnt[1] = adfPnt[1] + halfCellSide;
            }
        } else {
            halfCellSide = genCellData.halfCellSide;
            adfPnt[1] = y0;
            idx = 0;
            for (j = 0; j <= 2; ++j) {
                adfPnt[0] = x0;
                for (i = 0; i <= 2; ++i) {
                    float dLine;
                    long ID = IDs[idx];
                    if (IDs[idx] == sec1ID) {
                        dist1[idx] = distVals[idx];
                        dist2[idx] = ADF.DistFrom2DPathSection(internPath, adfPnt, sec2ID);
                    } else if (IDs[idx] == sec2ID) {
                        dist1[idx] = ADF.DistFrom2DPathSection(internPath, adfPnt, sec1ID);
                        dist2[idx] = distVals[idx];
                    } else {
                        dist1[idx] = distVals[idx];
                        dist2[idx] = distVals[idx];
                    }
                    float dx = adfPnt[0] - corner.p[0];
                    float dy = adfPnt[1] - corner.p[1];
                    if (dx * t1[0] + dy * t1[1] < 0.0f && ADFMathUtils.ADF_ABS(dLine = dy * t1[0] - dx * t1[1]) < ADFMathUtils.ADF_ABS(dist1[idx])) {
                        dist1[idx] = dLine;
                    }
                    if (dx * t2[0] + dy * t2[1] < 0.0f && ADFMathUtils.ADF_ABS(dLine = dx * t2[1] - dy * t2[0]) < ADFMathUtils.ADF_ABS(dist2[idx])) {
                        dist2[idx] = dLine;
                    }
                    int valid1 = t1[0] * dx + t1[1] * dy > 0.0f ? 1 : 0;
                    int valid2 = t2[0] * dx + t2[1] * dy > 0.0f ? 1 : 0;
                    int region = valid1 << 1 | valid2;
                    switch (region) {
                        case 3: {
                            if (!(ID == (long)sec1ID ? ADFMathUtils.ADF_ABS(dist2[idx]) < ADFMathUtils.ADF_ABS(dist1[idx]) : ID == (long)sec2ID && ADFMathUtils.ADF_ABS(dist1[idx]) < ADFMathUtils.ADF_ABS(dist2[idx]))) break;
                            return 0L;
                        }
                        case 2: {
                            if (ID == (long)sec1ID) break;
                            return 0L;
                        }
                        case 1: {
                            if (ID == (long)sec2ID) break;
                            return 0L;
                        }
                        case 0: {
                            if (ID == (long)cornerID) break;
                            return 0L;
                        }
                    }
                    adfPnt[0] = adfPnt[0] + halfCellSide;
                    ++idx;
                }
                adfPnt[1] = adfPnt[1] + halfCellSide;
            }
        }
        if (genCellData.dxIdx > 1) {
            float maxError = genData.genAttrs.maxError;
            float yCell = 0.25f;
            yIndex = genCellData.yIdx + genCellData.dyIdx / 2;
            adfPnt[1] = y0 + 0.5f * halfCellSide;
            for (j = 0; j < 2; ++j) {
                float xCell = 0.25f;
                xIndex = genCellData.xIdx + genCellData.dxIdx / 2;
                adfPnt[0] = x0 + 0.5f * halfCellSide;
                for (i = 0; i < 2; ++i) {
                    float d2;
                    float error;
                    float d1;
                    float d;
                    if (corner == null) {
                        d = ADF.DistFrom2DPathSection(genData.internPath, adfPnt, sec1ID);
                        error = Math.abs(d - (d1 = ADF.GetDistFromBiquadraticCell(dist1, xCell, yCell)));
                        if (error > maxError) {
                            return 0L;
                        }
                        d = ADF.DistFrom2DPathSection(genData.internPath, adfPnt, sec2ID);
                        error = Math.abs(d - (d2 = ADF.GetDistFromBiquadraticCell(dist2, xCell, yCell)));
                        if (error > maxError) {
                            return 0L;
                        }
                        d = genData.distMap[xIndex + yIndex];
                        if (ADFMathUtils.ADF_ABS(d2) < ADFMathUtils.ADF_ABS(d1)) {
                            d1 = d2;
                        }
                        if ((error = Math.abs(d - d1)) > maxError) {
                            return 0L;
                        }
                    } else {
                        float dLine;
                        float dx = adfPnt[0] - corner.p[0];
                        float dy = adfPnt[1] - corner.p[1];
                        float proj1 = t1[0] * dx + t1[1] * dy;
                        float proj2 = t2[0] * dx + t2[1] * dy;
                        d = ADF.DistFrom2DPathSection(genData.internPath, adfPnt, sec1ID);
                        if (proj1 <= 0.0f && ADFMathUtils.ADF_ABS(dLine = dy * t1[0] - dx * t1[1]) < ADFMathUtils.ADF_ABS(d)) {
                            d = dLine;
                        }
                        if ((error = Math.abs(d - (d1 = ADF.GetDistFromBiquadraticCell(dist1, xCell, yCell)))) > maxError) {
                            return 0L;
                        }
                        d = ADF.DistFrom2DPathSection(genData.internPath, adfPnt, sec2ID);
                        if (proj2 <= 0.0f && ADFMathUtils.ADF_ABS(dLine = dx * t2[1] - dy * t2[0]) < ADFMathUtils.ADF_ABS(d)) {
                            d = dLine;
                        }
                        if ((error = Math.abs(d - (d2 = ADF.GetDistFromBiquadraticCell(dist2, xCell, yCell)))) > maxError) {
                            return 0L;
                        }
                        d = genData.distMap[xIndex + yIndex];
                        int valid1 = proj1 > 0.0f ? 1 : 0;
                        int valid2 = proj2 > 0.0f ? 1 : 0;
                        int region = valid1 << 1 | valid2;
                        switch (region) {
                            case 3: {
                                if (!(d2 * d2 - d1 * d1 < 0.0f)) break;
                                d1 = d2;
                                break;
                            }
                            case 2: {
                                break;
                            }
                            case 1: {
                                d1 = d2;
                                break;
                            }
                            case 0: {
                                d1 = (float)Math.sqrt(dx * dx + dy * dy);
                                if (cellFeature != 65531L) break;
                                d1 *= -1.0f;
                            }
                        }
                        error = Math.abs(d - d1);
                        if (error > maxError) {
                            return 0L;
                        }
                    }
                    xCell += 0.5f;
                    xIndex += genCellData.dxIdx;
                    adfPnt[0] = adfPnt[0] + halfCellSide;
                }
                yCell += 0.5f;
                yIndex += genCellData.dyIdx;
                adfPnt[1] = adfPnt[1] + halfCellSide;
            }
        }
        int cellCenterIdx = genCellData.xIdx + genCellData.dxIdx + genCellData.yIdx + genCellData.dyIdx;
        genData.distMap[cellCenterIdx] = genData.numScData;
        genData.featureMap[cellCenterIdx] = (char)cellFeature;
        int scDataCount = genData.numScData;
        for (i = 0; i < 9; ++i) {
            genData.scData[scDataCount++] = dist1[i];
        }
        for (i = 0; i < 9; ++i) {
            genData.scData[scDataCount++] = dist2[i];
        }
        genData.numScData += 18;
        if (corner == null) return cellType;
        genData.scData[scDataCount++] = corner.p[0];
        genData.scData[scDataCount++] = corner.p[1];
        genData.scData[scDataCount++] = t1[0];
        genData.scData[scDataCount++] = t1[1];
        genData.scData[scDataCount++] = t2[0];
        genData.scData[scDataCount++] = t2[1];
        genData.numScData += 6;
        return cellType;
    }

    static void SCBuildADFQuadtree(SCGenData genData, SCGenCellData genCellData, ADFGlyph adf, int cellOffset, IntValue nxtCellOffset, IntValue nxtDistOffset) {
        int xIdx = genCellData.xIdx;
        int yIdx = genCellData.yIdx;
        int dxIdx = genCellData.dxIdx;
        int dyIdx = genCellData.dyIdx;
        int centerIdx = xIdx + dxIdx + yIdx + dyIdx;
        char cellType = genData.featureMap[centerIdx];
        switch (cellType) {
            case '\ufffe': {
                adf.cellsAndDists[cellOffset] = ADF.ADF_PACK_CELL_ATTRS(1, nxtDistOffset.value);
                int yIndex = genCellData.yIdx;
                float[] distMap = genData.distMap;
                float scale = 32768.0f;
                int pDst = 0;
                int j = 0;
                while (j <= 2) {
                    int xIndex = genCellData.xIdx;
                    int i = 0;
                    while (i <= 2) {
                        adf.cellsAndDists[nxtDistOffset.value + pDst++] = (int)(distMap[xIndex + yIndex] * scale);
                        ++i;
                        xIndex += genCellData.dxIdx;
                    }
                    ++j;
                    yIndex += genCellData.dyIdx;
                }
                nxtDistOffset.value += 9;
                return;
            }
            case '\ufffd': {
                adf.cellsAndDists[cellOffset] = ADF.ADF_PACK_CELL_ATTRS(2, nxtDistOffset.value);
                int scDataOffset = (int)genData.distMap[centerIdx];
                float scale = 32768.0f;
                int pDst = 0;
                for (int i = 0; i < 18; ++i) {
                    adf.cellsAndDists[nxtDistOffset.value + pDst++] = (int)(genData.scData[scDataOffset + i] * scale);
                }
                nxtDistOffset.value += 18;
                return;
            }
            case '\ufffb': 
            case '\ufffc': {
                int i;
                int type = cellType == '\ufffc' ? 3 : 4;
                adf.cellsAndDists[cellOffset] = ADF.ADF_PACK_CELL_ATTRS(type, nxtDistOffset.value);
                int scDataOffset = (int)genData.distMap[centerIdx];
                float scale = 32768.0f;
                int pDst = 0;
                for (i = 0; i < 20; ++i) {
                    adf.cellsAndDists[nxtDistOffset.value + pDst++] = (int)(genData.scData[scDataOffset + i] * scale);
                }
                scale = 16384.0f;
                for (i = 20; i < 24; ++i) {
                    adf.cellsAndDists[nxtDistOffset.value + pDst++] = (int)(genData.scData[scDataOffset + i] * scale);
                }
                nxtDistOffset.value += 24;
                return;
            }
        }
        int childCellOffset = nxtCellOffset.value;
        adf.cellsAndDists[cellOffset] = ADF.ADF_PACK_CELL_ATTRS(0, childCellOffset);
        nxtCellOffset.value += 4;
        SCGenCellData childGenCellData = new SCGenCellData();
        childGenCellData.level = genCellData.level + 1L;
        childGenCellData.dxIdx = dxIdx >> 1;
        childGenCellData.dyIdx = dyIdx >> 1;
        childGenCellData.halfCellSide = 0.5f * genCellData.halfCellSide;
        childGenCellData.yIdx = yIdx;
        for (int j = 0; j < 2; ++j) {
            childGenCellData.xIdx = xIdx;
            for (int i = 0; i < 2; ++i) {
                ADF.SCBuildADFQuadtree(genData, childGenCellData, adf, childCellOffset, nxtCellOffset, nxtDistOffset);
                ++childCellOffset;
                childGenCellData.xIdx += dxIdx;
            }
            childGenCellData.yIdx += dyIdx;
        }
    }

    static void ADFPackAlgnZones(ADFGlyph adf, ADFTypeSystem.ADFPath path) {
        path.algnZones = new long[2];
        ADFMathUtils.ADFPackF32Result result = ADFMathUtils.ADFPackF32(adf.xAlgnCoord);
        if (result.tooLarge) {
            result.packedValue = 0;
        }
        ADFMathUtils.ADF_SERIALIZE_U16(path.algnZones, 0, 0, 8, result.packedValue);
        result = ADFMathUtils.ADFPackF32(adf.yAlgnCoord);
        if (result.tooLarge) {
            result.packedValue = 0;
        }
        ADFMathUtils.ADF_SERIALIZE_U16(path.algnZones, 0, 16, 24, result.packedValue);
        result = ADFMathUtils.ADFPackF32(adf.xRange);
        if (result.tooLarge) {
            result.packedValue = 0;
        }
        ADFMathUtils.ADF_SERIALIZE_U16(path.algnZones, 1, 0, 8, result.packedValue);
        result = ADFMathUtils.ADFPackF32(adf.yRange);
        if (result.tooLarge) {
            result.packedValue = 0;
        }
        ADFMathUtils.ADF_SERIALIZE_U16(path.algnZones, 1, 16, 24, result.packedValue);
        path.algnZonesMask = ADFMathUtils.ADF_SERIALIZE_U32(adf.algnZonesMask);
    }

    public static void ADFUnpackAlgnZones(ADFTypeSystem.ADFPath path, ADFGlyph adf) {
        adf.algnZonesMask = ADFMathUtils.ADF_DESERIALIZE_U32(path.algnZonesMask);
        long xAlgnCoordValid = adf.algnZonesMask & 1;
        long yAlgnCoordValid = adf.algnZonesMask & 2;
        if (xAlgnCoordValid == 0L) {
            adf.xRange = 0.0f;
        } else {
            long xAlgnCoordU16 = ADFMathUtils.ADF_DESERIALIZE_U16(path.algnZones, 0, 0, 8);
            long xRangeU16 = ADFMathUtils.ADF_DESERIALIZE_U16(path.algnZones, 1, 0, 8);
            adf.xAlgnCoord = ADFMathUtils.ADFUnpackF32(xAlgnCoordU16);
            adf.xRange = ADFMathUtils.ADFUnpackF32(xRangeU16);
        }
        if (yAlgnCoordValid == 0L) {
            adf.yRange = 0.0f;
        } else {
            long yAlgnCoordU16 = ADFMathUtils.ADF_DESERIALIZE_U16(path.algnZones, 0, 16, 24);
            long yRangeU16 = ADFMathUtils.ADF_DESERIALIZE_U16(path.algnZones, 1, 16, 24);
            adf.yAlgnCoord = ADFMathUtils.ADFUnpackF32(yAlgnCoordU16);
            adf.yRange = ADFMathUtils.ADFUnpackF32(yRangeU16);
        }
    }

    static class SCGenCellData {
        long level;
        int xIdx;
        int yIdx;
        int dxIdx;
        int dyIdx;
        float halfCellSide;
        float[] distVals = new float[9];
        float x0;
        float y0;

        SCGenCellData() {
        }
    }

    static class SCGenData {
        InternPath internPath;
        ADFTypeSystem.ADFGenAttrs genAttrs;
        int mapSideLen;
        float[] distMap;
        char[] featureMap;
        float[] scData;
        int numScData;
        int maxNumScData;
        int numDists;
        int numCells;

        SCGenData() {
        }
    }

    static class InternPath {
        float FUToADFScale;
        float glyphOffsetX;
        float glyphOffsetY;
        float ADFUnitsPerEM;
        int numPathElements;
        InternPathElm[] elms;
        int[] contours;
        InternCorner[] corners;
        int maxGridLines;
        float[] crossings;
        short[] crossingTypes;
        CTNode[] clusterTreeRoot;

        InternPath() {
        }
    }

    static class CTNode {
        boolean isNew;
        float minDistSqr;
        float xMin;
        float yMin;
        float xMax;
        float yMax;
        CTNode firstChild;
        CTNode nextSibling;
        CTNode sortThread;
        InternPathElm pElm = new InternPathElm();

        CTNode() {
        }
    }

    static class InternCorner {
        int sec1ID;
        int sec2ID;
        float[] p = new float[2];
        float[] t1 = new float[2];
        float[] t2 = new float[2];
        long type;

        InternCorner() {
        }
    }

    static class InternPathElm {
        int type;
        float xMin;
        float xMax;
        float yMin;
        float yMax;
        int featureID;
        int e0_ID;
        int e1_ID;
        float[] e0 = new float[2];
        float[] e1 = new float[2];
        double[] v01 = new double[2];
        double[] v21 = new double[2];
        double[] v012 = new double[2];
        double c1;
        double c2;
        double c3;
        long orientation;

        InternPathElm() {
        }
    }

    static class BooleanValue {
        boolean value;

        public BooleanValue(boolean val) {
            this.value = val;
        }
    }

    static class IntValue {
        int value;

        public IntValue(int val) {
            this.value = val;
        }
    }

    static class Cell {
        int type;
        int offset;

        Cell() {
        }
    }

    public static class ADFGlyph {
        long version;
        long numCells;
        int[] cellsAndDists;
        long charCode;
        float FUToADFScale;
        float ADFUnitsPerEM;
        float glyphOriginX;
        float glyphOriginY;
        float glyphMinX;
        float glyphMinY;
        float glyphMaxX;
        float glyphMaxY;
        public float xAlgnCoord;
        public float yAlgnCoord;
        public float xRange;
        public float yRange;
        int algnZonesMask;
    }
}

