/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.pdfops;

import com.adobe.pdfservices.operation.ExecutionContext;
import com.adobe.pdfservices.operation.Operation;
import com.adobe.pdfservices.operation.exception.ServiceApiException;
import com.adobe.pdfservices.operation.exception.ServiceUsageException;
import com.adobe.pdfservices.operation.internal.ExtensionMediaTypeMapping;
import com.adobe.pdfservices.operation.internal.FileRefImpl;
import com.adobe.pdfservices.operation.internal.InternalExecutionContext;
import com.adobe.pdfservices.operation.internal.MediaType;
import com.adobe.pdfservices.operation.internal.api.FileDownloadApi;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.pagemanipulation.PageAction;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.pagemanipulation.RotatePageAction;
import com.adobe.pdfservices.operation.internal.cpf.dto.response.platform.CPFContentAnalyzerResponse;
import com.adobe.pdfservices.operation.internal.exception.OperationException;
import com.adobe.pdfservices.operation.internal.service.RotatePagesService;
import com.adobe.pdfservices.operation.internal.util.FileUtil;
import com.adobe.pdfservices.operation.internal.util.PathUtil;
import com.adobe.pdfservices.operation.internal.util.StringUtil;
import com.adobe.pdfservices.operation.internal.util.ValidationUtil;
import com.adobe.pdfservices.operation.io.FileRef;
import com.adobe.pdfservices.operation.pdfops.options.PageRanges;
import com.adobe.pdfservices.operation.pdfops.options.rotatepages.Angle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RotatePagesOperation
implements Operation {
    private static final Logger LOGGER = LoggerFactory.getLogger(RotatePagesOperation.class);
    private static final Set<String> SUPPORTED_SOURCE_MEDIA_TYPES = new HashSet<String>(Collections.singletonList(ExtensionMediaTypeMapping.PDF.getMediaType()));
    private static final String TARGET_FILE_EXTENSION = ExtensionMediaTypeMapping.PDF.getExtension();
    private boolean isInvoked = false;
    private FileRefImpl sourceFileRef;
    private List<PageAction> pageActions = new ArrayList<PageAction>();

    private RotatePagesOperation() {
    }

    public static RotatePagesOperation createNew() {
        return new RotatePagesOperation();
    }

    public void setInput(FileRef sourceFileRef) {
        Objects.requireNonNull(sourceFileRef, "No input was set for operation");
        this.sourceFileRef = (FileRefImpl)sourceFileRef;
    }

    public void setAngleToRotatePagesBy(Angle angle) {
        Objects.requireNonNull(angle, "Rotate angle can not be null");
        PageRanges pageRanges = new PageRanges();
        pageRanges.addAll();
        RotatePageAction rotatePageAction = new RotatePageAction(angle.getValue(), pageRanges.getRanges());
        this.pageActions.add(rotatePageAction);
    }

    public void setAngleToRotatePagesBy(Angle angle, PageRanges pageRanges) {
        Objects.requireNonNull(angle, "Rotate angle can not be null");
        Objects.requireNonNull(pageRanges, "Page ranges can not be null");
        pageRanges.validate();
        RotatePageAction rotatePageAction = new RotatePageAction(angle.getValue(), pageRanges.getRanges());
        this.pageActions.add(rotatePageAction);
    }

    @Override
    public FileRef execute(ExecutionContext context) throws ServiceApiException, IOException, ServiceUsageException {
        this.validateInvocationCount();
        InternalExecutionContext internalExecutionContext = (InternalExecutionContext)context;
        this.validate(internalExecutionContext);
        try {
            LOGGER.info("All validations successfully done. Beginning Rotate Pages operation execution");
            long startTimeMs = System.currentTimeMillis();
            String location = RotatePagesService.rotatePages(internalExecutionContext, this.sourceFileRef, this.pageActions, this.getClass().getSimpleName());
            String targetFileName = FileUtil.getRandomFileName(TARGET_FILE_EXTENSION);
            String temporaryDestinationPath = PathUtil.getTemporaryDestinationPath(targetFileName, TARGET_FILE_EXTENSION);
            FileDownloadApi.downloadAndSave(internalExecutionContext, location, temporaryDestinationPath, CPFContentAnalyzerResponse.class);
            LOGGER.info("Operation successfully completed. Stored requisite PDF at {}", (Object)temporaryDestinationPath);
            LOGGER.debug("Operation Success Info - Request ID: {}, Latency(ms): {}", (Object)StringUtil.getRequestIdFromLocation(location), (Object)(System.currentTimeMillis() - startTimeMs));
            this.isInvoked = true;
            return FileRef.createFromLocalFile(temporaryDestinationPath);
        }
        catch (OperationException oe) {
            throw new ServiceApiException(oe.getErrorMessage(), oe.getRequestTrackingId(), oe.getStatusCode(), oe.getReportErrorCode());
        }
    }

    private void validateInvocationCount() {
        if (this.isInvoked) {
            LOGGER.error("Operation instance must only be invoked once");
            throw new IllegalStateException("Operation instance must not be reused, can only be invoked once");
        }
    }

    private void validate(InternalExecutionContext context) {
        if (this.sourceFileRef == null) {
            throw new IllegalArgumentException("No input was set for operation");
        }
        if (this.sourceFileRef.getSourceURL() != null) {
            throw new IllegalArgumentException("Input for the Rotate Pages Operation can not be sourced from a URL");
        }
        ValidationUtil.validateRotatePageActions(this.pageActions);
        ValidationUtil.validateExecutionContext(context);
        ValidationUtil.validateMediaType(SUPPORTED_SOURCE_MEDIA_TYPES, this.sourceFileRef.getMediaType());
    }

    public static enum SupportedSourceFormat implements MediaType
    {
        PDF;


        @Override
        public String getMediaType() {
            return ExtensionMediaTypeMapping.valueOf(this.name()).getMediaType().toLowerCase();
        }
    }
}

