/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.pdfops;

import com.adobe.pdfservices.operation.ExecutionContext;
import com.adobe.pdfservices.operation.Operation;
import com.adobe.pdfservices.operation.exception.ServiceApiException;
import com.adobe.pdfservices.operation.exception.ServiceUsageException;
import com.adobe.pdfservices.operation.internal.ExtensionMediaTypeMapping;
import com.adobe.pdfservices.operation.internal.FileRefImpl;
import com.adobe.pdfservices.operation.internal.InternalExecutionContext;
import com.adobe.pdfservices.operation.internal.api.FileDownloadApi;
import com.adobe.pdfservices.operation.internal.exception.OperationException;
import com.adobe.pdfservices.operation.internal.service.PDFPropertiesService;
import com.adobe.pdfservices.operation.internal.util.FileUtil;
import com.adobe.pdfservices.operation.internal.util.PathUtil;
import com.adobe.pdfservices.operation.internal.util.StringUtil;
import com.adobe.pdfservices.operation.internal.util.ValidationUtil;
import com.adobe.pdfservices.operation.io.FileRef;
import com.adobe.pdfservices.operation.pdfops.options.pdfproperties.PDFPropertiesOptions;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFPropertiesOperation
implements Operation {
    private static final Logger LOGGER = LoggerFactory.getLogger(PDFPropertiesOperation.class);
    private static final Set<String> SUPPORTED_SOURCE_MEDIA_TYPES = new HashSet<String>(Collections.singletonList(ExtensionMediaTypeMapping.PDF.getMediaType()));
    private boolean isInvoked = false;
    private static final String TARGET_FILE_EXTENSION = ExtensionMediaTypeMapping.JSON.getExtension();
    private FileRefImpl sourceFileRef;
    private PDFPropertiesOptions pdfPropertiesOptions;

    private PDFPropertiesOperation() {
    }

    public void setOptions(PDFPropertiesOptions pdfPropertiesOptions) {
        this.pdfPropertiesOptions = pdfPropertiesOptions;
    }

    public static PDFPropertiesOperation createNew() {
        return new PDFPropertiesOperation();
    }

    public void setInputFile(FileRef sourceFileRef) {
        Objects.requireNonNull(sourceFileRef, "No input was set for operation");
        this.sourceFileRef = (FileRefImpl)sourceFileRef;
    }

    public FileRef executeAndReturnFileRef(ExecutionContext context) throws ServiceApiException, IOException, ServiceUsageException {
        this.validateInvocationCount();
        InternalExecutionContext internalExecutionContext = (InternalExecutionContext)context;
        this.validate(internalExecutionContext);
        try {
            LOGGER.info("All validations successfully done. Beginning PDFProperties operation execution");
            long startTimeMs = System.currentTimeMillis();
            String location = PDFPropertiesService.getPdfProperties(internalExecutionContext, this.sourceFileRef, this.pdfPropertiesOptions, this.getClass().getSimpleName());
            String targetFileName = FileUtil.getRandomFileName(TARGET_FILE_EXTENSION);
            String temporaryDestinationPath = PathUtil.getTemporaryDestinationPath(targetFileName, TARGET_FILE_EXTENSION);
            FileDownloadApi.downloadAndSaveJson(internalExecutionContext, location, temporaryDestinationPath);
            this.isInvoked = true;
            LOGGER.info("Operation successfully completed. Stored requisite file at {}", (Object)temporaryDestinationPath);
            LOGGER.debug("Operation Success Info - Request ID: {}, Latency(ms): {}", (Object)StringUtil.getRequestIdFromLocation(location), (Object)(System.currentTimeMillis() - startTimeMs));
            return FileRef.createFromLocalFile(temporaryDestinationPath);
        }
        catch (OperationException oe) {
            throw new ServiceApiException(oe.getErrorMessage(), oe.getRequestTrackingId(), oe.getStatusCode(), oe.getReportErrorCode());
        }
    }

    public JSONObject execute(ExecutionContext context) throws ServiceApiException, IOException, ServiceUsageException {
        this.validateInvocationCount();
        InternalExecutionContext internalExecutionContext = (InternalExecutionContext)context;
        this.validate(internalExecutionContext);
        try {
            LOGGER.info("All validations successfully done. Beginning PDFProperties operation execution");
            long startTimeMs = System.currentTimeMillis();
            String location = PDFPropertiesService.getPdfProperties(internalExecutionContext, this.sourceFileRef, this.pdfPropertiesOptions, this.getClass().getSimpleName());
            JSONObject pdfPropertiesJsonObject = FileDownloadApi.downloadAndReturnJSONObject(internalExecutionContext, location);
            this.isInvoked = true;
            LOGGER.info("Operation successfully completed.");
            LOGGER.debug("Operation Success Info - Request ID: {}, Latency(ms): {}", (Object)StringUtil.getRequestIdFromLocation(location), (Object)(System.currentTimeMillis() - startTimeMs));
            return pdfPropertiesJsonObject;
        }
        catch (OperationException oe) {
            throw new ServiceApiException(oe.getErrorMessage(), oe.getRequestTrackingId(), oe.getStatusCode(), oe.getReportErrorCode());
        }
    }

    private void validateInvocationCount() {
        if (this.isInvoked) {
            LOGGER.error("Operation instance must only be invoked once");
            throw new IllegalStateException("Operation instance must not be reused, can only be invoked once");
        }
    }

    private void validate(InternalExecutionContext context) {
        if (this.sourceFileRef == null) {
            throw new IllegalArgumentException("No input was set for operation");
        }
        if (this.sourceFileRef.getSourceURL() != null) {
            throw new IllegalArgumentException("Input for the PDF Properties Operation can not be sourced from a URL");
        }
        ValidationUtil.validateExecutionContext(context);
        ValidationUtil.validateMediaType(SUPPORTED_SOURCE_MEDIA_TYPES, this.sourceFileRef.getMediaType());
    }
}

