/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.pdfops;

import com.adobe.pdfservices.operation.ExecutionContext;
import com.adobe.pdfservices.operation.Operation;
import com.adobe.pdfservices.operation.exception.ServiceApiException;
import com.adobe.pdfservices.operation.exception.ServiceUsageException;
import com.adobe.pdfservices.operation.internal.ExtensionMediaTypeMapping;
import com.adobe.pdfservices.operation.internal.FileRefImpl;
import com.adobe.pdfservices.operation.internal.InternalExecutionContext;
import com.adobe.pdfservices.operation.internal.exception.OperationException;
import com.adobe.pdfservices.operation.internal.service.ExtractPDFService.ExtractPDFService;
import com.adobe.pdfservices.operation.internal.util.FileUtil;
import com.adobe.pdfservices.operation.internal.util.PathUtil;
import com.adobe.pdfservices.operation.internal.util.StringUtil;
import com.adobe.pdfservices.operation.internal.util.ValidationUtil;
import com.adobe.pdfservices.operation.io.FileRef;
import com.adobe.pdfservices.operation.pdfops.options.extractpdf.ExtractPDFOptions;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractPDFOperation
implements Operation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtractPDFOperation.class);
    private static final Set<String> SUPPORTED_SOURCE_MEDIA_TYPE = new HashSet<String>(Arrays.asList(ExtensionMediaTypeMapping.PDF.getMediaType()));
    private boolean isInvoked = false;
    private static ExtensionMediaTypeMapping resultFormat = ExtensionMediaTypeMapping.ZIP;
    private FileRefImpl sourceFileRef;
    private ExtractPDFOptions extractPDFOptions;

    private ExtractPDFOperation() {
    }

    public ExtractPDFOperation setOptions(ExtractPDFOptions extractPDFOptions) {
        this.extractPDFOptions = extractPDFOptions;
        return this;
    }

    public static ExtractPDFOperation createNew() {
        return new ExtractPDFOperation();
    }

    public ExtractPDFOperation setInputFile(FileRef sourceFileRef) {
        Objects.requireNonNull(sourceFileRef, "No input was set for operation");
        this.sourceFileRef = (FileRefImpl)sourceFileRef;
        return this;
    }

    @Override
    public FileRef execute(ExecutionContext context) throws ServiceApiException, IOException, ServiceUsageException {
        this.validateInvocationCount();
        InternalExecutionContext internalExecutionContext = (InternalExecutionContext)context;
        this.validate(internalExecutionContext);
        try {
            LOGGER.info("All validations successfully done. Beginning ExtractPDF operation execution");
            long startTimeMs = System.currentTimeMillis();
            String location = ExtractPDFService.extractPdf(internalExecutionContext, this.sourceFileRef, this.extractPDFOptions, this.getClass().getSimpleName());
            String targetFileName = FileUtil.getRandomFileName(resultFormat.getExtension());
            String temporaryDestinationPath = PathUtil.getTemporaryDestinationPath(targetFileName, resultFormat.getExtension());
            ExtractPDFService.downloadAndSave(internalExecutionContext, location, temporaryDestinationPath, resultFormat);
            this.isInvoked = true;
            LOGGER.info("Extract Operation Successful - Transaction ID: {}", (Object)StringUtil.getRequestIdFromLocation(location));
            return FileRef.createFromLocalFile(temporaryDestinationPath);
        }
        catch (OperationException oe) {
            throw new ServiceApiException(oe.getErrorMessage(), oe.getRequestTrackingId(), oe.getStatusCode(), oe.getReportErrorCode());
        }
    }

    private void validateInvocationCount() {
        if (this.isInvoked) {
            LOGGER.error("Operation instance must only be invoked once");
            throw new IllegalStateException("Operation instance must not be reused, can only be invoked once");
        }
    }

    private void validate(InternalExecutionContext context) {
        if (this.sourceFileRef == null) {
            throw new IllegalArgumentException("No input was set for operation");
        }
        if (this.sourceFileRef.getSourceURL() != null) {
            throw new IllegalArgumentException("Input for the Extract PDF Operation can not be sourced from a URL");
        }
        ValidationUtil.validateExecutionContext(context);
        ValidationUtil.validateMediaType(SUPPORTED_SOURCE_MEDIA_TYPE, this.sourceFileRef.getMediaType());
    }
}

