/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.util;

import java.io.Reader;
import java.io.StringReader;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivateKeyParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrivateKeyParser.class);

    public static PrivateKey parsePrivateKey(String privateKey) {
        PrivateKey returnKey;
        try {
            KeySpec keySpec;
            KeyFactory factory = KeyFactory.getInstance("RSA");
            if (privateKey.contains("-----BEGIN PRIVATE KEY-----")) {
                privateKey = privateKey.replace("-----BEGIN PRIVATE KEY-----\n", "");
                privateKey = privateKey.replace("-----END PRIVATE KEY-----", "");
                privateKey = privateKey.replaceAll("\\s", "");
                keySpec = new PKCS8EncodedKeySpec(Base64.decode((String)privateKey));
            } else {
                PemReader pemReader = new PemReader((Reader)new StringReader(privateKey));
                PemObject pemObject = pemReader.readPemObject();
                ASN1Sequence asn1Sequence = ASN1Sequence.getInstance((Object)pemObject.getContent());
                RSAPrivateKey rsaPrivateKey = RSAPrivateKey.getInstance((Object)asn1Sequence);
                keySpec = new RSAPrivateCrtKeySpec(rsaPrivateKey.getModulus(), rsaPrivateKey.getPublicExponent(), rsaPrivateKey.getPrivateExponent(), rsaPrivateKey.getPrime1(), rsaPrivateKey.getPrime2(), rsaPrivateKey.getExponent1(), rsaPrivateKey.getExponent2(), rsaPrivateKey.getCoefficient());
            }
            returnKey = factory.generatePrivate(keySpec);
        }
        catch (Exception ex) {
            LOGGER.error("Unable to parse provided private key: {}", (Throwable)ex);
            throw new IllegalArgumentException("Private key file could not be parsed. Exception ", ex);
        }
        return returnKey;
    }
}

