/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.util;

import com.adobe.pdfservices.operation.exception.SdkException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonUtil.class);
    private static ObjectMapper objectMapper = new ObjectMapper();

    public static <T> T deserializeJsonStream(InputStream inputStream, Class<T> jsonType) {
        try {
            return (T)objectMapper.readValue(inputStream, jsonType);
        }
        catch (IOException e) {
            LOGGER.error("Error while parsing json stream ", (Throwable)e);
            throw new SdkException("Error while reading json stream ", e);
        }
    }

    public static <T> T deserializeJsonString(String jsonString, Class<T> jsonType) {
        try {
            return (T)objectMapper.readValue(jsonString, jsonType);
        }
        catch (IOException e) {
            LOGGER.error("Error while parsing json string  ", (Throwable)e);
            throw new SdkException(String.format("Error while reading json string %s", jsonString), e);
        }
    }

    public static JsonNode readJsonTreeFromFile(File jsonFile) throws IOException {
        return objectMapper.readTree(jsonFile);
    }

    public static JsonNode readJsonTreeFromString(String json) {
        try {
            return objectMapper.readTree(json);
        }
        catch (IOException e) {
            throw new SdkException("Error while reading json from string ", e);
        }
    }

    public static String convertMapToString(Map<String, Object> json) {
        try {
            return objectMapper.writeValueAsString(json);
        }
        catch (IOException e) {
            throw new SdkException("Error while reading string from json ", e);
        }
    }
}

