/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.service;

import com.adobe.pdfservices.operation.internal.FileRefImpl;
import com.adobe.pdfservices.operation.internal.InternalExecutionContext;
import com.adobe.pdfservices.operation.internal.api.CPFApi;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.CPFContentAnalyzerRequests;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.Inputs;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.protect.PasswordProtectParams;
import com.adobe.pdfservices.operation.internal.http.HttpResponse;
import com.adobe.pdfservices.operation.pdfops.options.protectpdf.ProtectPDFOptions;
import java.io.FileNotFoundException;
import java.util.ArrayList;

public class ProtectPDFService {
    private static final String IO_FORMAT_SPECIFIER = "application/pdf";

    public static String protectPDF(InternalExecutionContext context, FileRefImpl sourceFileRef, ProtectPDFOptions protectPDFOptions, String operation) throws FileNotFoundException {
        PasswordProtectParams passwordProtectParams = PasswordProtectParams.createFrom(protectPDFOptions);
        Inputs inputs = Inputs.builder(IO_FORMAT_SPECIFIER).setParams(passwordProtectParams).build();
        CPFContentAnalyzerRequests cpfContentAnalyzerRequests = new CPFContentAnalyzerRequests("urn:aaid:cpf:Service-627aa455ac5d4c338ad49ca882e0fce5", inputs, IO_FORMAT_SPECIFIER);
        ArrayList<FileRefImpl> sourceFileRefList = new ArrayList<FileRefImpl>();
        sourceFileRefList.add(sourceFileRef);
        HttpResponse<String> response = CPFApi.cpfCreateOpsApi(context, cpfContentAnalyzerRequests, sourceFileRefList, String.class, operation);
        return response.getHeaders().get("location");
    }
}

