/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.service;

import com.adobe.pdfservices.operation.internal.FileRefImpl;
import com.adobe.pdfservices.operation.internal.InternalExecutionContext;
import com.adobe.pdfservices.operation.internal.api.CPFApi;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.CPFContentAnalyzerRequests;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.Inputs;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.Outputs;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.PDFPropertiesParams;
import com.adobe.pdfservices.operation.internal.http.HttpResponse;
import com.adobe.pdfservices.operation.pdfops.options.pdfproperties.PDFPropertiesOptions;
import java.io.FileNotFoundException;
import java.util.ArrayList;

public class PDFPropertiesService {
    private static final String INPUT_FORMAT_SPECIFIER = "application/pdf";
    private static final String OUTPUT_PDFPROPERTIES_INFO_FORMAT_SPECIFIER = "application/json";

    public static String getPdfProperties(InternalExecutionContext context, FileRefImpl sourceFileRef, PDFPropertiesOptions pdfPropertiesOptions, String operation) throws FileNotFoundException {
        PDFPropertiesParams pdfPropertiesParams = PDFPropertiesParams.createFrom(pdfPropertiesOptions);
        Inputs inputs = Inputs.builder(INPUT_FORMAT_SPECIFIER).setParams(pdfPropertiesParams).build();
        Outputs outputs = new Outputs();
        outputs.setMetadataFrom(OUTPUT_PDFPROPERTIES_INFO_FORMAT_SPECIFIER);
        CPFContentAnalyzerRequests cpfContentAnalyzerRequests = new CPFContentAnalyzerRequests("urn:aaid:cpf:Service-fd9b06fe2f164df7975254581d6ab00e", inputs, outputs);
        ArrayList<FileRefImpl> sourceFileRefList = new ArrayList<FileRefImpl>();
        sourceFileRefList.add(sourceFileRef);
        HttpResponse<String> response = CPFApi.cpfCreateOpsApi(context, cpfContentAnalyzerRequests, sourceFileRefList, String.class, operation);
        return response.getHeaders().get("location");
    }
}

