/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.service.ExtractPDFService;

import com.adobe.pdfservices.operation.exception.SdkException;
import com.adobe.pdfservices.operation.internal.ExtensionMediaTypeMapping;
import com.adobe.pdfservices.operation.internal.FileRefImpl;
import com.adobe.pdfservices.operation.internal.InternalExecutionContext;
import com.adobe.pdfservices.operation.internal.api.CPFApi;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.CPFContentAnalyzerRequests;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.ExtractPDFOutputFormat;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.ExtractPDFParams;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.Inputs;
import com.adobe.pdfservices.operation.internal.cpf.dto.response.platform.CPFContentAnalyzerResponse;
import com.adobe.pdfservices.operation.internal.cpf.dto.response.platform.ExtractPDF.ExtractPDFOutput;
import com.adobe.pdfservices.operation.internal.http.HttpResponse;
import com.adobe.pdfservices.operation.internal.http.MultiPartHttpResponse;
import com.adobe.pdfservices.operation.internal.service.ExtractPDFService.ExtractDataParser;
import com.adobe.pdfservices.operation.internal.service.ExtractPDFService.ExtractDataZipper;
import com.adobe.pdfservices.operation.pdfops.options.extractpdf.ExtractPDFOptions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.mail.internet.MimeBodyPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractPDFService {
    private static final String INPUT_FORMAT_SPECIFIER = "application/pdf";
    private static final String OUTPUT_EXTRACT_INFO_FORMAT_SPECIFIER = "application/json";
    private static final String OUTPUT_EXTRACT_RENDITION_FORMAT_SPECIFIER = "text/directory";
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtractPDFService.class);

    public static String extractPdf(InternalExecutionContext context, FileRefImpl sourceFileRef, ExtractPDFOptions extractPdfOptions, String operation) throws FileNotFoundException {
        long startTimeMs = System.currentTimeMillis();
        ExtractPDFParams extractPDFParams = ExtractPDFParams.createFrom(extractPdfOptions);
        Inputs inputs = Inputs.builder(INPUT_FORMAT_SPECIFIER).setParams(extractPDFParams).build();
        ExtractPDFOutputFormat outputs = new ExtractPDFOutputFormat(OUTPUT_EXTRACT_INFO_FORMAT_SPECIFIER, OUTPUT_EXTRACT_RENDITION_FORMAT_SPECIFIER);
        String extractAnalyzerID = "urn:aaid:cpf:58af6e2c-1f0c-400d-9188-078000185695";
        CPFContentAnalyzerRequests CPFContentAnalyzerRequests2 = new CPFContentAnalyzerRequests(extractAnalyzerID, inputs, outputs);
        ArrayList<FileRefImpl> sourceFileRefList = new ArrayList<FileRefImpl>();
        sourceFileRefList.add(sourceFileRef);
        HttpResponse<String> response = CPFApi.cpfCreateOpsApi(context, CPFContentAnalyzerRequests2, sourceFileRefList, String.class, operation);
        LOGGER.debug("Upload Operation Success Info - Latency(ms): {}", (Object)(System.currentTimeMillis() - startTimeMs));
        return response.getHeaders().get("location");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadAndSave(InternalExecutionContext context, String location, String destinationPath, ExtensionMediaTypeMapping outputFormat) {
        long startTimeMs = System.currentTimeMillis();
        HttpResponse<CPFContentAnalyzerResponse> response = CPFApi.cpfStatusApi(context, location, CPFContentAnalyzerResponse.class);
        LOGGER.debug("Download Operation Success Info - Latency(ms): {}", (Object)(System.currentTimeMillis() - startTimeMs));
        MultiPartHttpResponse multiPartData = (MultiPartHttpResponse)response;
        List<MimeBodyPart> responseData = multiPartData.getResponseBodyParts();
        try {
            startTimeMs = System.currentTimeMillis();
            ExtractPDFOutput extractPDFOutput = ExtractDataParser.frameExtractSpecificOutput(responseData);
            ExtractDataZipper.zipExtractOutput(extractPDFOutput, destinationPath);
            LOGGER.debug("Response Manipulation Success Info - Latency(ms): {}", (Object)(System.currentTimeMillis() - startTimeMs));
        }
        catch (IOException e) {
            LOGGER.error("Error {} while writing downloaded file to location {} ", (Object)e, (Object)destinationPath);
            throw new SdkException("Exception encountered while downloading file", e);
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage());
        }
        finally {
            try {
                response.consume();
            }
            catch (IOException e) {
                LOGGER.error("Error while consuming file download response ", (Throwable)e);
            }
        }
    }
}

