/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.service;

import com.adobe.pdfservices.operation.internal.ExtensionMediaTypeMapping;
import com.adobe.pdfservices.operation.internal.FileRefImpl;
import com.adobe.pdfservices.operation.internal.InternalExecutionContext;
import com.adobe.pdfservices.operation.internal.api.CPFApi;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.CPFContentAnalyzerRequests;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.Inputs;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.createpdf.CreatePDFParams;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.htmltopdf.HTMLToPDFParams;
import com.adobe.pdfservices.operation.internal.http.HttpResponse;
import com.adobe.pdfservices.operation.pdfops.options.createpdf.CreatePDFOptions;
import java.io.FileNotFoundException;
import java.util.ArrayList;

public class CreatePDFService {
    private static final String OUTPUT_FORMAT_SPECIFIER = "application/pdf";

    public static String convertToPdf(InternalExecutionContext context, FileRefImpl sourceFileRef, CreatePDFOptions createPDFOptions, String operation) throws FileNotFoundException {
        CPFContentAnalyzerRequests cpfContentAnalyzerRequests;
        Inputs inputs = null;
        ExtensionMediaTypeMapping extensionMediaTypeMapping = ExtensionMediaTypeMapping.getFromMimeType(sourceFileRef.getMediaType());
        if (sourceFileRef.getSourceURL() != null) {
            HTMLToPDFParams htmlToPDFParams = HTMLToPDFParams.createFrom(createPDFOptions);
            inputs = Inputs.builder(sourceFileRef.getMediaType()).setParams(htmlToPDFParams).setSourceUrl(sourceFileRef.getSourceURL()).build();
            cpfContentAnalyzerRequests = new CPFContentAnalyzerRequests("urn:aaid:cpf:Service-e2ee120a2b06427cb449592f5db967e7", inputs, OUTPUT_FORMAT_SPECIFIER);
        } else {
            assert (extensionMediaTypeMapping != null);
            switch (extensionMediaTypeMapping) {
                case HTML: 
                case ZIP: {
                    HTMLToPDFParams htmlToPDFParams = HTMLToPDFParams.createFrom(createPDFOptions);
                    inputs = Inputs.builder(sourceFileRef.getMediaType()).setParams(htmlToPDFParams).build();
                    cpfContentAnalyzerRequests = new CPFContentAnalyzerRequests("urn:aaid:cpf:Service-e2ee120a2b06427cb449592f5db967e7", inputs, OUTPUT_FORMAT_SPECIFIER);
                    break;
                }
                default: {
                    CreatePDFParams createPDFParams = CreatePDFParams.createFrom(createPDFOptions);
                    inputs = Inputs.builder(sourceFileRef.getMediaType()).setParams(createPDFParams).build();
                    cpfContentAnalyzerRequests = new CPFContentAnalyzerRequests("urn:aaid:cpf:Service-1538ece812254acaac2a07799503a430", inputs, OUTPUT_FORMAT_SPECIFIER);
                }
            }
        }
        ArrayList<FileRefImpl> sourceFileRefList = new ArrayList<FileRefImpl>();
        sourceFileRefList.add(sourceFileRef);
        HttpResponse<String> response = CPFApi.cpfCreateOpsApi(context, cpfContentAnalyzerRequests, sourceFileRefList, String.class, operation);
        return response.getHeaders().get("location");
    }
}

