/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.http;

import com.adobe.pdfservices.operation.exception.SdkException;
import com.adobe.pdfservices.operation.exception.ServiceUsageException;
import com.adobe.pdfservices.operation.internal.GlobalConfig;
import com.adobe.pdfservices.operation.internal.cpf.constants.RequestKey;
import com.adobe.pdfservices.operation.internal.cpf.dto.response.CPFErrorResponse;
import com.adobe.pdfservices.operation.internal.cpf.dto.response.platform.CPFContentAnalyzerResponse;
import com.adobe.pdfservices.operation.internal.cpf.dto.response.platform.CPFStatus;
import com.adobe.pdfservices.operation.internal.dto.response.ErrorResponse;
import com.adobe.pdfservices.operation.internal.dto.response.ImsErrorResponse;
import com.adobe.pdfservices.operation.internal.exception.OperationException;
import com.adobe.pdfservices.operation.internal.exception.UnauthorizedClientException;
import com.adobe.pdfservices.operation.internal.http.ApacheHttpUtil;
import com.adobe.pdfservices.operation.internal.http.BaseHttpResponse;
import com.adobe.pdfservices.operation.internal.http.HttpClient;
import com.adobe.pdfservices.operation.internal.http.HttpRequest;
import com.adobe.pdfservices.operation.internal.http.HttpResponse;
import com.adobe.pdfservices.operation.internal.http.MultiPartHttpResponse;
import com.adobe.pdfservices.operation.internal.http.config.HttpClientConfig;
import com.adobe.pdfservices.operation.internal.util.JsonUtil;
import com.adobe.pdfservices.operation.internal.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Set;
import javax.mail.MessagingException;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientWrapper
implements HttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClient.class);
    private static final int ACCEPTED_SUCCESS_STATUS_CODE = 202;
    private static final int SERVICE_USAGE_EXCEPTION_STATUS_CODE = 429;
    private static final String MULTIPART_IDENTIFIER_STRING = "multipart";
    private static final String UNAUTHORIZED_ERROR_CODE = "401013";
    private static final String IMS_INVALID_TOKEN_ERROR_STRING = "invalid_token";
    private static final String IMS_CERTIFICATE_EXPIRY_ERROR_DESCRIPTION_STRING = "Could not match JWT signature to any of the bindings";
    private static final String SERVICE_USAGE_EXCEPTION_STATUS_CODE_429001_STRING = "429001";
    private static final String SERVICE_USAGE_EXCEPTION_STATUS_CODE_429002_STRING = "429002";
    private int connectTimeout;
    private int socketTimeout;
    private org.apache.http.client.HttpClient httpClient;
    private int maxRetries;
    private Set<Integer> retriableErrorCodes;
    private Set<Integer> successResponseCodes;

    public HttpClientWrapper(HttpClientConfig httpClientConfig) {
        this.connectTimeout = httpClientConfig.getConnectTimeout();
        this.socketTimeout = httpClientConfig.getSocketTimeout();
        this.maxRetries = httpClientConfig.getMaxRetries();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(GlobalConfig.getMaxApacheConnections());
        cm.setDefaultMaxPerRoute(GlobalConfig.getMaxApacheConnectionsPerRoute());
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.connectTimeout).setSocketTimeout(this.socketTimeout).build();
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(requestConfig).disableAutomaticRetries().build();
        this.retriableErrorCodes = GlobalConfig.getRetriableResponseCodes();
        this.successResponseCodes = GlobalConfig.getSuccessResponseCodes();
    }

    @Override
    public <T> HttpResponse<T> send(HttpRequest httpRequest, Class<T> responseType) {
        RetryPolicy<HttpResponse<T>> retryPolicy = this.getAuthenticationRetryPolicy(httpRequest);
        return (HttpResponse)Failsafe.with((Policy[])new RetryPolicy[]{retryPolicy}).get(() -> this.executeRequest(httpRequest, responseType));
    }

    private <T> RetryPolicy<HttpResponse<T>> getAuthenticationRetryPolicy(HttpRequest httpRequest) {
        return ((RetryPolicy)new RetryPolicy().withMaxRetries(this.maxRetries).handle(UnauthorizedClientException.class)).onFailedAttempt(listener -> {
            LOGGER.debug(" Retry attempt count {} ", (Object)listener.getAttemptCount());
            if (listener.getAttemptCount() <= this.maxRetries) {
                httpRequest.forceAuthenticate();
            }
        });
    }

    private <T> HttpResponse<T> executeRequest(HttpRequest httpRequest, Class<T> responseType) throws IOException, MessagingException {
        httpRequest.authenticate();
        HttpUriRequest apacheHttpRequest = ApacheHttpUtil.getApacheRequest(httpRequest);
        org.apache.http.HttpResponse httpResponse = this.executeApacheHttpRequest(httpRequest, apacheHttpRequest);
        return this.handleResponse(httpResponse, httpRequest, responseType);
    }

    private org.apache.http.HttpResponse executeApacheHttpRequest(HttpRequest httpRequest, HttpUriRequest apacheHttpRequest) {
        org.apache.http.HttpResponse httpResponse;
        try {
            httpResponse = this.httpClient.execute(apacheHttpRequest);
        }
        catch (ClientProtocolException e) {
            LOGGER.error("Error in http protocol, request could not be completed ", (Throwable)e);
            throw new SdkException("Http protocol exception encountered while executing request ", e);
        }
        catch (IOException e) {
            LOGGER.warn("Connection exception encountered while executing request {} ", (Object)httpRequest.getRequestKey().getValue());
            throw new SdkException("Request could not be completed. Possible cause attached!", e);
        }
        return httpResponse;
    }

    private void checkPlatformContentResponseStatusCode(CPFContentAnalyzerResponse CPFContentAnalyzerResponse2, String requestId) throws OperationException {
        if (CPFContentAnalyzerResponse2 == null) {
            return;
        }
        if (Objects.nonNull(CPFContentAnalyzerResponse2.getCPFStatus())) {
            CPFStatus CPFStatus2 = CPFContentAnalyzerResponse2.getCPFStatus();
            String reportErrorCode = null;
            if (Objects.nonNull(CPFStatus2.getReport())) {
                reportErrorCode = CPFStatus2.getReport().getErrorCode();
            }
            if (!this.successResponseCodes.contains(CPFStatus2)) {
                throw new OperationException(CPFStatus2.getTitle(), CPFStatus2.getStatus(), requestId, null, CPFStatus2.getTitle(), null, reportErrorCode);
            }
        }
    }

    private <T> HttpResponse<T> handleResponse(org.apache.http.HttpResponse httpResponse, HttpRequest httpRequest, Class<T> responseType) throws IOException, MessagingException {
        if (httpResponse == null) {
            return null;
        }
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        LOGGER.debug("Response received {} ", (Object)httpResponse);
        InputStream responseContent = httpResponse.getEntity().getContent();
        RequestKey requestKey = httpRequest.getRequestKey();
        if (this.successResponseCodes.contains(statusCode)) {
            LOGGER.debug("Success response code {} received for request {}", (Object)statusCode, (Object)requestKey.getValue());
            if (statusCode == 202) {
                responseContent.close();
                return new BaseHttpResponse(statusCode, ApacheHttpUtil.getHeaders(httpResponse.getAllHeaders()));
            }
            if (httpResponse.getFirstHeader("Content-Type").getValue().contains(MULTIPART_IDENTIFIER_STRING)) {
                return new MultiPartHttpResponse<T>(statusCode, ApacheHttpUtil.getHeaders(httpResponse.getAllHeaders()), responseContent, responseType);
            }
            T dcBaseResponseDto = JsonUtil.deserializeJsonStream(responseContent, responseType);
            if (dcBaseResponseDto instanceof CPFContentAnalyzerResponse) {
                this.checkPlatformContentResponseStatusCode((CPFContentAnalyzerResponse)dcBaseResponseDto, ApacheHttpUtil.getHeaders(httpResponse.getAllHeaders()).get("x-request-id"));
            }
            return new BaseHttpResponse<T>(statusCode, ApacheHttpUtil.getHeaders(httpResponse.getAllHeaders()), dcBaseResponseDto);
        }
        String errorResponseBody = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        LOGGER.error("Failure response code {} encountered from backend", (Object)statusCode);
        if (GlobalConfig.isCustomErrorMessageRequired(statusCode)) {
            throw new OperationException("Error response received for request", statusCode, this.getRequestTrackingIdFromResponse(httpResponse, requestKey.getValue()), GlobalConfig.getErrorCodeForHttpStatusCode(statusCode), GlobalConfig.getErrorMessageForHttpStatusCode(statusCode), errorResponseBody);
        }
        this.handleIMSCallFailure(httpResponse, statusCode, requestKey, errorResponseBody);
        if (statusCode == 429) {
            this.handleServiceUsageFailure(errorResponseBody, httpResponse, requestKey, statusCode);
        }
        ErrorResponse errorResponse = this.getErrorResponseFromBody(errorResponseBody, statusCode);
        if (this.retriableErrorCodes.contains(statusCode) && statusCode == 401 && errorResponse.getCode().equalsIgnoreCase(UNAUTHORIZED_ERROR_CODE)) {
            LOGGER.debug("Request was not authenticated. Will retry with refreshed session token");
            throw new UnauthorizedClientException(String.format("Error response received for request %s", requestKey.getValue()), statusCode, this.getRequestTrackingIdFromResponse(httpResponse, requestKey.getValue()), errorResponse.getCode(), errorResponse.getMessage(), errorResponseBody);
        }
        throw new OperationException("Error response received for request", statusCode, this.getRequestTrackingIdFromResponse(httpResponse, requestKey.getValue()), errorResponse.getCode(), errorResponse.getMessage(), errorResponseBody, errorResponse.getReportErrorCode());
    }

    private ErrorResponse getErrorResponseFromBody(String errorResponseBody, int statusCode) {
        CPFErrorResponse errorResponse = JsonUtil.deserializeJsonString(errorResponseBody, CPFErrorResponse.class);
        String errorCode = errorResponse.getErrorCode();
        String errorMessage = errorResponse.getMessage();
        String reportErrorCode = null;
        if (Objects.nonNull(errorResponse.getStatus())) {
            errorCode = String.valueOf(errorResponse.getStatus());
            if (StringUtil.isNotBlank(errorResponse.getTitle())) {
                errorMessage = errorResponse.getTitle();
            }
        } else if (Objects.nonNull(errorResponse.getReason())) {
            errorCode = String.valueOf(statusCode);
            errorMessage = errorResponse.getReason();
        } else if (Objects.nonNull(errorResponse.getCPFStatus())) {
            if (Objects.nonNull(errorResponse.getCPFStatus().getReport())) {
                reportErrorCode = errorResponse.getCPFStatus().getReport().getErrorCode();
            }
            errorCode = String.valueOf(errorResponse.getCPFStatus().getStatus());
            errorMessage = errorResponse.getCPFStatus().getTitle();
        } else if (Objects.nonNull(errorResponse.getCpfError())) {
            errorCode = String.valueOf(statusCode);
            errorMessage = errorResponse.getCpfError().getMessage();
        }
        return new ErrorResponse(errorCode, errorMessage, reportErrorCode);
    }

    private void handleIMSCallFailure(org.apache.http.HttpResponse httpResponse, int statusCode, RequestKey requestKey, String errorResponseBody) {
        if (!this.isNotAuthenticationRequest(requestKey)) {
            LOGGER.error("IMS call failed with status code {}", (Object)statusCode);
            ImsErrorResponse imsErrorResponse = JsonUtil.deserializeJsonString(errorResponseBody, ImsErrorResponse.class);
            if (imsErrorResponse.getErrorDescription() == null) {
                imsErrorResponse.setErrorDescription(imsErrorResponse.getError());
            }
            if (imsErrorResponse.getError().equals(IMS_INVALID_TOKEN_ERROR_STRING)) {
                if (imsErrorResponse.getErrorDescription().equals(IMS_CERTIFICATE_EXPIRY_ERROR_DESCRIPTION_STRING)) {
                    imsErrorResponse.setErrorDescription("Your certificate for PDF Services API credentials might have expired. Please visit Adobe IO Console(http://console.adobe.io/) to update your public certificate to use the same credentials.");
                } else {
                    imsErrorResponse.setErrorDescription("Either your certificate for PDF Services API credentials has expired or an invalid Organization_ID/Account_ID has been used in credentials. Please visit Adobe IO Console(http://console.adobe.io/) to update your public certificate to use the same credentials or to check the value of Organization Id or Account ID.");
                }
            }
            throw new OperationException(String.format("Error response received for request %s", new Object[]{requestKey}), statusCode, this.getRequestTrackingIdFromResponse(httpResponse, requestKey.getValue()), imsErrorResponse.getError(), imsErrorResponse.getErrorDescription(), errorResponseBody);
        }
    }

    private void handleServiceUsageFailure(String errorResponseBody, org.apache.http.HttpResponse httpResponse, RequestKey requestKey, int statusCode) {
        CPFErrorResponse errorResponse = JsonUtil.deserializeJsonString(errorResponseBody, CPFErrorResponse.class);
        String errorCode = null;
        if (Objects.nonNull(errorResponse.getCPFStatus())) {
            if (Objects.nonNull(errorResponse.getCPFStatus().getReport())) {
                errorCode = errorResponse.getCPFStatus().getReport().getErrorCode();
            }
            errorResponse.setMessage("Either Quota for this operation is not available or Free trial quota is exhausted. Please visit (www.adobe.com/go/pdftoolsapi_home) to start using free trial quota or (www.adobe.com/go/pdftoolsapi_err_quota) to upgrade to paid credentials.");
        } else if (errorResponse.getErrorCode().equals(SERVICE_USAGE_EXCEPTION_STATUS_CODE_429001_STRING)) {
            errorResponse.setMessage("Service usage limit has been reached. Please retry after sometime.");
        } else if (errorResponse.getErrorCode().equals(SERVICE_USAGE_EXCEPTION_STATUS_CODE_429002_STRING)) {
            errorResponse.setMessage("Service usage limit has been reached for the integration. Please retry after sometime.");
        }
        throw new ServiceUsageException(errorResponse.getMessage(), this.getRequestTrackingIdFromResponse(httpResponse, requestKey.getValue()), statusCode, errorCode);
    }

    private boolean isNotAuthenticationRequest(RequestKey requestKey) {
        return requestKey != RequestKey.AUTHN;
    }

    private String getRequestTrackingIdFromResponse(org.apache.http.HttpResponse httpResponse, String requestKey) {
        if ("ims.session_token".equalsIgnoreCase(requestKey)) {
            return httpResponse.getFirstHeader("X-DEBUG-ID").getValue();
        }
        return httpResponse.getFirstHeader("x-request-id").getValue();
    }
}

