/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.cpf.dto.response.platform.ExtractPDF;

import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.MultiPartFormField;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;

public class ExtractOutputMetaData {
    private List<MultiPartFormField> elementsRenditions;
    private List<MultiPartFormField> tableStructure;
    private MultiPartFormField elementsInfo;
    private MultiPartFormField info;
    private Map<String, MultiPartFormField> indexedMetaInfo;

    private void parseToIndexedMetaInfo() {
        this.indexedMetaInfo = new HashMap<String, MultiPartFormField>();
        if (this.elementsInfo != null) {
            this.indexedMetaInfo.put(this.elementsInfo.getLocation(), this.elementsInfo);
        }
        if (CollectionUtils.isNotEmpty(this.elementsRenditions)) {
            for (MultiPartFormField rendition : this.elementsRenditions) {
                this.indexedMetaInfo.put(rendition.getLocation(), rendition);
            }
        }
    }

    public ExtractOutputMetaData(@JsonProperty(value="elementsInfo") MultiPartFormField elementsInfo, @JsonProperty(value="elementsRenditions") List<MultiPartFormField> elementsRenditions) {
        this.elementsInfo = elementsInfo;
        this.elementsRenditions = elementsRenditions;
        this.parseToIndexedMetaInfo();
    }

    public List<MultiPartFormField> getElementsRenditions() {
        return this.elementsRenditions;
    }

    public MultiPartFormField getElementsInfo() {
        return this.elementsInfo;
    }

    public Map<String, MultiPartFormField> getIndexedMetaInfo() {
        return this.indexedMetaInfo;
    }
}

