/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.protect;

import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.PlatformParams;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.protect.PasswordProtection;
import com.adobe.pdfservices.operation.pdfops.options.protectpdf.PasswordProtectOptions;
import com.adobe.pdfservices.operation.pdfops.options.protectpdf.Permission;
import com.adobe.pdfservices.operation.pdfops.options.protectpdf.ProtectPDFOptions;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PasswordProtectParams
implements PlatformParams {
    @JsonProperty(value="passwordProtection")
    private PasswordProtection passwordProtection;
    @JsonProperty(value="encryptionAlgorithm")
    private String encryptionAlgorithm;
    @JsonProperty(value="contentToEncrypt")
    private String contentToEncrypt;
    @JsonProperty(value="permissions")
    private List<String> permissions;

    private PasswordProtectParams(PasswordProtectOptions passwordProtectOptions) {
        this.passwordProtection = new PasswordProtection(passwordProtectOptions.getUserPassword(), passwordProtectOptions.getOwnerPassword());
        this.encryptionAlgorithm = passwordProtectOptions.getEncryptionAlgorithm().getValue();
        if (passwordProtectOptions.getContentEncryption() != null) {
            this.contentToEncrypt = passwordProtectOptions.getContentEncryption().getValue();
        }
        if (passwordProtectOptions.getPermissions() != null && !passwordProtectOptions.getPermissions().getValues().isEmpty()) {
            this.permissions = new ArrayList<String>();
            for (Permission permission : passwordProtectOptions.getPermissions().getValues()) {
                this.permissions.add(permission.getValue());
            }
        }
    }

    public static PasswordProtectParams createFrom(ProtectPDFOptions protectPDFOptions) {
        PasswordProtectParams protectPDFParams = null;
        if (protectPDFOptions != null) {
            protectPDFParams = new PasswordProtectParams((PasswordProtectOptions)protectPDFOptions);
        }
        return protectPDFParams;
    }
}

