/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal;

import com.adobe.pdfservices.operation.ClientConfig;
import com.adobe.pdfservices.operation.internal.GlobalConfig;

public class InternalClientConfig
extends ClientConfig {
    private Integer connectTimeout;
    private Integer socketTimeout;
    private String opsCreateUri;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyScheme;

    public InternalClientConfig(Integer connectTimeout, Integer socketTimeout, String opsCreateUri, String proxyHost, Integer proxyPort, String proxyScheme) {
        this.connectTimeout = connectTimeout != null ? connectTimeout : GlobalConfig.getConnectTimeout();
        this.socketTimeout = socketTimeout != null ? socketTimeout : GlobalConfig.getSocketTimeout();
        this.opsCreateUri = opsCreateUri != null ? opsCreateUri : GlobalConfig.getOpsCreateUri();
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort != null ? proxyPort : GlobalConfig.getProxyPort();
        this.proxyScheme = proxyScheme;
    }

    public InternalClientConfig() {
        this.connectTimeout = GlobalConfig.getConnectTimeout();
        this.socketTimeout = GlobalConfig.getSocketTimeout();
        this.opsCreateUri = GlobalConfig.getOpsCreateUri();
        this.proxyPort = GlobalConfig.getProxyPort();
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    public String getOpsCreateUri() {
        return this.opsCreateUri;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyScheme() {
        return this.proxyScheme;
    }

    public void validate() {
        if (this.socketTimeout <= 0) {
            throw new IllegalArgumentException(String.format("Invalid value for socket timeout %s Must be valid integer greater than 0", this.socketTimeout));
        }
        if (this.connectTimeout <= 0) {
            throw new IllegalArgumentException(String.format("Invalid value for connect timeout %s Must be valid integer greater than 0", this.connectTimeout));
        }
        if (this.proxyPort <= 0 && !this.proxyPort.equals(GlobalConfig.getProxyPort())) {
            throw new IllegalArgumentException(String.format("Invalid value for proxy Port %s. Must be valid integer greater than 0", this.proxyPort));
        }
    }
}

