/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal;

import com.adobe.pdfservices.operation.internal.auth.AuthenticationType;
import com.adobe.pdfservices.operation.internal.http.HttpClientType;
import com.adobe.pdfservices.operation.internal.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalConfig.class);
    private static final String SYSTEM_TEMPORARY_DIRECTORY = "java.io.tmpdir";
    private static final String SERVICE_CONFIG_FILE = "dc-services-default-config.properties";
    private static final String HTTP_ERROR_CODE_CONFIG_FILE = "http-error-code.properties";
    private static final HttpClientType DEFAULT_HTTP_CLIENT_TYPE = HttpClientType.APACHE;
    private static final AuthenticationType DEFAULT_AUTHENTICATION_TYPE = AuthenticationType.SERVICE_ACCOUNT;
    private static Properties sdkConfigProperties = new Properties();
    private static Properties httpErrorCodeProperties = new Properties();

    public static int getConnectTimeout() {
        return Integer.parseInt(sdkConfigProperties.getProperty("http.connectTimeout"));
    }

    public static int getSocketTimeout() {
        return Integer.parseInt(sdkConfigProperties.getProperty("http.socketTimeout"));
    }

    public static int getMaxRetries() {
        return Integer.parseInt(sdkConfigProperties.getProperty("http.maxRetries"));
    }

    public static int getRetryDelayFactor() {
        return Integer.parseInt(sdkConfigProperties.getProperty("http.retryDelayFactor"));
    }

    public static int getMaxRetryInterval() {
        return Integer.parseInt(sdkConfigProperties.getProperty("http.maxRetryInterval"));
    }

    public static int getRetryBackoffInterval() {
        return Integer.parseInt(sdkConfigProperties.getProperty("http.retryBackoffInterval"));
    }

    public static Set<Integer> getSuccessResponseCodes() {
        String successResponseCodeString = sdkConfigProperties.getProperty("http.successResponseCode");
        return Arrays.stream(successResponseCodeString.split(",")).map(Integer::parseInt).collect(Collectors.toSet());
    }

    public static Set<Integer> getRetriableResponseCodes() {
        String retriableResponseCodeString = sdkConfigProperties.getProperty("http.retriableResponseCode");
        return Arrays.stream(retriableResponseCodeString.split(",")).map(Integer::parseInt).collect(Collectors.toSet());
    }

    public static int getMaxApacheConnections() {
        return Integer.parseInt(sdkConfigProperties.getProperty("apache.client.maxConnection"));
    }

    public static int getMaxApacheConnectionsPerRoute() {
        return Integer.parseInt(sdkConfigProperties.getProperty("apache.client.maxConnectionPerRoute"));
    }

    public static HttpClientType getDefaultHttpClientType() {
        return DEFAULT_HTTP_CLIENT_TYPE;
    }

    public static AuthenticationType getDefaultAuthenticationType() {
        return DEFAULT_AUTHENTICATION_TYPE;
    }

    public static String getSystemTemporaryDirectory() {
        return System.getProperty(SYSTEM_TEMPORARY_DIRECTORY);
    }

    public static String getAppInfo() {
        return String.join((CharSequence)"/", sdkConfigProperties.getProperty("app.info").split(","));
    }

    public static String getAppInfoPrependedToRequestId() {
        return sdkConfigProperties.getProperty("app.info.prepend.request.id");
    }

    public static String getImsBaseUri() {
        return sdkConfigProperties.getProperty("jwt.base.uri");
    }

    public static String getClaim() {
        return sdkConfigProperties.getProperty("jwt.claim");
    }

    public static String getJwtUriSuffix() {
        return sdkConfigProperties.getProperty("jwt.uri.suffix");
    }

    public static String getJwtAudienceSuffix() {
        return sdkConfigProperties.getProperty("jwt.audience.suffix");
    }

    public static String getTemporaryOperationResultDirectory() {
        return sdkConfigProperties.getProperty("operation.result.tempdirectory");
    }

    public static Set<String> getAllowedUrlProtocols() {
        return new HashSet<String>(Collections.singletonList("https"));
    }

    public static boolean isCustomErrorMessageRequired(int httpErrorCode) {
        String errorCode = httpErrorCodeProperties.getProperty(String.valueOf(httpErrorCode));
        return StringUtil.isNotBlank(errorCode);
    }

    public static String getErrorCodeForHttpStatusCode(int httpErrorCode) {
        String property = httpErrorCodeProperties.getProperty(Integer.toString(httpErrorCode));
        return property.split(":")[0];
    }

    public static String getErrorMessageForHttpStatusCode(int httpErrorCode) {
        String property = httpErrorCodeProperties.getProperty(Integer.toString(httpErrorCode));
        return property.split(":")[1];
    }

    public static String getOpsCreateUri() {
        return sdkConfigProperties.getProperty("cpf.ops.create.uri");
    }

    public static Integer getProxyPort() {
        return Integer.parseInt(sdkConfigProperties.getProperty("http.proxyPort"));
    }

    public static String getExtractOpsAnalyzerID() {
        return sdkConfigProperties.getProperty("cpf.ops.extract.analyzerId");
    }

    static {
        InputStream resourceAsStream = GlobalConfig.class.getClassLoader().getResourceAsStream(SERVICE_CONFIG_FILE);
        InputStream errorCodeStream = GlobalConfig.class.getClassLoader().getResourceAsStream(HTTP_ERROR_CODE_CONFIG_FILE);
        try {
            sdkConfigProperties.load(resourceAsStream);
            httpErrorCodeProperties.load(errorCodeStream);
        }
        catch (IOException e) {
            LOGGER.warn("Cannot load config properties! Application will not function properly");
        }
    }

    private static class PropertyKeys {
        private static final String CONNECT_TIMEOUT_KEY = "http.connectTimeout";
        private static final String SOCKET_TIMEOUT_KEY = "http.socketTimeout";
        private static final String MAX_RETRIES_KEY = "http.maxRetries";
        private static final String RETRY_DELAY_FACTOR = "http.retryDelayFactor";
        private static final String MAX_RETRY_INTERVAL = "http.maxRetryInterval";
        private static final String BACKOFF_INTERVAL_KEY = "http.retryBackoffInterval";
        private static final String SUCCESS_RESPONSE_CODE_KEY = "http.successResponseCode";
        private static final String RETRIABLE_RESPONSE_CODE_KEY = "http.retriableResponseCode";
        private static final String PROXY_HOST = "http.proxyHost";
        private static final String PROXY_PORT = "http.proxyPort";
        private static final String PROXY_PROTOCOL = "http.proxyProtocol";
        private static final String MAX_CONNECTION_KEY = "apache.client.maxConnection";
        private static final String MAX_CONNECTION_PER_ROUTE_KEY = "apache.client.maxConnectionPerRoute";
        private static final String JWT_ENDPOINT_KEY = "jwt.base.uri";
        private static final String JWT_ENDPOINT_SUFFIX_KEY = "jwt.uri.suffix";
        private static final String JWT_AUDIENCE_SUFFIX_KEY = "jwt.audience.suffix";
        private static final String JWT_CLAIM = "jwt.claim";
        private static final String TEMPORARY_OPERATION_RESULT_DIRECTORY_KEY = "operation.result.tempdirectory";
        private static final String APP_INFO_KEY = "app.info";
        private static final String APP_INFO_PREPEND_REQUEST_ID = "app.info.prepend.request.id";
        private static final String CPF_OPS_CREATE_URI_KEY = "cpf.ops.create.uri";
        private static final String CPF_OPS_EXTRACT_ANALYZER_ID = "cpf.ops.extract.analyzerId";

        private PropertyKeys() {
        }
    }
}

