/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation;

import com.adobe.pdfservices.operation.internal.InternalClientConfig;
import com.adobe.pdfservices.operation.internal.util.JsonUtil;
import com.adobe.pdfservices.operation.internal.util.StringUtil;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ClientConfig {
    private static String CPF_SERVICES_KEY = "cpfServices";
    private static String CPF_SERVICES_OPS_CREATE_KEY = "cpfOpsCreateUri";
    private static String CONNECT_TIMEOUT_KEY = "connectTimeout";
    private static String SOCKET_TIMEOUT_KEY = "socketTimeout";
    private static String PROXY_HOST = "proxyHost";
    private static String PROXY_PORT = "proxyPort";
    private static String PROXY_SCHEME = "proxyScheme";

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Integer connectTimeout;
        private Integer socketTimeout;
        private String cpfOpsCreateUri;
        private String proxyHost;
        private Integer proxyPort;
        private ProxyScheme proxyScheme;

        public Builder withConnectTimeout(Integer connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder withSocketTimeout(Integer socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder withProxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
            return this;
        }

        public Builder withProxyPort(Integer proxyPort) {
            this.proxyPort = proxyPort;
            return this;
        }

        public Builder withProxyScheme(ProxyScheme proxyScheme) {
            this.proxyScheme = proxyScheme;
            return this;
        }

        public Builder fromFile(String clientConfigFilePath) {
            try {
                JsonNode proxySchemeNode;
                JsonNode proxyPortNode;
                JsonNode proxyHostNode;
                JsonNode socketTimeoutNode;
                JsonNode connectTimeoutNode;
                JsonNode cpfServicesOpsCreateUriNode;
                JsonNode clientConfig = JsonUtil.readJsonTreeFromFile(new File(clientConfigFilePath));
                JsonNode cpfServicesConfig = clientConfig.get(CPF_SERVICES_KEY);
                if (cpfServicesConfig != null && (cpfServicesOpsCreateUriNode = cpfServicesConfig.get(CPF_SERVICES_OPS_CREATE_KEY)) != null) {
                    this.cpfOpsCreateUri = cpfServicesOpsCreateUriNode.asText();
                }
                if ((connectTimeoutNode = clientConfig.get(CONNECT_TIMEOUT_KEY)) != null) {
                    if (StringUtil.isPositiveInteger(connectTimeoutNode.asText())) {
                        this.connectTimeout = connectTimeoutNode.asInt();
                    } else {
                        throw new IllegalArgumentException(String.format("Invalid value for connect timeout %s Must be valid integer greater than 0", connectTimeoutNode.asText()));
                    }
                }
                if ((socketTimeoutNode = clientConfig.get(SOCKET_TIMEOUT_KEY)) != null) {
                    if (StringUtil.isPositiveInteger(socketTimeoutNode.asText())) {
                        this.socketTimeout = socketTimeoutNode.asInt();
                    } else {
                        throw new IllegalArgumentException(String.format("Invalid value for socket timeout %s. Must be valid integer greater than 0", socketTimeoutNode.asText()));
                    }
                }
                if ((proxyHostNode = clientConfig.get(PROXY_HOST)) != null && StringUtil.isNotBlank(proxyHostNode.asText())) {
                    this.proxyHost = proxyHostNode.asText();
                }
                if ((proxyPortNode = clientConfig.get(PROXY_PORT)) != null) {
                    if (StringUtil.isPositiveInteger(proxyPortNode.asText())) {
                        this.proxyPort = proxyPortNode.asInt();
                    } else {
                        throw new IllegalArgumentException(String.format("Invalid value for proxy Port %s. Must be valid integer greater than 0", proxyPortNode.asText()));
                    }
                }
                if ((proxySchemeNode = clientConfig.get(PROXY_SCHEME)) != null) {
                    if (StringUtil.isNotBlank(proxySchemeNode.asText()) && null != ProxyScheme.get(proxySchemeNode.asText())) {
                        this.proxyScheme = ProxyScheme.get(proxySchemeNode.asText());
                    } else {
                        throw new IllegalArgumentException(String.format("Invalid value for proxy Scheme %s. Must be either http or https", proxySchemeNode.asText()));
                    }
                }
                return this;
            }
            catch (IOException ioException) {
                throw new IllegalArgumentException("Invalid Client config file provided.");
            }
        }

        public ClientConfig build() {
            return new InternalClientConfig(this.connectTimeout, this.socketTimeout, this.cpfOpsCreateUri, this.proxyHost, this.proxyPort, null != this.proxyScheme ? this.proxyScheme.proxyScheme : null);
        }
    }

    public static enum ProxyScheme {
        HTTP("http"),
        HTTPS("https");

        private final String proxyScheme;
        private static final Map<String, ProxyScheme> lookup;

        private ProxyScheme(String proxyScheme) {
            this.proxyScheme = proxyScheme;
        }

        public static ProxyScheme get(String text) {
            return lookup.get(text.toLowerCase());
        }

        static {
            lookup = new HashMap<String, ProxyScheme>();
            for (ProxyScheme proxyScheme : ProxyScheme.values()) {
                lookup.put(proxyScheme.proxyScheme, proxyScheme);
            }
        }
    }
}

