/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.pdfops.options.rotatepages;

import com.adobe.pdfservices.operation.pdfops.RotatePagesOperation;

/**
 * Supported rotation angle values for {@link RotatePagesOperation}
 */
public enum Angle {

    /**
     * Represents 90 degrees clockwise rotation
     */
    _90(90),
    /**
     * Represents 180 degrees clockwise rotation
     */
    _180(180),
    /**
     * Represents 270 degrees clockwise rotation
     */
    _270(270);

    private final int value;

    /**
     * Constructor.
     *
     * @param value angle value
     */
    Angle(int value) {
        this.value = value;
    }

    /**
     * Returns the value of this angle
     *
     * @return value of this angle
     */
    public int getValue() {
        return value;
    }
}
