/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.pdfops.options.ocr;

import com.adobe.pdfservices.operation.pdfops.OCROperation;

/**
 * Supported OCR types for {@link OCROperation}
 */
public enum OCRSupportedType {

    /**
     * Ensures that text is searchable and selectable. This option keeps the original image, deskews it as needed,
     * and places an invisible text layer over it.
     */
    SEARCHABLE_IMAGE("searchable_image"),
    /**
     * Ensures that text is searchable and selectable. This option keeps the original image and places an invisible
     * text layer over it. Recommended for cases requiring maximum fidelity to the original image.
     */
    SEARCHABLE_IMAGE_EXACT("searchable_image_exact");

    private final String type;

    /**
     * Constructs OCR Type from its string representation
     *
     * @param type String representation
     */
    OCRSupportedType(String type) {
        this.type = type;
    }

    /**
     * Returns the string representation of this OCRSupportedType
     *
     * @return String representation of this OCRSupportedType
     */
    public String getType() {
        return type;
    }
}
