/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.service;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;

import com.adobe.pdfservices.operation.internal.cpf.constants.CPFConstants;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.CPFContentAnalyzerRequests;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.Inputs;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.protect.PasswordProtectParams;
import com.adobe.pdfservices.operation.internal.FileRefImpl;
import com.adobe.pdfservices.operation.internal.InternalExecutionContext;
import com.adobe.pdfservices.operation.internal.api.CPFApi;
import com.adobe.pdfservices.operation.internal.http.DefaultRequestHeaders;
import com.adobe.pdfservices.operation.internal.http.HttpResponse;
import com.adobe.pdfservices.operation.pdfops.options.protectpdf.ProtectPDFOptions;

public class ProtectPDFService {

    private static final String IO_FORMAT_SPECIFIER = "application/pdf";

    public static String protectPDF(InternalExecutionContext context,
                                    FileRefImpl sourceFileRef,
                                    ProtectPDFOptions protectPDFOptions,
                                    String operation) throws FileNotFoundException {
        try {
            // Create PasswordProtectParams
            PasswordProtectParams passwordProtectParams = PasswordProtectParams.createFrom(protectPDFOptions);

            // Build cpf inputs with PasswordProtectParams
            Inputs inputs = Inputs.builder(IO_FORMAT_SPECIFIER)
                    .setParams(passwordProtectParams)
                    .build();

            // Create CPFContentAnalyzerRequests
            CPFContentAnalyzerRequests cpfContentAnalyzerRequests
                    = new CPFContentAnalyzerRequests(CPFConstants.ProtectPDF.PAPI_ENGINE_REPO_ASSET_ID,
                    inputs, IO_FORMAT_SPECIFIER);

            // Prepare the sourceFileRefList
            List<FileRefImpl> sourceFileRefList = new ArrayList<>();
            sourceFileRefList.add(sourceFileRef);

            HttpResponse<String> response = CPFApi.cpfCreateOpsApi(context, cpfContentAnalyzerRequests,
                    sourceFileRefList, String.class, operation);

            return response.getHeaders().get(DefaultRequestHeaders.LOCATION_HEADER_NAME);
        } catch (FileNotFoundException fe) {
            throw fe;
        }
    }
}
