package com.adobe.pdfservices.operation.internal.service.ExtractPDFService;

import com.adobe.pdfservices.operation.exception.SdkException;
import com.adobe.pdfservices.operation.internal.ExtensionMediaTypeMapping;
import com.adobe.pdfservices.operation.internal.cpf.constants.CPFConstants;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.MultiPartFormField;
import com.adobe.pdfservices.operation.internal.cpf.dto.response.platform.ExtractPDF.*;
import com.adobe.pdfservices.operation.internal.util.JsonUtil;
import com.adobe.pdfservices.operation.internal.util.PathUtil;
import com.adobe.pdfservices.operation.internal.util.StringUtil;
import com.adobe.pdfservices.operation.pdfops.options.extractpdf.ExtractRenditionsElementType;

import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import java.io.IOException;
import java.util.List;

public class ExtractDataParser {
    private static ExtractRenditionOutput frameExtractRenditionOutput(ExtractOutputMetaData extractOutputMetaData,
                                                                      StructuredData structuredData,
                                                                      MimeBodyPart bodyPart)
            throws MessagingException, IOException {
        ExtractRenditionOutput renditionOutput = null;
        String fileName = StringUtil.getKeyFromDelimitedString(bodyPart.getHeader(CPFConstants.ExtractPDF.PAPI_MULTIPART_OUTPUT_CONTENT_DISPOSITION_HEADER_KEY,
                ";"), CPFConstants.ExtractPDF.PAPI_MULTIPART_OUTPUT_CONTENT_DISPOSITION_CONTENT_NAME_DELIMINATOR, ";");
        if (extractOutputMetaData.getIndexedMetaInfo() != null && StringUtil.isNotBlank(fileName) &&
                structuredData!=null) {
            renditionOutput = new ExtractRenditionOutput();
            renditionOutput.setFileName(fileName);
            MultiPartFormField multiPartFormField = extractOutputMetaData.getIndexedMetaInfo().get(fileName);
            String fileFormat = multiPartFormField.getFormat();
            String extension = ExtensionMediaTypeMapping.getFromMimeType(fileFormat).getExtension();
            extension = extension != null ? extension : "unknown";
            renditionOutput.setRenditionExtension(extension);
            renditionOutput.setInputStream(bodyPart.getInputStream());
            ExtractRenditionsElementType extractElementType = structuredData.getRenditionElementType(PathUtil.getFileNameWithExtension(fileName, extension));
            renditionOutput.setRenditionsElementType(extractElementType);
        }
        return renditionOutput;
    }

    public static ExtractPDFOutput frameExtractSpecificOutput(List<MimeBodyPart> responseBodyParts)
            throws MessagingException, SdkException, IOException {
        ExtractOutputMetaData extractOutputMetaData = null;
        StructuredData structuredData = null;
        ExtractPDFOutput extractPDFOutput = new ExtractPDFOutput();
        for (MimeBodyPart bodyPart : responseBodyParts) {
            String contentName = StringUtil.getKeyFromDelimitedString(bodyPart.getHeader(CPFConstants.ExtractPDF.PAPI_MULTIPART_OUTPUT_CONTENT_DISPOSITION_HEADER_KEY,
                    ":"), CPFConstants.ExtractPDF.PAPI_MULTIPART_OUTPUT_CONTENT_DISPOSITION_CONTENT_NAME_DELIMINATOR, ";");
            if (bodyPart.isMimeType(ExtensionMediaTypeMapping.JSON.getMediaType()) && StringUtil.isNotBlank(contentName)
                    && contentName.startsWith(CPFConstants.ExtractPDF.PAPI_OUTPUT_CONTENT_ANALYZER_RESPONSE_KEY)) {
                ExtractContentAnalyzerResponse extractContentAnalyzerResponse = JsonUtil.deserializeJsonStream(
                        bodyPart.getInputStream(), ExtractContentAnalyzerResponse.class);
                extractOutputMetaData = extractContentAnalyzerResponse.getExtractOutputMetaData();
                extractPDFOutput.setCpfContentAnalyzerResponse(extractContentAnalyzerResponse);
            } else if (StringUtil.isNotBlank(contentName) && contentName.startsWith(CPFConstants.ExtractPDF.PAPI_OUTPUT_EXTRACTED_JSON_KEY)
                    && extractOutputMetaData != null && extractOutputMetaData.getIndexedMetaInfo().get(
                    contentName).getFormat().equals(ExtensionMediaTypeMapping.JSON.getMediaType())) {

                structuredData = StructuredData.deserializeData(bodyPart.getInputStream(),
                        ExtensionMediaTypeMapping.JSON);
                extractPDFOutput.setStructuredElementData(structuredData);
            }
        }
        for (MimeBodyPart bodyPart: responseBodyParts) {
            String contentName = StringUtil.getKeyFromDelimitedString(bodyPart.getHeader(CPFConstants.ExtractPDF.PAPI_MULTIPART_OUTPUT_CONTENT_DISPOSITION_HEADER_KEY,
                    ":"), CPFConstants.ExtractPDF.PAPI_MULTIPART_OUTPUT_CONTENT_DISPOSITION_CONTENT_NAME_DELIMINATOR, ";");
            if (bodyPart.isMimeType(CPFConstants.ExtractPDF.PAPI_MULTIPART_OUTPUT_OCTET_STREAM_CONTENT_TYPE) && StringUtil.isNotBlank(contentName)
                    && contentName.startsWith(CPFConstants.ExtractPDF.PAPI_OUTPUT_EXTRACTED_RENDITION_KEY)) {
                ExtractRenditionOutput renditionOutput = frameExtractRenditionOutput(extractOutputMetaData,
                        structuredData, bodyPart);
                if (renditionOutput != null) {
                    extractPDFOutput.addExtractedRendition(renditionOutput);
                }
            }
        }
        return  extractPDFOutput;
    }
}
