/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.options;

import com.adobe.pdfservices.operation.internal.FileRefImpl;
import com.adobe.pdfservices.operation.pdfops.options.PageRanges;

public class CombineOperationInput {

    private FileRefImpl sourceFileRef;
    private PageRanges pageRanges;

    private CombineOperationInput(FileRefImpl sourceFileRef, PageRanges pageRanges) {
        this.sourceFileRef = sourceFileRef;
        this.pageRanges = pageRanges;
    }


    public static CombineOperationInput createNew(FileRefImpl sourceFileRef, PageRanges pageRanges) {
        return new CombineOperationInput(sourceFileRef, pageRanges);
    }


    public FileRefImpl getSourceFileRef() {
        return sourceFileRef;
    }

    public PageRanges getPageRanges() {
        return pageRanges;
    }

}
