/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.http;

import java.util.List;

public interface MultiPartRequest extends HttpRequest {

  MultiPartRequest withByteArrayPart(ByteArrayPart byteArrayPart);

  MultiPartRequest withStringBodyPart(StringBodyPart bodyPart);

  MultiPartRequest withInputStreamPart(InputStreamPart inputStream);

  List<ByteArrayPart> getByteArrayParts();

  StringBodyPart getStringBodyPart();

  List<InputStreamPart> getInputStreams();

}
