/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.http;

import com.adobe.pdfservices.operation.internal.InternalClientConfig;

public class HttpRequestConfig {

    private int connectTimeout;
    private int requestTimeout;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyScheme;

    public HttpRequestConfig(InternalClientConfig clientConfig) {
        this.connectTimeout = clientConfig.getConnectTimeout();
        this.requestTimeout = clientConfig.getSocketTimeout();
        this.proxyHost = clientConfig.getProxyHost();
        this.proxyPort = clientConfig.getProxyPort();
        this.proxyScheme = clientConfig.getProxyScheme();
    }

    public int getSocketTimeout() {
        return requestTimeout;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public int getConnectTimeout() {
        return connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public String getProxyHost() {
        return proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyScheme() {
        return proxyScheme;
    }

    public void setProxyScheme(String proxyScheme) {
        this.proxyScheme = proxyScheme;
    }
}
