/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.http;

import com.adobe.pdfservices.operation.internal.http.config.HttpClientConfig;
import com.adobe.pdfservices.operation.internal.GlobalConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientFactory {

    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientFactory.class);
    private static HttpClient httpClient;

    private static void initialiseDcHttpClient(HttpClientConfig httpClientConfig) {
        if (httpClient == null) {
            HttpClientType type = httpClientConfig.getClientType();

            if (type == HttpClientType.APACHE) {
                httpClient = new HttpClientWrapper(httpClientConfig);
            }
        }
    }

    public static HttpClient getDefaultHttpClient() {
        if (httpClient == null) {
            LOGGER.debug("Initializing http client on basis of Client config ");
            HttpClientConfig httpClientConfig = new HttpClientConfig.Builder()
                    .clientType(HttpClientType.APACHE)
                    .withConnectTimeout(GlobalConfig.getConnectTimeout())
                    .withSocketTimeout(GlobalConfig.getSocketTimeout())
                    .build();
            initialiseDcHttpClient(httpClientConfig);
        }
        return httpClient;
    }
}
