/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.cpf.dto.response;

import com.adobe.pdfservices.operation.internal.cpf.dto.response.platform.CPFError;
import com.adobe.pdfservices.operation.internal.cpf.dto.response.platform.CPFStatus;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class CPFErrorResponse {

    private Integer status;
    private String type;
    private String report;
    private String errorCode;
    private String message;
    private String reason;
    private String title;
    private CPFStatus cpfStatus;
    private CPFError cpfError;

    public CPFErrorResponse(@JsonProperty("status") Integer status,
                            @JsonProperty("type") String type,
                            @JsonProperty("report") String report,
                            @JsonProperty("error_code") String errorCode,
                            @JsonProperty("message") String message,
                            @JsonProperty("reason") String reason,
                            @JsonProperty("title") String title,
                            @JsonProperty("cpf:status") CPFStatus cpfStatus,
                            @JsonProperty("error") CPFError cpfError) {
        this.status = status;
        this.type = type != null ? type : (cpfStatus != null ? cpfStatus.getType() : null);
        this.report = report;
        this.message = message;
        this.errorCode = errorCode != null ? errorCode : (cpfError != null ? cpfError.getCpfErrorDetails().getErrorCode() : null);
        this.reason = reason;
        this.title = title;
        this.cpfStatus = cpfStatus;
        this.cpfError = cpfError;
    }

    @Override
    public String toString() {
        return String.format("CPFErrorResponse{status='%d', type='%s', report='%s', message='%s', errorCode='%s', " +
                "reason='%s',}", status, type, report, message, errorCode, reason);
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getReport() {
        return report;
    }

    public void setReport(String report) {
        this.report = report;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public CPFStatus getCPFStatus() {
        return cpfStatus;
    }

    public CPFError getCpfError() {
        return cpfError;
    }
}
