/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.cpf.dto.request.platform;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class CPFContentAnalyzerRequests {

    @JsonProperty("cpf:engine")
    private Engine Engine;

    @JsonProperty("cpf:inputs")
    private Inputs inputs;

    @JsonProperty("cpf:outputs")
    private Outputs outputs;

    public CPFContentAnalyzerRequests(String repoAssetId, Inputs inputs, String outputFormat) {
        this.Engine = new Engine(repoAssetId);
        this.inputs = inputs;
        this.outputs = new Outputs(outputFormat);
    }

    public CPFContentAnalyzerRequests(String repoAssetId, Inputs inputs, Outputs outputs) {
        this.Engine = new Engine(repoAssetId);
        this.inputs = inputs;
        this.outputs = outputs;
    }
}
