/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.cpf.constants;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum RequestKey {

    CREATE("cpf.create"),
    STATUS("cpf.status"),
    AUTHN("ims.session_token");

    private String value;
    private static final Map<String, RequestKey> REQUEST_KEY_MAP;

    static {
        Map<String,RequestKey> map = new HashMap<>();
        for(RequestKey requestKey: RequestKey.values()) {
            map.put(requestKey.getValue(), requestKey);
        }
        REQUEST_KEY_MAP = Collections.unmodifiableMap(map);
    }

    RequestKey(String value) {
        this.value = value;
    }

    public static RequestKey getRequestKeyFromValue(String value) {
        return REQUEST_KEY_MAP.get(value);
    }

    public String getValue() {
        return value;
    }
}
