/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.auth;

import com.adobe.pdfservices.operation.internal.http.HttpRequestConfig;

/**
 * Interface which manages the access token. Will be creating http calls for different authentication
 * mechanisms like ServiceAccount Auth through JWT, or OAUTH, or API key.
 */
public interface Authenticator {

    String SESSION_TOKEN_REQUEST_GROUP_KEY = "ims.session_token";

    SessionToken getSessionToken(HttpRequestConfig requestConfig);

    /**
     * Fetches a new Session Token from IMS and returns the token.
     */
    SessionToken refreshSessionToken(HttpRequestConfig requestConfig);

    String getClientId();
}
