/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation;

import java.io.IOException;

import com.adobe.pdfservices.operation.exception.ServiceApiException;
import com.adobe.pdfservices.operation.exception.ServiceUsageException;

/**
 * This interface represents the basic contract for all the Operations.
 * It imposes no restrictions or particular details on the operation execution process and leaves the
 * specifics of setting up the operations to their individual implementations.
 * <p>
 * A successfully executed {@code Operation} instance should not be reused.
 * </p>
 */
public interface Operation {

    /**
     * Executes this operation synchronously using the provided context instance.
     *
     * @param context a ExecutionContext instance
     * @return an Operation-specific result
     * @throws ServiceApiException   if an API call results in an error response
     * @throws IOException           if there is any I/O error
     * @throws ServiceUsageException if service usage limits have been reached or credentials quota has been exhausted.
     */
    Object execute(ExecutionContext context) throws ServiceApiException, IOException, ServiceUsageException;


}
