/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfg.logging;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorCodeConversion {
    private static final String BUNDLE_NAME = "com.adobe.pdfg.logging.PDGErrorMsgs";
    private static final Logger logger = LoggerFactory.getLogger(ErrorCodeConversion.class);
    private static final Map bundles = new HashMap();
    private static final Locale defaultLocale = Locale.getDefault();
    private static final String defaultLocaleString = defaultLocale.toString();

    public static String getErrorString(int errorCode, String localeName) {
        if (localeName == null) {
            localeName = defaultLocaleString;
        }
        Locale locale = ErrorCodeConversion.toLocale(localeName);
        return ErrorCodeConversion.getErrorString(errorCode, locale);
    }

    public static String getErrorString(int errorCode, Locale locale) {
        String errorString = null;
        try {
            ResourceBundle bundle = ErrorCodeConversion.retrieveBundle(locale);
            if (bundle != null) {
                String key = String.valueOf(errorCode);
                errorString = bundle.getString(key);
            }
        }
        catch (Exception e) {
            logger.trace("Exception in ErrorCodeConversion.getErrorString()" + e.getMessage(), (Throwable)e);
        }
        return errorString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ResourceBundle retrieveBundle(Locale locale) {
        ResourceBundle bundle;
        if (locale == null) {
            locale = defaultLocale;
        }
        if ((bundle = (ResourceBundle)bundles.get(locale)) != null) return bundle;
        Class<ErrorCodeConversion> clazz = ErrorCodeConversion.class;
        synchronized (ErrorCodeConversion.class) {
            bundle = (ResourceBundle)bundles.get(locale);
            if (bundle != null) return bundle;
            try {
                bundle = ResourceBundle.getBundle(BUNDLE_NAME, locale);
            }
            catch (MissingResourceException e) {
                logger.trace(e.getMessage(), (Throwable)e);
                if (locale.equals(defaultLocale)) {
                    logger.warn("The en_US error messages could not be retrieved");
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return null;
                }
                logger.debug("Could not retrieve error messages for locale " + locale);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return ErrorCodeConversion.retrieveBundle(defaultLocale);
            }
            bundles.put(locale, bundle);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return bundle;
        }
    }

    private static Locale toLocale(String localeName) {
        StringTokenizer tokenizer = new StringTokenizer(localeName, "_");
        String[] tokens = new String[3];
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            tokens[index++] = token;
        }
        Locale locale = Locale.US;
        if (tokens[0] != null) {
            locale = tokens[1] != null ? (tokens[2] != null ? new Locale(tokens[0], tokens[1], tokens[2]) : new Locale(tokens[0], tokens[1])) : new Locale(tokens[0]);
        }
        return locale;
    }
}

