/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.icc.render;

import com.adobe.icc.render.IRenderFacade;
import com.adobe.icc.render.IRenderService;
import com.adobe.icc.render.obj.PDFFile;
import com.adobe.icc.render.obj.PDFResponseType;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={IRenderFacade.class})
public class RenderFacade
implements IRenderFacade {
    private static final Logger logger = LoggerFactory.getLogger((String)RenderFacade.class.getName());
    @Reference
    private IRenderService renderService = null;
    private PDFFile errorPdfFile = null;

    protected void activate(ComponentContext context) {
        this.init();
    }

    public void init() {
        this.errorPdfFile = new PDFFile("invalid.pdf", "invalid".getBytes());
    }

    @Override
    public PDFResponseType renderNonInteractivePDF(byte[] xdpTemplate, byte[] xmlData) throws Exception {
        PDFResponseType response = null;
        byte[] baResult = null;
        PDFFile pdfResponse = null;
        try {
            logger.info("RenderFacade: Rendering non-interactive document.");
            baResult = this.renderService.renderPrintPdf(xmlData, xdpTemplate);
            pdfResponse = new PDFFile("render.pdf", baResult);
            response = this.constructResponse(0, pdfResponse);
            logger.info("RenderFacade: Non-interactive document rendered successfully.");
        }
        catch (Exception e) {
            response = this.constructResponse(3, this.errorPdfFile);
            logger.error("RenderFacade: Non-interactive document rendering Failed.", (Throwable)e);
            throw e;
        }
        return response;
    }

    @Override
    public PDFResponseType renderInteractivePDF(byte[] xdpTemplate, byte[] xmlData) throws Exception {
        PDFResponseType response = null;
        try {
            logger.info("RenderFacade: Rendering interactive document.");
            byte[] baPdf = this.renderService.renderPdfForm(xmlData, xdpTemplate);
            PDFFile pdfResponse = new PDFFile("render.pdf", baPdf);
            response = this.constructResponse(0, pdfResponse);
            logger.info("RenderFacade: Interactive document rendered successfully.");
        }
        catch (Exception e) {
            response = this.constructResponse(3, this.errorPdfFile);
            logger.error("RenderFacade: Interactive document rendering Failed.", (Throwable)e);
            throw e;
        }
        return response;
    }

    private PDFResponseType constructResponse(int errorCode, PDFFile file) {
        PDFResponseType oResponse = new PDFResponseType();
        oResponse.setErrorcode(errorCode);
        oResponse.setErrortextFromCode(errorCode);
        oResponse.setFilename(file.getFilename());
        oResponse.setFilelength(file.getFilelength());
        oResponse.setFile(file);
        return oResponse;
    }

    protected void bindRenderService(IRenderService iRenderService) {
        this.renderService = iRenderService;
    }

    protected void unbindRenderService(IRenderService iRenderService) {
        if (this.renderService == iRenderService) {
            this.renderService = null;
        }
    }
}

