/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.forms.common.service;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileAttachmentWrapper
implements Serializable {
    private String uuid;
    private String fileName;
    private String contentType;
    private String bindRef;
    private byte[] bytes;
    private String uri;
    private Logger logger = LoggerFactory.getLogger(FileAttachmentWrapper.class);

    public FileAttachmentWrapper(String fileName, String contentType, byte[] bytes) {
        this(fileName, contentType, bytes, null, null);
    }

    public FileAttachmentWrapper(String fileName, String contentType, byte[] bytes, String dataRef) {
        this(fileName, contentType, bytes, null, dataRef);
    }

    public FileAttachmentWrapper(String fileName, String contentType, byte[] bytes, String uri, String dataRef) {
        this.fileName = fileName;
        this.contentType = contentType;
        this.bytes = bytes;
        this.bindRef = dataRef;
        this.uri = uri;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileNameV2() {
        String fileNameV2 = this.fileName;
        if (StringUtils.contains((CharSequence)fileNameV2, (CharSequence)"/")) {
            fileNameV2 = StringUtils.substringAfterLast((String)fileNameV2, (String)"/");
        }
        return fileNameV2;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getDataRef() {
        return this.bindRef;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setDatRef(String dataRef) {
        this.bindRef = dataRef;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    public byte[] getValue() {
        return this.bytes;
    }

    public String getUri() {
        String data = null;
        if (StringUtils.isNotBlank((CharSequence)this.uri)) {
            data = this.uri;
        } else if (this.bytes != null) {
            data = "data:" + this.contentType + ";base64," + Base64.encodeBase64String((byte[])this.bytes);
        }
        return data;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String toJson() {
        JSONObject fileObj = new JSONObject();
        try {
            fileObj.put("name", (Object)this.getFileNameV2());
            fileObj.put("data", (Object)this.getUri());
            fileObj.put("contentType", (Object)this.getContentType());
            fileObj.put("bindRef", (Object)this.getDataRef());
        }
        catch (JSONException ex) {
            this.logger.error("Error during serialization of file attachment wrapper object", (Throwable)ex);
        }
        return fileObj.toString();
    }
}

