/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.assembler.service;

import com.adobe.internal.pdfm.util.XMLUtil;
import java.util.Dictionary;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, immediate=true, label="AssemblerConfigurationService", description="Service for Assembler Configuration")
@Service(value={AssemblerConfigurationService.class})
public class AssemblerConfigurationService {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Property(intValue={100}, label="Cache Size", description="Maximum number of entries that can be stored in Assembler Cache.")
    private static final String PROPERTY_CACHE_SIZE = "assembler.cacheSize";
    private static final int DEFAULT_CACHE_SIZE = 100;
    private int cacheSize;
    @Property(longValue={1024L}, label="Maximum Object Length(in KB)", description="Maximum size of objects that can be stored in Cache (in KB)")
    private static final String PROPERTY_MAX_OBJECT_LENGTH = "assembler.maxObjectLength";
    private static final long DEFAULT_MAX_OBJECT_LENGTH = 1024L;
    private long maxObjectLength;
    @Property(boolValue={true}, label="Cache Enable", description="Whether Assembler Cache is enabled or not.")
    private static final String PROPERTY_CACHE_ENABLED = "assembler.cacheEnabled";
    private static final boolean DEFAULT_CACHE_ENABLED = true;
    @Property(value={"UTF-8"}, label="XML Encoding", description="XML Encoding to be used for encoding XML output like Document Info, etc. ")
    private static final String PROPERTY_XML_ENCODING = "assembler.xmlEncoding";
    private static final String DEFAULT_XML_ENCODING = "UTF-8";
    private boolean cacheEnabled;

    protected void activate(ComponentContext context) {
        Dictionary props = context.getProperties();
        this.setCacheSize(OsgiUtil.toInteger(props.get(PROPERTY_CACHE_SIZE), (int)100));
        this.setMaxObjectLength(OsgiUtil.toLong(props.get(PROPERTY_MAX_OBJECT_LENGTH), (long)1024L));
        this.setCacheEnabled(OsgiUtil.toBoolean(props.get(PROPERTY_CACHE_ENABLED), (boolean)true));
        XMLUtil.setXmlEncoding((String)OsgiUtil.toString(props.get(PROPERTY_XML_ENCODING), (String)DEFAULT_XML_ENCODING));
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public long getMaxObjectLength() {
        return this.maxObjectLength;
    }

    public void setMaxObjectLength(long maxObjectLength) {
        this.maxObjectLength = maxObjectLength;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }
}

