/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.dermis.model;

import com.adobe.aem.dermis.model.IDataModel;
import com.adobe.aem.dermis.model.IProperty;
import java.util.List;

public class Relationship {
    private List<IProperty> primaryProperties;
    private List<IProperty> foreignProperties;

    public Relationship(List<IProperty> primaryProperties, List<IProperty> foreignProperties) {
        this.primaryProperties = primaryProperties;
        this.foreignProperties = foreignProperties;
    }

    public IDataModel getPrimaryDataModel() {
        IDataModel dataModel = null;
        if (this.primaryProperties != null && this.primaryProperties.size() > 0) {
            dataModel = this.primaryProperties.get(0).getDataModel();
        }
        return dataModel;
    }

    public List<IProperty> getPrimaryProperties() {
        return this.primaryProperties;
    }

    public IDataModel getForeignDataModel() {
        IDataModel dataModel = null;
        if (this.foreignProperties != null && this.foreignProperties.size() > 0) {
            dataModel = this.foreignProperties.get(0).getDataModel();
        }
        return dataModel;
    }

    public List<IProperty> getForeignProperties() {
        return this.foreignProperties;
    }

    public boolean containsPropertyPair(IProperty pkProperty, IProperty fkProperty) {
        boolean result = false;
        if (this.primaryProperties != null && this.foreignProperties != null) {
            for (int index = 0; index < this.primaryProperties.size(); ++index) {
                if (!pkProperty.equals(this.primaryProperties.get(index)) || !fkProperty.equals(this.foreignProperties.get(index))) continue;
                result = true;
            }
        }
        return result;
    }
}

