/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.project.model;

import com.adobe.aem.project.EnvironmentType;
import com.adobe.aem.project.SDKType;
import com.adobe.aem.project.ServiceType;
import com.adobe.aem.project.model.ConfigurationFileType;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.felix.cm.file.ConfigurationHandler;
import org.apache.felix.cm.json.io.Configurations;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.vault.util.DocViewProperty;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class ConfigurationFile
implements Serializable {
    private ServiceType serviceType;
    private EnvironmentType envType;
    private SDKType sdkType;
    private String runMode;
    private int level = -1;
    private Dictionary<String, Object> properties;
    private final File source;
    private final ConfigurationFileType type;
    private final Location location;

    public ConfigurationFile(Location l, File source) {
        this(l, source, ConfigurationFileType.fromFileName(source.getName()));
    }

    public ConfigurationFile(Location l, File source, ConfigurationFileType type) {
        this.location = l;
        this.source = source;
        this.type = type;
    }

    public Location getLocation() {
        return this.location;
    }

    public File getSource() {
        return this.source;
    }

    public ConfigurationFileType getType() {
        return this.type;
    }

    public String getRunMode() {
        return this.runMode;
    }

    public void setRunMode(String runMode) {
        this.runMode = runMode;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getPid() {
        String id;
        int pos = this.source.getName().lastIndexOf(".");
        if (this.type == ConfigurationFileType.JSON && this.source.getName().endsWith(".cfg.json")) {
            pos -= 4;
        }
        if ((pos = (id = this.source.getName().substring(0, pos)).indexOf(45)) != -1) {
            return id.substring(0, pos).concat("~").concat(id.substring(pos + 1));
        }
        return id;
    }

    public void resetConfiguration() {
        this.properties = null;
    }

    public Dictionary<String, Object> getConfiguration() {
        return this.properties;
    }

    public Dictionary<String, Object> readConfiguration() throws IOException {
        if (this.properties == null) {
            this.properties = this.internalReadConfiguration();
        }
        return this.properties;
    }

    private Dictionary<String, Object> internalReadConfiguration() throws IOException {
        try (FileInputStream input = new FileInputStream(this.getSource());){
            if (this.getType() == ConfigurationFileType.CONFIGADMIN) {
                Dictionary dictionary = ConfigurationHandler.read((InputStream)input);
                return dictionary;
            }
            if (this.getType() == ConfigurationFileType.JSON) {
                Hashtable hashtable = Configurations.buildReader().withIdentifier(this.getSource().getAbsolutePath()).build((Reader)new InputStreamReader((InputStream)input, StandardCharsets.UTF_8)).readConfiguration();
                return hashtable;
            }
            if (this.getType() == ConfigurationFileType.PROPERTIES) {
                Properties properties = new Properties();
                try (BufferedInputStream in = new BufferedInputStream(input);){
                    in.mark(1);
                    boolean isXml = 60 == in.read();
                    in.reset();
                    if (isXml) {
                        properties.loadFromXML(in);
                    } else {
                        properties.load(in);
                    }
                }
                Hashtable<String, Object> configuration = new Hashtable<String, Object>();
                Enumeration<Object> i = properties.keys();
                while (i.hasMoreElements()) {
                    Object key = i.nextElement();
                    ((Dictionary)configuration).put(key.toString(), properties.get(key));
                }
                Hashtable<String, Object> hashtable = configuration;
                return hashtable;
            }
            if (this.getType() == ConfigurationFileType.XML) {
                Dictionary<String, Object> dictionary = new JcrConfigurationParser().parse(input);
                return dictionary;
            }
        }
        throw new IOException("Unknown format for configuration file " + this.getSource());
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(ServiceType serviceType) {
        this.serviceType = serviceType;
    }

    public EnvironmentType getEnvType() {
        return this.envType;
    }

    public void setEnvType(EnvironmentType envType) {
        this.envType = envType;
    }

    public SDKType getSdkType() {
        return this.sdkType;
    }

    public void setSdkType(SDKType sdkType) {
        this.sdkType = sdkType;
    }

    private static final class JcrConfigurationParser
    extends DefaultHandler {
        private static final String SLING_OSGICONFIG = "sling:OsgiConfig";
        private static final String JCR_ROOT = "jcr:root";
        private static final SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        private Dictionary<String, Object> configuration;

        private JcrConfigurationParser() {
        }

        public Dictionary<String, Object> parse(InputStream input) throws IOException {
            try {
                SAXParser saxParser = saxParserFactory.newSAXParser();
                saxParser.parse(input, (DefaultHandler)this);
                return this.configuration;
            }
            catch (ParserConfigurationException | SAXException e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String primaryType;
            if (JCR_ROOT.equals(qName) && SLING_OSGICONFIG.equals(primaryType = attributes.getValue("jcr:primaryType"))) {
                this.parseOSGiConfiguration(uri, localName, qName, attributes);
            }
        }

        private void parseOSGiConfiguration(String uri, String localName, String qName, Attributes attributes) {
            this.configuration = Configurations.newConfiguration();
            for (int i = 0; i < attributes.getLength(); ++i) {
                DocViewProperty property;
                Object[] values;
                String attributeValue;
                String attributeQName = attributes.getQName(i);
                if (attributeQName.indexOf(58) != -1 || (attributeValue = attributes.getValue(i)) == null || attributeValue.isEmpty() || (values = this.getValues(property = DocViewProperty.parse((String)attributeQName, (String)attributeValue))).length == 0) continue;
                if (!property.isMulti) {
                    this.configuration.put(attributeQName, values[0]);
                    continue;
                }
                this.configuration.put(attributeQName, values);
            }
        }

        private Object[] getValues(DocViewProperty property) {
            Object[] values;
            switch (property.type) {
                case 5: {
                    values = JcrConfigurationParser.mapValues(property.values, s -> {
                        Calendar cal = ISO8601.parse((String)s);
                        return cal != null ? Long.valueOf(cal.getTimeInMillis()) : null;
                    });
                    break;
                }
                case 4: {
                    values = JcrConfigurationParser.mapValues(property.values, Double::parseDouble);
                    break;
                }
                case 3: {
                    values = JcrConfigurationParser.mapValues(property.values, Long::parseLong);
                    break;
                }
                case 6: {
                    values = JcrConfigurationParser.mapValues(property.values, Boolean::valueOf);
                    break;
                }
                default: {
                    values = property.values;
                }
            }
            return values;
        }

        private static Object[] mapValues(String[] strValues, Function<String, Object> function) {
            return Arrays.stream(strValues).filter(s -> s != null && !s.isEmpty()).map(function).filter(Objects::nonNull).toArray();
        }
    }

    public static enum Location {
        APPS,
        LIBS;

    }
}

