/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.project.model;

import com.adobe.aem.analyser.result.AemAnalyserAnnotation;
import com.adobe.aem.analyser.result.AemAnalyserResult;
import com.adobe.aem.project.EnvironmentType;
import com.adobe.aem.project.SDKType;
import com.adobe.aem.project.ServiceType;
import com.adobe.aem.project.model.AbstractModule;
import com.adobe.aem.project.model.ArtifactsFile;
import com.adobe.aem.project.model.ConfigurationFile;
import com.adobe.aem.project.model.ConfigurationFileType;
import com.adobe.aem.project.model.RepoinitFile;
import jakarta.json.stream.JsonParsingException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.sling.feature.Configuration;

public class Application
extends AbstractModule {
    private List<ArtifactsFile> bundlesFiles;
    private List<ArtifactsFile> contentFiles;
    private List<ConfigurationFile> configFiles;

    public Application(File f) {
        super(f);
    }

    private File getSourceFile(String name) {
        File src = new File(this.getDirectory(), "src");
        return new File(src, name);
    }

    public String getRelativePath(File file) {
        return file.getAbsolutePath().substring(this.getDirectory().getAbsolutePath().length() + 1);
    }

    private void getArtifactsFile(List<ArtifactsFile> result, ArtifactsFile.FileType fileType, ServiceType serviceType) {
        String prefix = fileType == ArtifactsFile.FileType.BUNDLES ? "bundles" : "content-packages";
        String filename = serviceType == null ? prefix.concat(".json") : prefix.concat(".").concat(serviceType.asString()).concat(".json");
        File file = this.getSourceFile(filename);
        if (file.exists()) {
            ArtifactsFile f = new ArtifactsFile(fileType, file);
            f.setServiceType(serviceType);
            result.add(f);
        }
    }

    public List<ArtifactsFile> getBundleFiles() {
        if (this.bundlesFiles == null) {
            this.bundlesFiles = new ArrayList<ArtifactsFile>();
            this.getArtifactsFile(this.bundlesFiles, ArtifactsFile.FileType.BUNDLES, null);
            this.getArtifactsFile(this.bundlesFiles, ArtifactsFile.FileType.BUNDLES, ServiceType.AUTHOR);
            this.getArtifactsFile(this.bundlesFiles, ArtifactsFile.FileType.BUNDLES, ServiceType.PUBLISH);
        }
        return this.bundlesFiles;
    }

    public List<ArtifactsFile> getContentPackageFiles() {
        if (this.contentFiles == null) {
            this.contentFiles = new ArrayList<ArtifactsFile>();
            this.getArtifactsFile(this.contentFiles, ArtifactsFile.FileType.CONTENT_PACKAGES, null);
            this.getArtifactsFile(this.contentFiles, ArtifactsFile.FileType.CONTENT_PACKAGES, ServiceType.AUTHOR);
            this.getArtifactsFile(this.contentFiles, ArtifactsFile.FileType.CONTENT_PACKAGES, ServiceType.PUBLISH);
        }
        return this.contentFiles;
    }

    private File getConfigurationDirectory(ServiceType type, SDKType sdkType, EnvironmentType envType) {
        if (sdkType != null && envType != null) {
            return null;
        }
        String filename = type == null && sdkType == null && envType == null ? "configs" : (type == null && envType == null ? "configs.".concat(sdkType.asString()) : (type == null && sdkType == null ? "configs.".concat(envType.asString()) : (sdkType == null && envType == null ? "configs.".concat(type.asString()) : (sdkType != null ? "configs.".concat(type.asString()).concat(".").concat(sdkType.asString()) : "configs.".concat(type.asString()).concat(".").concat(envType.asString())))));
        File f = this.getSourceFile(filename);
        return f.exists() ? f : null;
    }

    private void getConfigurationFiles(List<ConfigurationFile> files, ServiceType serviceType, SDKType sdkType, EnvironmentType envType) {
        File directory = this.getConfigurationDirectory(serviceType, sdkType, envType);
        if (directory != null && directory.isDirectory()) {
            for (File f : directory.listFiles()) {
                ConfigurationFileType fileType;
                if (f.getName().startsWith(".") || (fileType = ConfigurationFileType.fromFileName(f.getName())) == null) continue;
                ConfigurationFile cfg = new ConfigurationFile(ConfigurationFile.Location.APPS, f, fileType);
                cfg.setServiceType(serviceType);
                cfg.setSdkType(sdkType);
                cfg.setEnvType(envType);
                files.add(cfg);
            }
        }
    }

    public List<ConfigurationFile> getConfigurationFiles() {
        if (this.configFiles == null) {
            this.configFiles = new ArrayList<ConfigurationFile>();
            this.getConfigurationFiles(this.configFiles, null, null, null);
            this.getConfigurationFiles(this.configFiles, null, SDKType.RDE, null);
            this.getConfigurationFiles(this.configFiles, null, null, EnvironmentType.DEV);
            this.getConfigurationFiles(this.configFiles, null, null, EnvironmentType.STAGE);
            this.getConfigurationFiles(this.configFiles, null, null, EnvironmentType.PROD);
            this.getConfigurationFiles(this.configFiles, ServiceType.AUTHOR, null, null);
            this.getConfigurationFiles(this.configFiles, ServiceType.AUTHOR, null, EnvironmentType.DEV);
            this.getConfigurationFiles(this.configFiles, ServiceType.AUTHOR, null, EnvironmentType.STAGE);
            this.getConfigurationFiles(this.configFiles, ServiceType.AUTHOR, null, EnvironmentType.PROD);
            this.getConfigurationFiles(this.configFiles, ServiceType.AUTHOR, SDKType.RDE, null);
            this.getConfigurationFiles(this.configFiles, ServiceType.PUBLISH, null, null);
            this.getConfigurationFiles(this.configFiles, ServiceType.PUBLISH, null, EnvironmentType.DEV);
            this.getConfigurationFiles(this.configFiles, ServiceType.PUBLISH, null, EnvironmentType.STAGE);
            this.getConfigurationFiles(this.configFiles, ServiceType.PUBLISH, null, EnvironmentType.PROD);
            this.getConfigurationFiles(this.configFiles, ServiceType.PUBLISH, SDKType.RDE, null);
        }
        return this.configFiles;
    }

    public AemAnalyserResult verify(List<ConfigurationFile> configs, List<RepoinitFile> repoinit, List<ArtifactsFile> bundles, List<ArtifactsFile> contentPackages) {
        AemAnalyserResult result = new AemAnalyserResult();
        for (ConfigurationFile configurationFile : configs) {
            try {
                Configuration c;
                if (configurationFile.getType() != ConfigurationFileType.JSON) {
                    result.getWarnings().add(new AemAnalyserAnnotation(configurationFile.getSource(), "Configurations should use the JSON format"));
                }
                if ("org.apache.sling.jcr.repoinit.RepositoryInitializer".equals((c = new Configuration(configurationFile.getPid())).getFactoryPid()) && !c.isFactoryConfiguration() && "org.apache.sling.jcr.repoinit.impl.RepositoryInitializer".equals(c.getPid())) {
                    result.getErrors().add(new AemAnalyserAnnotation(configurationFile.getSource(), "Repoinit must be put inside separate txt files"));
                }
                configurationFile.readConfiguration();
            }
            catch (IOException ioe) {
                result.getErrors().add(this.getAnnotation(configurationFile.getSource(), ioe));
            }
        }
        for (RepoinitFile repoinitFile : repoinit) {
            try {
                repoinitFile.readContents();
            }
            catch (IOException ioe) {
                result.getErrors().add(new AemAnalyserAnnotation(repoinitFile.getSource(), ioe.getMessage()));
            }
        }
        for (ArtifactsFile artifactsFile : bundles) {
            try {
                artifactsFile.readArtifacts();
            }
            catch (IOException ioe) {
                result.getErrors().add(this.getAnnotation(artifactsFile.getSource(), ioe));
            }
        }
        for (ArtifactsFile artifactsFile : contentPackages) {
            try {
                artifactsFile.readArtifacts();
            }
            catch (IOException ioe) {
                result.getErrors().add(this.getAnnotation(artifactsFile.getSource(), ioe));
            }
        }
        return result;
    }

    private AemAnalyserAnnotation getAnnotation(File f, IOException ioe) {
        if (ioe.getCause() != null && ioe.getCause() instanceof JsonParsingException) {
            JsonParsingException jpe = (JsonParsingException)ioe.getCause();
            return new AemAnalyserAnnotation(f, jpe.getMessage(), jpe.getLocation() != null ? jpe.getLocation().getLineNumber() : -1L, jpe.getLocation() != null ? jpe.getLocation().getColumnNumber() : -1L);
        }
        return new AemAnalyserAnnotation(f, ioe.getMessage());
    }

    public List<RepoinitFile> getRepoInitFiles() {
        ArrayList<RepoinitFile> result = new ArrayList<RepoinitFile>();
        this.getRepoInitFile(result, null);
        this.getRepoInitFile(result, ServiceType.AUTHOR);
        this.getRepoInitFile(result, ServiceType.PUBLISH);
        return result;
    }

    private void getRepoInitFile(List<RepoinitFile> result, ServiceType serviceType) {
        String filename = serviceType == null ? "repoinit.txt" : (serviceType == ServiceType.AUTHOR ? "repoinit.author.txt" : "repoinit.publish.txt");
        File file = this.getSourceFile(filename);
        if (file.exists()) {
            RepoinitFile r = new RepoinitFile(file);
            r.setServiceType(serviceType);
            result.add(r);
        }
    }
}

