/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.project;

import com.adobe.aem.project.EnvironmentType;
import com.adobe.aem.project.SDKType;
import com.adobe.aem.project.ServiceType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RunModes {
    static final Map<String, String> INVALID_MODES;
    public static final Set<String> GLOBAL_RUN_MODES;
    public static final Set<String> AUTHOR_ONLY_MODES;
    public static final Set<String> PUBLISH_ONLY_MODES;
    public static final Set<String> AUTHOR_RUN_MODES;
    public static final Set<String> PUBLISH_RUN_MODES;
    public static final Set<String> ALL_RUN_MODES;
    public static final Set<String> SDK_ONLY_MODES;

    public static boolean isRunModeAllowed(String runMode) {
        if (runMode != null) {
            return ALL_RUN_MODES.contains(runMode);
        }
        return true;
    }

    public static String checkIfRunModeIsSpecifiedInWrongOrder(String runMode) {
        return INVALID_MODES.get(runMode);
    }

    public static boolean matchesRunMode(ServiceType serviceType, String runMode) {
        Objects.requireNonNull(serviceType);
        if (serviceType == ServiceType.AUTHOR) {
            return runMode == null || AUTHOR_RUN_MODES.contains(runMode);
        }
        return runMode == null || PUBLISH_RUN_MODES.contains(runMode);
    }

    public static boolean matchesRunModeIncludingSDK(ServiceType serviceType, String runMode) {
        if (RunModes.matchesRunMode(serviceType, runMode)) {
            return true;
        }
        return SDK_ONLY_MODES.contains(runMode);
    }

    public static boolean isRunModeAllowedIncludingSDK(String runMode) {
        boolean result = RunModes.isRunModeAllowed(runMode);
        if (!result) {
            result = SDK_ONLY_MODES.contains(runMode);
        }
        return result;
    }

    static {
        HashSet<String> sdk = new HashSet<String>();
        HashMap<String, String> invalid = new HashMap<String, String>();
        for (ServiceType service : ServiceType.values()) {
            for (EnvironmentType environmentType : EnvironmentType.values()) {
                invalid.put(environmentType.asString().concat(".").concat(service.asString()), service.asString().concat(".").concat(environmentType.asString()));
            }
            for (Enum enum_ : SDKType.values()) {
                invalid.put(((SDKType)enum_).asString().concat(".").concat(service.asString()), service.asString().concat(".").concat(((SDKType)enum_).asString()));
                sdk.add(service.asString().concat(".").concat(((SDKType)enum_).asString()));
                sdk.add(((SDKType)enum_).asString());
            }
        }
        SDK_ONLY_MODES = Collections.unmodifiableSet(sdk);
        INVALID_MODES = Collections.unmodifiableMap(invalid);
        GLOBAL_RUN_MODES = Arrays.stream(EnvironmentType.values()).map(e -> e.asString()).collect(Collectors.toSet());
        HashSet<String> authors = new HashSet<String>();
        HashSet<String> publish = new HashSet<String>();
        authors.add(ServiceType.AUTHOR.asString());
        publish.add(ServiceType.PUBLISH.asString());
        for (String mode : GLOBAL_RUN_MODES) {
            authors.add(ServiceType.AUTHOR.asString().concat(".").concat(mode));
            publish.add(ServiceType.PUBLISH.asString().concat(".").concat(mode));
        }
        AUTHOR_ONLY_MODES = Collections.unmodifiableSet(authors);
        PUBLISH_ONLY_MODES = Collections.unmodifiableSet(publish);
        AUTHOR_RUN_MODES = Stream.concat(GLOBAL_RUN_MODES.stream(), AUTHOR_ONLY_MODES.stream()).collect(Collectors.toSet());
        PUBLISH_RUN_MODES = Stream.concat(GLOBAL_RUN_MODES.stream(), PUBLISH_ONLY_MODES.stream()).collect(Collectors.toSet());
        ALL_RUN_MODES = Stream.concat(AUTHOR_RUN_MODES.stream(), PUBLISH_RUN_MODES.stream()).collect(Collectors.toSet());
    }
}

