/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.analyser.tasks;

import com.adobe.aem.analyser.AemSdkProductFeatureGenerator;
import com.adobe.aem.analyser.ProductVariation;
import com.adobe.aem.project.ServiceType;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.BuilderContext;
import org.apache.sling.feature.builder.FeatureBuilder;
import org.apache.sling.feature.builder.FeatureProvider;

public class TaskContext {
    private final FeatureProvider provider;
    private final ArtifactId sdkId;
    private final List<ArtifactId> addons;
    private final File projectDirectory;
    private final ArtifactId projectId;
    private Map<ServiceType, Feature> productFeatures;

    public TaskContext(File projectDirectory, ArtifactId projectId, ArtifactId sdkId, List<ArtifactId> addons, FeatureProvider provider) {
        Objects.requireNonNull(projectDirectory);
        Objects.requireNonNull(projectId);
        Objects.requireNonNull(sdkId);
        Objects.requireNonNull(addons);
        Objects.requireNonNull(provider);
        this.projectDirectory = projectDirectory;
        this.provider = provider;
        this.sdkId = sdkId;
        this.addons = addons;
        this.projectId = projectId;
    }

    public ArtifactId getProjectId() {
        return this.projectId;
    }

    public void checkProjectFile(File file) throws IOException {
        if (!file.getAbsolutePath().startsWith(this.projectDirectory.getAbsolutePath().concat(File.separator))) {
            throw new IOException("File is outside of project directory " + file);
        }
    }

    public String getRelativePath(File file) throws IOException {
        this.checkProjectFile(file);
        return file.getAbsolutePath().substring(this.projectDirectory.getAbsolutePath().length() + 1);
    }

    public Map<ServiceType, Feature> getProductFeatures() throws IOException {
        if (this.productFeatures == null) {
            this.productFeatures = this.loadProductFeatures();
        }
        return this.productFeatures;
    }

    private Map<ServiceType, Feature> loadProductFeatures() throws IOException {
        HashMap<ServiceType, Feature> result = new HashMap<ServiceType, Feature>();
        AemSdkProductFeatureGenerator generator = new AemSdkProductFeatureGenerator(this.provider, this.sdkId, this.addons);
        BuilderContext context = new BuilderContext(this.provider);
        for (ServiceType serviceType : ServiceType.values()) {
            Map<ProductVariation, List<Feature>> featuresMap = generator.getProductAggregates(EnumSet.of(serviceType));
            if (featuresMap.size() != 1) {
                throw new IOException("Unable to resolve product feature for servive " + serviceType);
            }
            List<Feature> features = featuresMap.values().iterator().next();
            Feature finalFeature = FeatureBuilder.assemble((ArtifactId)this.sdkId.changeClassifier(serviceType.name()), (BuilderContext)context, (Feature[])features.toArray(new Feature[features.size()]));
            result.put(serviceType, finalFeature);
        }
        return result;
    }
}

