/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.analyser.impl;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.bytecode.ClassFile;
import org.apache.felix.cm.json.io.Configurations;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.scanner.BundleDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderTypeAnalyserTask
implements AnalyserTask {
    private static final String CFG_STRICT = "strict";
    private static final String PROVIDER_TYPES_FILE = "META-INF/api-info.json";
    private static final String PROVIDER_TYPES_KEY = "providerTypes";
    private static final Logger LOGGER = LoggerFactory.getLogger(ProviderTypeAnalyserTask.class);
    private static final List<String> PROVIDER_TYPES = new ArrayList<String>();
    private static final Map<String, String> CHECKED_CLASSES = new HashMap<String, String>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean initializeProviderTypeInfo(ArtifactId sdkId, File apiFile) {
        try (JarFile jarFile = new JarFile(apiFile);){
            JarEntry entry = jarFile.getJarEntry(PROVIDER_TYPES_FILE);
            if (entry != null) {
                try (InputStream is = jarFile.getInputStream(entry);){
                    JsonObject providerTypeInfo = Json.createReader((InputStream)is).readObject();
                    if (!providerTypeInfo.containsKey((Object)PROVIDER_TYPES_KEY)) return false;
                    for (JsonValue v : providerTypeInfo.getJsonArray(PROVIDER_TYPES_KEY)) {
                        PROVIDER_TYPES.add(Configurations.convertToObject((JsonValue)v).toString());
                    }
                    LOGGER.debug("Found {} provider types in {}", (Object)PROVIDER_TYPES.size(), (Object)sdkId.toMvnId());
                    boolean bl = true;
                    return bl;
                }
            }
            LOGGER.error("API info not found in {}. Please update to a more recent version of the API. ", (Object)sdkId.toMvnId());
            return false;
        }
        catch (IOException ioe) {
            LOGGER.error("Error while reading API info from {}", (Object)sdkId.toMvnId());
        }
        return false;
    }

    public String getId() {
        return "aem-provider-type";
    }

    public String getName() {
        return "AEM Provider Type Analyser";
    }

    public void execute(AnalyserTaskContext context) throws Exception {
        if (PROVIDER_TYPES.isEmpty()) {
            context.reportError("No provider types found.");
            return;
        }
        boolean strict = Boolean.parseBoolean((String)context.getConfiguration().get(CFG_STRICT));
        for (BundleDescriptor bundle : context.getFeatureDescriptor().getBundleDescriptors()) {
            this.analyse(context, bundle, strict);
        }
    }

    private void analyse(AnalyserTaskContext context, BundleDescriptor bundle, boolean strict) {
        try (JarInputStream jis = new JarInputStream(bundle.getArtifactFile().openStream());){
            JarEntry entry = null;
            block7: while ((entry = jis.getNextJarEntry()) != null) {
                String cp;
                if (entry.getName().endsWith(".class") && !entry.getName().startsWith("META-INF/")) {
                    String className = entry.getName().substring(0, entry.getName().length() - 6).replace('/', '.');
                    this.checkClass(context, bundle, className, jis, strict);
                    continue;
                }
                if (!entry.getName().endsWith(".jar") || (cp = bundle.getManifest().getMainAttributes().getValue("Bundle-ClassPath")) == null) continue;
                for (String path : cp.split(",")) {
                    if (!path.trim().equals(entry.getName())) continue;
                    JarInputStream ejis = new JarInputStream(jis);
                    JarEntry inner = null;
                    while ((inner = ejis.getNextJarEntry()) != null) {
                        if (!inner.getName().endsWith(".class") || inner.getName().startsWith("META-INF/")) continue;
                        String className = inner.getName().substring(0, inner.getName().length() - 6).replace('/', '.');
                        this.checkClass(context, bundle, className, ejis, strict);
                    }
                    continue block7;
                }
            }
        }
        catch (IOException e) {
            context.reportError("Error while analysing bundle ".concat(bundle.getArtifact().getId().toMvnId()).concat(" : ").concat(e.getMessage()));
        }
    }

    private void checkClass(AnalyserTaskContext context, BundleDescriptor bundle, String className, InputStream clazzStream, boolean strict) throws IOException, RuntimeException {
        String key = bundle.getArtifact().getId().toMvnId().concat(":").concat(className);
        String known = CHECKED_CLASSES.get(key);
        if (known != null) {
            this.reportProviderTypeUsage(context, bundle, className, known, strict);
            return;
        }
        CtClass cc = ClassPool.getDefault().makeClass(clazzStream);
        cc.setName(className);
        ClassFile cfile = cc.getClassFile();
        String result = "";
        for (String name : cfile.getInterfaces()) {
            result = this.checkClassForProviderType(result, name);
        }
        result = this.checkClassForProviderType(result, cfile.getSuperclass());
        this.reportProviderTypeUsage(context, bundle, className, result, strict);
        CHECKED_CLASSES.put(key, result);
    }

    private void reportProviderTypeUsage(AnalyserTaskContext context, BundleDescriptor bundle, String className, String providerType, boolean strict) {
        if (!providerType.isEmpty()) {
            String msg = "Class ".concat(className).concat(" implements or extends an AEM provider type : ").concat(providerType);
            if (strict) {
                context.reportArtifactError(bundle.getArtifact().getId(), msg);
            } else {
                context.reportArtifactWarning(bundle.getArtifact().getId(), msg);
            }
        }
    }

    private String checkClassForProviderType(String result, String name) {
        if (PROVIDER_TYPES.contains(name)) {
            if (!result.isEmpty()) {
                return result.concat(", ");
            }
            return result.concat(name);
        }
        return result;
    }
}

