/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.analyser.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.scanner.BundleDescriptor;
import org.apache.sling.feature.scanner.PackageInfo;

public class ProductPackageImportTask
implements AnalyserTask {
    public String getName() {
        return "Product Package Import";
    }

    public String getId() {
        return "product-package-import";
    }

    private List<BundleDescriptor> getExportingBundles(AnalyserTaskContext ctx) {
        ArrayList<BundleDescriptor> exportingBundles = new ArrayList<BundleDescriptor>();
        if (ctx.getFrameworkDescriptor() != null) {
            exportingBundles.add(ctx.getFrameworkDescriptor());
        }
        for (BundleDescriptor bd : ctx.getFeatureDescriptor().getBundleDescriptors()) {
            if (bd.getExportedPackages().isEmpty()) continue;
            exportingBundles.add(bd);
        }
        return exportingBundles;
    }

    public void execute(AnalyserTaskContext ctx) throws IOException {
        List<BundleDescriptor> exportingBundles = this.getExportingBundles(ctx);
        TreeSet<String> missingExports = new TreeSet<String>();
        for (BundleDescriptor info : ctx.getFeatureDescriptor().getBundleDescriptors()) {
            for (PackageInfo pck : info.getImportedPackages()) {
                List<BundleDescriptor> list = this.getCandidates(exportingBundles, pck);
                if (!list.isEmpty()) continue;
                missingExports.add(pck.getName());
            }
        }
        if (!missingExports.isEmpty()) {
            int batchSize = 50;
            ArrayList batches = new ArrayList();
            TreeSet<String> currentBatch = null;
            for (String string : missingExports) {
                if (currentBatch == null) {
                    currentBatch = new TreeSet<String>();
                    batches.add(currentBatch);
                }
                currentBatch.add(string);
                if (currentBatch.size() < 50) continue;
                currentBatch = null;
            }
            for (Set set : batches) {
                ctx.reportWarning("The following packages are imported from the product: " + set);
            }
        }
    }

    private List<BundleDescriptor> getCandidates(List<BundleDescriptor> exportingBundles, PackageInfo pck) {
        ArrayList<BundleDescriptor> candidates = new ArrayList<BundleDescriptor>();
        for (BundleDescriptor info : exportingBundles) {
            if (!info.isExportingPackage(pck)) continue;
            candidates.add(info);
        }
        return candidates;
    }
}

