/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.analyser.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.felix.configadmin.plugin.interpolation.Interpolator;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;

public class EnvVarAnalyserTask
implements AnalyserTask {
    private static final String TYPE_ENV = "env";
    private static final String TYPE_SECRET = "secret";
    private static final List<String> PREFIXES = Arrays.asList("INTERNAL_", "ADOBE_");
    private static final Pattern NAME_PATTERN = Pattern.compile("[a-zA-Z_][a-zA-Z_0-9]*");
    private static final String SECRETS_PATH = "customer-secrets/";

    public String getId() {
        return "aem-env-var";
    }

    public String getName() {
        return "AEM Env Var Analyser";
    }

    public void execute(AnalyserTaskContext context) throws Exception {
        for (Configuration cfg : context.getFeature().getConfigurations()) {
            this.check(context, cfg);
        }
    }

    private void reportErrorOrWarning(EnumSet<Usage> usage, AnalyserTaskContext context, Configuration cfg, String propName, String value) {
        for (Usage u : usage) {
            if (u.isError()) {
                context.reportConfigurationError(cfg, u.getMessageFor(propName, value));
                continue;
            }
            context.reportConfigurationWarning(cfg, u.getMessageFor(propName, value));
        }
    }

    private void check(AnalyserTaskContext context, Configuration cfg) {
        Dictionary properties = cfg.getConfigurationProperties();
        for (String propName : Collections.list(properties.keys())) {
            String[] array;
            Object value = properties.get(propName);
            if (value instanceof String) {
                this.reportErrorOrWarning(this.checkValue(value.toString()), context, cfg, propName, value.toString());
                continue;
            }
            if (!(value instanceof String[])) continue;
            for (String val : array = (String[])value) {
                this.reportErrorOrWarning(this.checkValue(val), context, cfg, propName, val);
            }
        }
    }

    private EnumSet<Usage> checkValue(String value) {
        final EnumSet<Usage> result = EnumSet.noneOf(Usage.class);
        Interpolator.replace((String)value, (Interpolator.Provider)new Interpolator.Provider(){

            public Object provide(String type, String name, Map<String, String> directives) {
                if (EnvVarAnalyserTask.TYPE_ENV.equals(type)) {
                    for (String prefix : PREFIXES) {
                        if (!name.startsWith(prefix)) continue;
                        result.add(Usage.ENV);
                    }
                    if (!NAME_PATTERN.matcher(name).matches()) {
                        result.add(Usage.ENV_PATTERN);
                    }
                    if (name.length() < 2 || name.length() > 100) {
                        result.add(Usage.ENV_SIZE);
                    }
                } else if (EnvVarAnalyserTask.TYPE_SECRET.equals(type)) {
                    String value = name;
                    if (value.startsWith(EnvVarAnalyserTask.SECRETS_PATH)) {
                        value = value.substring(EnvVarAnalyserTask.SECRETS_PATH.length());
                        result.add(Usage.SECRET_PATH);
                    }
                    for (String prefix : PREFIXES) {
                        if (!value.startsWith(prefix)) continue;
                        result.add(Usage.SECRET);
                    }
                    if (!NAME_PATTERN.matcher(value).matches()) {
                        result.add(Usage.SECRET_PATTERN);
                    }
                    if (value.length() < 2 || value.length() > 100) {
                        result.add(Usage.SECRET_SIZE);
                    }
                }
                return "";
            }
        });
        return result;
    }

    private static enum Usage {
        ENV("Value for property '{}' must not use env vars prefixed with INTERNAL_ or ADOBE_ : "),
        ENV_PATTERN("Value for property '{}' uses env var not following the required naming scheme of " + NAME_PATTERN.toString() + " : ", false),
        ENV_SIZE("Value for property '{}' uses env var not following naming length restrictions (>= 2 and <= 100) : "),
        SECRET("Value for property '{}' must not use secrets prefixed with INTERNAL_ or ADOBE_ : "),
        SECRET_PATH("Value for property '{}' must not use prefix customer-secrets/. Please remove the prefix : ", false),
        SECRET_PATTERN("Value for property '{}' uses env var not following the required naming scheme of " + NAME_PATTERN.toString() + " : ", false),
        SECRET_SIZE("Value for property '{}' uses env var not following naming length restrictions (>= 2 and <= 100) : ");

        private final String message;
        private final boolean error;

        private Usage(String msg) {
            this(msg, true);
        }

        private Usage(String msg, boolean error) {
            this.message = msg;
            this.error = error;
        }

        public boolean isError() {
            return this.error;
        }

        public String getMessageFor(String propertyName, String value) {
            return this.message.replace("{}", propertyName).concat(value);
        }
    }
}

