/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.analyser;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.ConverterException;
import org.apache.sling.feature.cpconverter.accesscontrol.AclManager;
import org.apache.sling.feature.cpconverter.accesscontrol.DefaultAclManager;
import org.apache.sling.feature.cpconverter.artifacts.ArtifactWriter;
import org.apache.sling.feature.cpconverter.artifacts.ArtifactsDeployer;
import org.apache.sling.feature.cpconverter.artifacts.LocalMavenRepositoryArtifactsDeployer;
import org.apache.sling.feature.cpconverter.features.DefaultFeaturesManager;
import org.apache.sling.feature.cpconverter.features.FeaturesManager;
import org.apache.sling.feature.cpconverter.filtering.RegexBasedResourceFilter;
import org.apache.sling.feature.cpconverter.filtering.ResourceFilter;
import org.apache.sling.feature.cpconverter.handlers.DefaultEntryHandlersManager;
import org.apache.sling.feature.cpconverter.handlers.EntryHandlersManager;
import org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.BundleSlingInitialContentExtractor;
import org.apache.sling.feature.cpconverter.index.DefaultIndexManager;
import org.apache.sling.feature.cpconverter.index.IndexManager;
import org.apache.sling.feature.cpconverter.vltpkg.DefaultPackagesEventsEmitter;
import org.apache.sling.feature.cpconverter.vltpkg.PackagesEventsEmitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AemPackageConverter {
    private static final Map<String, String> DEFAULT_NAMESPACE_MAPPINGS = Map.of("cq", "http://www.day.com/jcr/cq/1.0", "granite", "http://www.adobe.com/jcr/granite/1.0");
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String FILTER = ".*/(apps|libs)/(.*)/install\\.(((author|publish)\\.(dev|stage|prod))|((dev|stage|prod)\\.(author|publish))|(dev|stage|prod))/(.*)(?<=\\.(zip|jar)$)";
    private File featureOutputDirectory;
    private File bundlesOutputDirectory;
    private File mutableContentOutputDirectory;
    private File converterOutputDirectory;
    private String artifactIdOverride;
    private final List<String> apiRegions = Arrays.asList("com.adobe.aem.deprecated");

    public File getFeatureOutputDirectory() {
        return this.featureOutputDirectory;
    }

    public void setFeatureOutputDirectory(File featureOutputDirectory) {
        this.featureOutputDirectory = featureOutputDirectory;
    }

    public void setMutableContentOutputDirectory(File mutableContentOutputDirectory) {
        this.mutableContentOutputDirectory = mutableContentOutputDirectory;
    }

    public void addToApiRegions(Collection<String> apiRegions) {
        this.apiRegions.addAll(apiRegions);
    }

    public File getBundlesOutputDirectory() {
        return this.bundlesOutputDirectory;
    }

    public void setBundlesOutputDirectory(File bundlesOutputDirectory) {
        this.bundlesOutputDirectory = bundlesOutputDirectory;
    }

    public File getConverterOutputDirectory() {
        return this.converterOutputDirectory;
    }

    public void setConverterOutputDirectory(File converterOutputDirectory) {
        this.converterOutputDirectory = converterOutputDirectory;
    }

    public String getArtifactIdOverride() {
        return this.artifactIdOverride;
    }

    public void setArtifactIdOverride(String artifactIdOverride) {
        this.artifactIdOverride = artifactIdOverride;
    }

    public void convert(Map<String, File> contentPackages) throws IOException, ConverterException {
        HashMap properties = new HashMap();
        if (contentPackages.size() > 1 && this.artifactIdOverride != null) {
            throw new IllegalArgumentException("'artifactIdOverride' is not supported when multiple packages are provided!");
        }
        DefaultAclManager aclManager = new DefaultAclManager(null, "system", false);
        DefaultFeaturesManager featuresManager = new DefaultFeaturesManager(false, 20, this.featureOutputDirectory, this.artifactIdOverride, null, properties, (AclManager)aclManager);
        featuresManager.setAPIRegions(this.apiRegions);
        featuresManager.setExportToAPIRegion("global");
        featuresManager.getNamespaceUriByPrefix().putAll(DEFAULT_NAMESPACE_MAPPINGS);
        File bundlesOutputDir = this.bundlesOutputDirectory != null ? this.bundlesOutputDirectory : this.converterOutputDirectory;
        File unreferencedArtifactsOutputDirectory = this.mutableContentOutputDirectory != null ? this.mutableContentOutputDirectory : new File(this.converterOutputDirectory, "mutable-content");
        MutableContentPackageDeployer mutableContentPackagesDeployer = new MutableContentPackageDeployer(unreferencedArtifactsOutputDirectory);
        try (ContentPackage2FeatureModelConverter converter = new ContentPackage2FeatureModelConverter(false, ContentPackage2FeatureModelConverter.SlingInitialContentPolicy.EXTRACT_AND_REMOVE, true);){
            BundleSlingInitialContentExtractor bundleSlingInitialContentExtractor = new BundleSlingInitialContentExtractor();
            converter.setFeaturesManager((FeaturesManager)featuresManager).setBundlesDeployer((ArtifactsDeployer)new LocalMavenRepositoryArtifactsDeployer(bundlesOutputDir)).setBundleSlingInitialContentExtractor(bundleSlingInitialContentExtractor).setEntryHandlersManager((EntryHandlersManager)new DefaultEntryHandlersManager(Collections.emptyMap(), true, ContentPackage2FeatureModelConverter.SlingInitialContentPolicy.EXTRACT_AND_REMOVE, bundleSlingInitialContentExtractor, "system")).setAclManager((AclManager)new DefaultAclManager()).setIndexManager((IndexManager)new DefaultIndexManager()).setEmitter((PackagesEventsEmitter)DefaultPackagesEventsEmitter.open((File)this.featureOutputDirectory)).setContentTypePackagePolicy(ContentPackage2FeatureModelConverter.PackagePolicy.PUT_IN_DEDICATED_FOLDER).setUnreferencedArtifactsDeployer((ArtifactsDeployer)mutableContentPackagesDeployer).setIndexManager((IndexManager)new DefaultIndexManager()).setResourceFilter(this.getResourceFilter());
            this.logger.info("Converting packages {}", contentPackages.keySet());
            converter.convert(contentPackages.values().toArray(new File[contentPackages.size()]));
        }
        catch (IOException | ConverterException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException("Content Package Converter exception " + t.getMessage(), t);
        }
        mutableContentPackagesDeployer.logMutableContentPackages();
    }

    private ResourceFilter getResourceFilter() {
        RegexBasedResourceFilter filter = new RegexBasedResourceFilter();
        filter.addFilteringPattern(FILTER);
        return filter;
    }

    class MutableContentPackageDeployer
    extends LocalMavenRepositoryArtifactsDeployer {
        final Map<ArtifactId, String> mutableContentPackagesWithRunMode;

        public MutableContentPackageDeployer(File outputDirectory) {
            super(outputDirectory);
            this.mutableContentPackagesWithRunMode = new HashMap<ArtifactId, String>();
        }

        public String deploy(ArtifactWriter artifactWriter, String runmode, ArtifactId id) throws IOException {
            if (runmode != null) {
                this.mutableContentPackagesWithRunMode.put(id, runmode);
            }
            return super.deploy(artifactWriter, runmode, id);
        }

        public void logMutableContentPackages() {
            for (Map.Entry<ArtifactId, String> entry : this.mutableContentPackagesWithRunMode.entrySet()) {
                AemPackageConverter.this.logger.info("Mutable content package {} uses runmode {}", (Object)entry.getKey().toMvnId(), (Object)entry.getValue());
            }
        }
    }
}

