/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.analyser;

import com.adobe.aem.analyser.AemSdkProductFeatureGenerator;
import com.adobe.aem.analyser.ProductFeatureGenerator;
import com.adobe.aem.analyser.ProductVariation;
import com.adobe.aem.analyser.RunmodeMappingUserFeatureAggregator;
import com.adobe.aem.analyser.UserFeatureAggregator;
import com.adobe.aem.project.ServiceType;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.builder.BuilderContext;
import org.apache.sling.feature.builder.FeatureBuilder;
import org.apache.sling.feature.builder.FeatureProvider;
import org.apache.sling.feature.builder.MergeHandler;
import org.apache.sling.feature.builder.PostProcessHandler;
import org.apache.sling.feature.cpconverter.artifacts.ArtifactWriter;
import org.apache.sling.feature.cpconverter.artifacts.ArtifactsDeployer;
import org.apache.sling.feature.cpconverter.artifacts.FileArtifactWriter;
import org.apache.sling.feature.extension.apiregions.api.artifacts.ArtifactRules;
import org.apache.sling.feature.extension.apiregions.api.artifacts.VersionRule;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurationApi;
import org.apache.sling.feature.io.json.FeatureJSONReader;
import org.apache.sling.feature.io.json.FeatureJSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AemAggregator {
    static final String FEATUREMODEL_TYPE = "slingosgifeature";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private File featureInputDirectory;
    private File featureOutputDirectory;
    private ArtifactProvider artifactProvider;
    private ArtifactsDeployer artifactsDeployer;
    private FeatureProvider featureProvider;
    private UserFeatureAggregator userFeatureAggregator;
    private ProductFeatureGenerator productFeatureGenerator;
    private ArtifactId projectId;
    private ArtifactId sdkId;
    private List<ArtifactId> addOnIds;
    private EnumSet<ServiceType> serviceTypes = EnumSet.allOf(ServiceType.class);
    private boolean enableDuplicateBundleHandling = false;

    public boolean isEnableDuplicateBundleHandling() {
        return this.enableDuplicateBundleHandling;
    }

    public void setEnableDuplicateBundleHandling(boolean enableDuplicateBundleHandling) {
        this.enableDuplicateBundleHandling = enableDuplicateBundleHandling;
    }

    public ArtifactProvider getArtifactProvider() {
        return this.artifactProvider;
    }

    public void setArtifactProvider(ArtifactProvider artifactProvider) {
        this.artifactProvider = artifactProvider;
    }

    public ArtifactsDeployer getArtifactsDeployer() {
        return this.artifactsDeployer;
    }

    public void setArtifactsDeployer(ArtifactsDeployer artifactsDeployer) {
        this.artifactsDeployer = artifactsDeployer;
    }

    public FeatureProvider getFeatureProvider() {
        return this.featureProvider;
    }

    public void setFeatureProvider(FeatureProvider featureProvider) {
        this.featureProvider = featureProvider;
    }

    public UserFeatureAggregator getUserFeatureAggregator() {
        if (this.userFeatureAggregator == null) {
            return new RunmodeMappingUserFeatureAggregator(this.getFeatureInputDirectory());
        }
        return this.userFeatureAggregator;
    }

    public void setUserFeatureAggregator(UserFeatureAggregator userFeatureAggregator) {
        this.userFeatureAggregator = userFeatureAggregator;
    }

    public ProductFeatureGenerator getProductFeatureGenerator() {
        if (this.productFeatureGenerator == null) {
            return new AemSdkProductFeatureGenerator(this.getFeatureProvider(), this.getSdkId(), this.getAddOnIds());
        }
        return this.productFeatureGenerator;
    }

    public void setProductFeatureGenerator(ProductFeatureGenerator productFeatureGenerator) {
        this.productFeatureGenerator = productFeatureGenerator;
    }

    public ArtifactId getProjectId() {
        return this.projectId;
    }

    public void setProjectId(ArtifactId projectId) {
        this.projectId = projectId;
    }

    public File getFeatureInputDirectory() {
        if (this.featureInputDirectory == null) {
            return this.featureOutputDirectory;
        }
        return this.featureInputDirectory;
    }

    public void setFeatureInputDirectory(File featureInputDirectory) {
        this.featureInputDirectory = featureInputDirectory;
    }

    public File getFeatureOutputDirectory() {
        return this.featureOutputDirectory;
    }

    public void setFeatureOutputDirectory(File featureOutputDirectory) {
        this.featureOutputDirectory = featureOutputDirectory;
    }

    public EnumSet<ServiceType> getServiceTypes() {
        return this.serviceTypes;
    }

    public void setServiceTypes(ServiceType ... rm) {
        this.serviceTypes = EnumSet.copyOf(Arrays.asList(rm));
    }

    public ArtifactId getSdkId() {
        return this.sdkId;
    }

    public void setSdkId(ArtifactId sdkId) {
        this.sdkId = sdkId;
    }

    public List<ArtifactId> getAddOnIds() {
        return this.addOnIds;
    }

    public void setAddOnIds(List<ArtifactId> addOnIds) {
        this.addOnIds = addOnIds;
    }

    public List<Feature> aggregate() throws IOException {
        ArtifactRules r;
        ConfigurationApi configApi;
        Map<String, Feature> projectFeatures = this.readFeatures();
        Map<String, List<Feature>> userAggregates = this.getUserAggregates(projectFeatures);
        List<Feature> userResult = this.aggregate(userAggregates, Mode.USER, projectFeatures);
        Map<ProductVariation, List<Feature>> productAggregates = this.getProductAggregates();
        this.aggregateFeatureInfo(productAggregates, Mode.PRODUCT, projectFeatures);
        Map<String, List<Feature>> finalAggregates = this.getFinalAggregates(userAggregates, projectFeatures);
        List<Feature> finalResult = this.aggregate(finalAggregates, Mode.FINAL, projectFeatures);
        HashMap<ProductVariation, ConfigurationApi> apiMapping = new HashMap<ProductVariation, ConfigurationApi>();
        HashMap<ProductVariation, ArtifactRules> rules = new HashMap<ProductVariation, ArtifactRules>();
        for (ProductVariation variation : productAggregates.keySet()) {
            Feature f = this.findFeature(finalResult, variation);
            configApi = ConfigurationApi.getConfigurationApi((Feature)f);
            apiMapping.put(variation, configApi);
            r = ArtifactRules.getArtifactRules((Feature)f);
            if (r == null) continue;
            rules.put(variation, r);
        }
        for (Feature f : userResult) {
            ProductVariation variation = this.getProductFeatureGenerator().getVariation(f.getId().getClassifier());
            configApi = (ConfigurationApi)apiMapping.get(variation);
            ConfigurationApi.setConfigurationApi((Feature)f, (ConfigurationApi)configApi);
            r = (ArtifactRules)rules.get(variation);
            ArtifactRules.setArtifactRules((Feature)f, (ArtifactRules)r);
        }
        ArrayList<Feature> result = new ArrayList<Feature>();
        result.addAll(userResult);
        result.addAll(finalResult);
        return result;
    }

    Map<String, List<Feature>> getUserAggregates(Map<String, Feature> projectFeatures) throws IOException {
        return this.getUserFeatureAggregator().getUserAggregates(projectFeatures, this.serviceTypes);
    }

    private Feature findFeature(List<Feature> finalFeatures, ProductVariation variation) throws IOException {
        Feature f = this.findFeatureWithClassifier(finalFeatures, variation.getFinalAggregateName());
        if (f == null) {
            f = this.findFeatureWithClassifier(finalFeatures, variation.getFinalAggregateName() + ".prod");
        }
        if (f == null) {
            throw new IOException("Unable to find final feature for variation " + variation);
        }
        return f;
    }

    private Feature findFeatureWithClassifier(List<Feature> features, String classifier) {
        for (Feature f : features) {
            if (!f.getId().getClassifier().equals(classifier)) continue;
            return f;
        }
        return null;
    }

    private Map<String, Feature> readFeatures() throws IOException {
        HashMap<String, Feature> result = new HashMap<String, Feature>();
        for (File f : this.getFeatureInputDirectory().listFiles()) {
            if (!f.getName().endsWith(".json") && (!f.getName().endsWith(".slingosgifeature") || f.getName().startsWith("."))) continue;
            this.logger.info("Reading feature model {}...", (Object)f.getName());
            try (FileReader reader = new FileReader(f);){
                Feature feature = FeatureJSONReader.read((Reader)reader, (String)f.getName());
                result.put(f.getName(), feature);
            }
        }
        return result;
    }

    Map<ProductVariation, List<Feature>> getProductAggregates() throws IOException {
        Map<ProductVariation, List<Feature>> res = this.getProductFeatureGenerator().getProductAggregates(this.serviceTypes);
        return res;
    }

    final void postProcessProductFeature(Feature feature) {
        ArtifactRules rules = ArtifactRules.getArtifactRules((Feature)feature);
        if (rules != null) {
            for (VersionRule rule : rules.getArtifactVersionRules()) {
                if (rule.getArtifactId() == null || !"zip".equals(rule.getArtifactId().getType())) continue;
                rule.setArtifactId(rule.getArtifactId().changeClassifier("cp2fm-converted"));
            }
            ArtifactRules.setArtifactRules((Feature)feature, (ArtifactRules)rules);
        } else {
            ArtifactRules r = new ArtifactRules();
            r.setMode(org.apache.sling.feature.extension.apiregions.api.artifacts.Mode.LENIENT);
            ArtifactRules.setArtifactRules((Feature)feature, (ArtifactRules)r);
        }
    }

    Map<String, List<Feature>> getFinalAggregates(Map<String, List<Feature>> userAggregate, Map<String, Feature> projectFeatures) throws IOException {
        HashMap<String, List<Feature>> aggregates = new HashMap<String, List<Feature>>();
        for (String name : userAggregate.keySet()) {
            ProductVariation variation = this.getProductFeatureGenerator().getVariation(name);
            String classifier = name.replaceAll("^user-", "");
            List list = aggregates.computeIfAbsent(classifier, n -> new ArrayList());
            list.add(AemAggregator.getNotNull(projectFeatures, variation.getProductAggregateName()));
            list.add(AemAggregator.getNotNull(projectFeatures, name));
        }
        return aggregates;
    }

    private static Feature getNotNull(Map<String, Feature> featureCache, String key) {
        Feature feature = featureCache.get(key);
        if (feature == null) {
            throw new IllegalArgumentException("Did not find a feature with key " + key);
        }
        return feature;
    }

    private void aggregateFeatureInfo(Map<ProductVariation, List<Feature>> productAggregates, Mode product, Map<String, Feature> projectFeatures) throws IOException {
        this.aggregate(productAggregates.entrySet().stream().collect(Collectors.toMap(e -> ((ProductVariation)e.getKey()).getProductAggregateName(), Map.Entry::getValue)), product, projectFeatures);
    }

    List<Feature> aggregate(Map<String, List<Feature>> aggregates, Mode mode, final Map<String, Feature> projectFeatures) throws IOException {
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (Map.Entry<String, List<Feature>> aggregate : aggregates.entrySet()) {
            this.logger.info("Building aggregate feature model {}...", (Object)aggregate.getKey());
            BuilderContext builderContext = new BuilderContext(new FeatureProvider(){

                public Feature provide(ArtifactId id) {
                    for (Feature feat : projectFeatures.values()) {
                        if (!feat.getId().equals((Object)id)) continue;
                        return feat;
                    }
                    return AemAggregator.this.getFeatureProvider().provide(id);
                }
            });
            builderContext.setArtifactProvider(this.getArtifactProvider());
            builderContext.addMergeExtensions((MergeHandler[])StreamSupport.stream(Spliterators.spliteratorUnknownSize(ServiceLoader.load(MergeHandler.class).iterator(), 16), false).toArray(MergeHandler[]::new)).addPostProcessExtensions((PostProcessHandler[])StreamSupport.stream(Spliterators.spliteratorUnknownSize(ServiceLoader.load(PostProcessHandler.class).iterator(), 16), false).toArray(PostProcessHandler[]::new));
            if (mode == Mode.USER || mode == Mode.PRODUCT) {
                builderContext.addArtifactsOverride(ArtifactId.parse((String)"*:*:HIGHEST"));
                builderContext.addArtifactsOverride(ArtifactId.parse((String)"*:*:*:*:HIGHEST"));
            } else if (mode == Mode.FINAL) {
                builderContext.addArtifactsOverride(ArtifactId.parse((String)"com.adobe.cq:core.wcm.components.core:FIRST"));
                builderContext.addArtifactsOverride(ArtifactId.parse((String)"com.adobe.cq:core.wcm.components.extensions.amp:FIRST"));
                builderContext.addArtifactsOverride(ArtifactId.parse((String)"org.apache.sling:org.apache.sling.models.impl:FIRST"));
                builderContext.addArtifactsOverride(ArtifactId.parse((String)"*:core.wcm.components.content:zip:*:FIRST"));
                builderContext.addArtifactsOverride(ArtifactId.parse((String)"*:core.wcm.components.extensions.amp.content:zip:*:FIRST"));
                builderContext.addArtifactsOverride(ArtifactId.parse((String)"*:*:jar:*:ALL"));
            }
            builderContext.addConfigsOverrides(Collections.singletonMap("*", "MERGE_LATEST"));
            ArtifactId newFeatureID = this.getProjectId().changeClassifier(aggregate.getKey()).changeType(FEATUREMODEL_TYPE);
            Feature feature = FeatureBuilder.assemble((ArtifactId)newFeatureID, (BuilderContext)builderContext, (Feature[])aggregate.getValue().toArray(new Feature[aggregate.getValue().size()]));
            if (mode == Mode.FINAL && this.isEnableDuplicateBundleHandling()) {
                this.handleDuplicateBundles(aggregate, feature);
            }
            this.postProcessProductFeature(feature);
            File featureFile = new File(this.getFeatureOutputDirectory(), aggregate.getKey().concat(".json"));
            try (FileWriter writer = new FileWriter(featureFile);){
                FeatureJSONWriter.write((Writer)writer, (Feature)feature);
            }
            if (this.artifactsDeployer != null) {
                this.artifactsDeployer.deploy((ArtifactWriter)new FileArtifactWriter(featureFile), null, newFeatureID);
            }
            projectFeatures.put(aggregate.getKey(), feature);
            result.add(feature);
        }
        return result;
    }

    private void handleDuplicateBundles(Map.Entry<String, List<Feature>> aggregate, Feature feature) throws IOException {
        if (aggregate.getValue().size() != 2) {
            throw new IOException("Expected two features for final aggregate, got " + aggregate.getValue().size());
        }
        Feature productFeature = aggregate.getValue().get(0);
        Feature userFeature = aggregate.getValue().get(1);
        for (Artifact userBundle : userFeature.getBundles()) {
            if (!productFeature.getBundles().contains((Object)userBundle)) continue;
            this.logger.debug("Found duplicate bundle {} in user and product feature.", (Object)userBundle.getId().toMvnId());
            Artifact mergedBundle = feature.getBundles().getExact(userBundle.getId());
            mergedBundle.getMetadata().clear();
            mergedBundle.getMetadata().putAll(userBundle.getMetadata());
            Extension me = feature.getExtensions().getByName("analyser-metadata");
            if (me == null || me.getType() != ExtensionType.JSON) continue;
            JsonObject metadata = me.getJSONStructure().asJsonObject();
            JsonObjectBuilder newMetadataBuilder = Json.createObjectBuilder();
            for (String key : metadata.keySet()) {
                if (key.equals(userBundle.getId().toMvnId())) continue;
                newMetadataBuilder.add(key, (JsonValue)metadata.getJsonObject(key));
            }
            me.setJSONStructure((JsonStructure)newMetadataBuilder.build());
        }
    }

    public static enum Mode {
        USER,
        PRODUCT,
        FINAL;

    }
}

