/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.analyser;

import com.adobe.aem.analyser.AemAnalyserResult;
import com.adobe.aem.analyser.AemAnalyserUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.analyser.Analyser;
import org.apache.sling.feature.analyser.AnalyserResult;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.builder.FeatureProvider;
import org.apache.sling.feature.scanner.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AemAnalyser {
    public static final String DEFAULT_TASKS = "requirements-capabilities,api-regions,api-regions-check-order,api-regions-crossfeature-dups,api-regions-exportsimports,region-deprecated-api";
    public static final String DEFAULT_USER_TASKS = "bundle-content,bundle-resources,bundle-nativecode,bundle-unversioned-packages,artifact-rules,configuration-api,aem-env-var,repoinit,content-packages-validation";
    private static final String BUNDLE_ORIGINS = "content-package-origins";
    private static final String CONFIGURATION_ORIGINS = ":configurator:".concat("content-package-origins");
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ArtifactProvider artifactProvider;
    private FeatureProvider featureProvider;
    private Set<String> includedTasks;
    private Set<String> includedUserTasks;
    private Map<String, Map<String, String>> taskConfigurations;
    private static final String KEY_AUTHOR_AND_PUBLISH = "author and publish";
    private static final String KEY_AUTHOR = "aggregated-author";
    private static final String KEY_PUBLISH = "aggregated-publish";
    private static final String PREFIX = "aggregated-";
    private static final String PREFIX_AUTHOR = "aggregated-author.";
    private static final String PREFIX_PUBLISH = "aggregated-publish.";
    private static final List<String> KEYS = new ArrayList<String>();

    public AemAnalyser() {
        this.setIncludedTasks(new LinkedHashSet<String>(Arrays.asList(DEFAULT_TASKS.split(","))));
        this.setIncludedUserTasks(new LinkedHashSet<String>(Arrays.asList(DEFAULT_USER_TASKS.split(","))));
        this.setTaskConfigurations(new HashMap<String, Map<String, String>>());
    }

    public Set<String> getIncludedTasks() {
        return this.includedTasks;
    }

    public Set<String> getIncludedUserTasks() {
        return this.includedUserTasks;
    }

    public void setIncludedTasks(Set<String> includedTasks) {
        this.includedTasks = includedTasks;
    }

    public void setIncludedUserTasks(Set<String> includedTasks) {
        this.includedUserTasks = includedTasks;
    }

    public Map<String, Map<String, String>> getTaskConfigurations() {
        return this.taskConfigurations;
    }

    public void setTaskConfigurations(Map<String, Map<String, String>> taskConfigurations) {
        this.taskConfigurations = taskConfigurations;
        this.applyDefaultTaskConfigurations();
    }

    private void applyDefaultTaskConfigurations() {
        Map<String, Map<String, String>> config = this.getTaskConfigurations();
        config.computeIfAbsent("api-regions-crossfeature-dups", key -> this.apiRegionsCrossfeatureDupsDefaults());
        config.computeIfAbsent("content-packages-validation", key -> this.contentPackagesValidationDefaults());
        config.computeIfAbsent("api-regions-check-order", key -> this.apiRegionsCheckOrderDefaults());
    }

    private Map<String, String> apiRegionsCrossfeatureDupsDefaults() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("regions", "global,com.adobe.aem.deprecated");
        config.put("definingFeatures", "com.adobe.aem:aem-sdk-api:slingosgifeature:*");
        config.put("warningPackages", "*");
        return config;
    }

    private Map<String, String> contentPackagesValidationDefaults() {
        return Collections.singletonMap("enabled-validators", "jackrabbit-docviewparser");
    }

    private Map<String, String> apiRegionsCheckOrderDefaults() {
        return Collections.singletonMap("order", "global,com.adobe.aem.deprecated,com.adobe.aem.internal");
    }

    public ArtifactProvider getArtifactProvider() {
        return this.artifactProvider;
    }

    public void setArtifactProvider(ArtifactProvider artifactProvider) {
        this.artifactProvider = artifactProvider;
    }

    public FeatureProvider getFeatureProvider() {
        return this.featureProvider;
    }

    public void setFeatureProvider(FeatureProvider featureProvider) {
        this.featureProvider = featureProvider;
    }

    private Scanner createScanner() throws IOException {
        this.logger.debug("Setting up scanner");
        Scanner scanner = new Scanner(this.getArtifactProvider());
        this.logger.debug("Scanner successfully set up : {}", (Object)scanner);
        return scanner;
    }

    private Analyser createAnalyser(Scanner scanner, Set<String> tasks, Map<String, Map<String, String>> configs) throws IOException {
        this.logger.debug("Setting up user analyser with task configurations = {}, included tasks = {}", configs, tasks);
        Analyser analyser = new Analyser(scanner, configs, tasks, null);
        this.logger.debug("Analyser successfully set up : {}", (Object)analyser);
        return analyser;
    }

    protected boolean checkFinalClassifier(String classifier) {
        return KEYS.contains(classifier);
    }

    protected boolean checkUserClassifier(String classifier) {
        return classifier != null && classifier.startsWith("user-") && KEYS.contains(classifier.substring(5));
    }

    public AemAnalyserResult analyse(Collection<Feature> features) throws Exception {
        AemAnalyserResult result = new AemAnalyserResult();
        Scanner scanner = this.createScanner();
        Analyser userAnalyser = this.createAnalyser(scanner, this.getIncludedUserTasks(), this.getTaskConfigurations());
        Analyser finalAnalyser = this.createAnalyser(scanner, this.getIncludedTasks(), this.getTaskConfigurations());
        LinkedHashMap<String, List<String>> featureErrors = new LinkedHashMap<String, List<String>>();
        LinkedHashMap<String, List<String>> featureWarnings = new LinkedHashMap<String, List<String>>();
        for (Feature f : features) {
            String classifier = f.getId().getClassifier();
            String msgKey = null;
            Analyser analyser = null;
            if (this.checkFinalClassifier(classifier)) {
                msgKey = classifier;
                analyser = finalAnalyser;
            } else if (this.checkUserClassifier(classifier)) {
                msgKey = classifier.substring(5);
                analyser = userAnalyser;
            }
            if (analyser == null) {
                this.logger.info("Skipping unused feature {}", (Object)f.getId());
                continue;
            }
            AnalyserResult r = analyser.analyse(f, null, this.featureProvider);
            for (AnalyserResult.GlobalReport report : r.getGlobalErrors()) {
                featureErrors.computeIfAbsent(msgKey, key -> new ArrayList()).add(report.toString());
            }
            for (AnalyserResult.GlobalReport report : r.getArtifactErrors()) {
                featureErrors.computeIfAbsent(msgKey, key -> new ArrayList()).add(this.getArtifactMessage(f, (AnalyserResult.ArtifactReport)report));
            }
            for (AnalyserResult.GlobalReport report : r.getExtensionErrors()) {
                featureErrors.computeIfAbsent(msgKey, key -> new ArrayList()).add(report.toString());
            }
            for (AnalyserResult.GlobalReport report : r.getConfigurationErrors()) {
                featureErrors.computeIfAbsent(msgKey, key -> new ArrayList()).add(this.getConfigurationMessage(f, (AnalyserResult.ConfigurationReport)report));
            }
            for (AnalyserResult.GlobalReport report : r.getGlobalWarnings()) {
                featureWarnings.computeIfAbsent(msgKey, key -> new ArrayList()).add(report.toString());
            }
            for (AnalyserResult.GlobalReport report : r.getArtifactWarnings()) {
                featureWarnings.computeIfAbsent(msgKey, key -> new ArrayList()).add(this.getArtifactMessage(f, (AnalyserResult.ArtifactReport)report));
            }
            for (AnalyserResult.GlobalReport report : r.getExtensionWarnings()) {
                featureWarnings.computeIfAbsent(msgKey, key -> new ArrayList()).add(report.toString());
            }
            for (AnalyserResult.GlobalReport report : r.getConfigurationWarnings()) {
                featureWarnings.computeIfAbsent(msgKey, key -> new ArrayList()).add(this.getConfigurationMessage(f, (AnalyserResult.ConfigurationReport)report));
            }
        }
        this.logOutput(result.getErrors(), featureErrors, "errors");
        this.logOutput(result.getWarnings(), featureWarnings, "warnings");
        return result;
    }

    private String getConfigurationMessage(Feature f, AnalyserResult.ConfigurationReport report) {
        Object val = ((Configuration)report.getKey()).getProperties().get(CONFIGURATION_ORIGINS);
        if (val != null) {
            return report.toString().concat(" (").concat(val.toString()).concat(")");
        }
        return report.toString();
    }

    private String getArtifactMessage(Feature f, AnalyserResult.ArtifactReport report) {
        Object val;
        Artifact artifact = f.getBundles().getExact((ArtifactId)report.getKey());
        if (artifact == null) {
            block0: for (Extension ext : f.getExtensions()) {
                if (ext.getType() != ExtensionType.ARTIFACTS) continue;
                for (Artifact c : ext.getArtifacts()) {
                    if (!c.getId().equals(report.getKey())) continue;
                    artifact = c;
                    continue block0;
                }
            }
        }
        if (artifact != null && (val = artifact.getMetadata().get(BUNDLE_ORIGINS)) != null) {
            return report.toString().concat(" (").concat(val.toString()).concat(")");
        }
        return report.toString();
    }

    private List<String> getTierMessages(Map<String, List<String>> messages, String tier) {
        List<String> msgs = messages.get(tier);
        if (msgs == null) {
            msgs = new ArrayList<String>();
            msgs.addAll(messages.getOrDefault(tier.concat(".dev"), Collections.emptyList()));
            msgs.retainAll(messages.getOrDefault(tier.concat(".stage"), Collections.emptyList()));
            msgs.retainAll(messages.getOrDefault(tier.concat(".prod"), Collections.emptyList()));
            messages.put(tier, msgs);
        }
        return msgs;
    }

    protected void logOutput(List<String> output, Map<String, List<String>> messages, String type) {
        List<String> authorMsgs = this.getTierMessages(messages, KEY_AUTHOR);
        List<String> publishMsgs = this.getTierMessages(messages, KEY_PUBLISH);
        for (Map.Entry<String, List<String>> entry : messages.entrySet()) {
            if (entry.getKey().startsWith(PREFIX_AUTHOR)) {
                entry.getValue().removeAll(authorMsgs);
            }
            if (!entry.getKey().startsWith(PREFIX_PUBLISH)) continue;
            entry.getValue().removeAll(publishMsgs);
        }
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(authorMsgs);
        list.retainAll(publishMsgs);
        if (!list.isEmpty()) {
            messages.put(KEY_AUTHOR_AND_PUBLISH, list);
            authorMsgs.removeAll(list);
            publishMsgs.removeAll(list);
        }
        for (String k : KEYS) {
            List<String> m = messages.get(k);
            if (m == null || m.isEmpty()) continue;
            String id = k.startsWith(PREFIX) ? k.substring(PREFIX.length()) : k;
            output.add("The analyser found the following ".concat(type).concat(" for ").concat(id).concat(" : "));
            m.stream().forEach(t -> output.add((String)t));
        }
    }

    static {
        KEYS.add(KEY_AUTHOR_AND_PUBLISH);
        for (String k : AemAnalyserUtil.USED_MODES) {
            KEYS.add(PREFIX.concat(k));
        }
    }
}

