/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util.impl;

import com.adobe.acs.commons.util.RequireAem;
import com.adobe.granite.license.ProductInfo;
import com.adobe.granite.license.ProductInfoProvider;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={}, immediate=true)
public class RequireAemImpl
implements RequireAem {
    private static final Logger log = LoggerFactory.getLogger(RequireAemImpl.class);
    private static final String PN_DISTRIBUTION = "distribution";
    private static final String PN_VERSION = "version";
    private static final Version originalCloudServiceVersion = new Version(2019, 12, 0);
    @Reference
    private ProductInfoProvider productInfoProvider;
    private ProductInfo productInfo;
    private ServiceRegistration<?> serviceRegistration;

    @Override
    public RequireAem.Distribution getDistribution() {
        if (this.productInfo.getVersion().compareTo(originalCloudServiceVersion) > 0) {
            return RequireAem.Distribution.CLOUD_READY;
        }
        return RequireAem.Distribution.CLASSIC;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.productInfo = this.productInfoProvider.getProductInfo();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        String version = this.productInfo.getShortVersion();
        String distribution = RequireAem.Distribution.CLOUD_READY.equals((Object)this.getDistribution()) ? RequireAem.Distribution.CLOUD_READY.getValue() : RequireAem.Distribution.CLASSIC.getValue();
        ((Dictionary)properties).put(PN_DISTRIBUTION, distribution);
        ((Dictionary)properties).put(PN_VERSION, version);
        this.serviceRegistration = bundleContext.registerService(RequireAem.class.getName(), (Object)this, properties);
        log.info("Registering [ RequireAem.class ] as an OSGi Service with OSGi properties [ distribution = {}, version = {} ] so it can be used to enable/disable other OSGi Components", ((Dictionary)properties).get(PN_DISTRIBUTION), ((Dictionary)properties).get(PN_VERSION));
    }

    @Deactivate
    protected void deactivate() {
        this.productInfo = null;
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
    }
}

